/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.handler;

import com.blade.Blade;
import com.blade.exception.BladeException;
import com.blade.exception.ValidatorException;
import com.blade.mvc.WebContext;
import com.blade.mvc.handler.ExceptionHandler;
import com.blade.mvc.http.RawBody;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.mvc.ui.HtmlCreator;
import com.blade.mvc.ui.ModelAndView;
import com.blade.mvc.ui.RestResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExceptionHandler
implements ExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultExceptionHandler.class);

    @Override
    public void handle(Exception e) {
        if (!ExceptionHandler.isResetByPeer(e)) {
            Response response = WebContext.response();
            Request request = WebContext.request();
            if (e instanceof BladeException) {
                this.handleBladeException((BladeException)e, request, response);
            } else if (ValidatorException.class.isInstance(e)) {
                this.handleValidators((ValidatorException)ValidatorException.class.cast(e), request, response);
            } else {
                this.handleException(e, request, response);
            }
        }
    }

    protected void handleValidators(ValidatorException validatorException, Request request, Response response) {
        Integer code = Optional.ofNullable(validatorException.getCode()).orElse(500);
        if (request.isAjax() || request.contentType().toLowerCase().contains("json")) {
            response.json(RestResponse.fail(code, validatorException.getMessage()));
        } else {
            this.handleException(validatorException, request, response);
        }
    }

    protected void handleException(Exception e, Request request, Response response) {
        log.error("Request Exception", (Throwable)e);
        if (null == response) {
            return;
        }
        response.status(500);
        request.attribute("title", "500 Internal Server Error");
        request.attribute("message", e.getMessage());
        request.attribute("stackTrace", this.getStackTrace(e));
        this.render500(request, response);
    }

    protected void handleBladeException(BladeException e, Request request, Response response) {
        Blade blade = WebContext.blade();
        response.status(e.getStatus());
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.add("title", e.getStatus() + " " + e.getName());
        modelAndView.add("message", e.getMessage());
        if (null != e.getCause()) {
            request.attribute("stackTrace", this.getStackTrace(e));
        }
        if (e.getStatus() == 500) {
            log.error("Request Exception", (Throwable)e);
            this.render500(request, response);
        }
        if (e.getStatus() == 404) {
            Optional<String> page404 = Optional.ofNullable(blade.environment().get("mvc.view.404", null));
            if (page404.isPresent()) {
                modelAndView.setView(page404.get());
                this.renderPage(response, modelAndView);
                response.render(page404.get());
            } else {
                HtmlCreator htmlCreator = new HtmlCreator();
                htmlCreator.center("<h1>404 Not Found - " + request.uri() + "</h1>");
                htmlCreator.hr();
                response.html(htmlCreator.html());
            }
        }
    }

    protected void render500(Request request, Response response) {
        Blade blade = WebContext.blade();
        Optional<String> page500 = Optional.ofNullable(blade.environment().get("mvc.view.500", null));
        if (page500.isPresent()) {
            this.renderPage(response, new ModelAndView(page500.get()));
        } else if (blade.devMode()) {
            HtmlCreator htmlCreator = new HtmlCreator();
            htmlCreator.center("<h1>" + request.attribute("title") + "</h1>");
            htmlCreator.startP("message-header");
            htmlCreator.add("Request URI: " + request.uri());
            htmlCreator.startP("message-header");
            htmlCreator.add("Error Message: " + request.attribute("message"));
            htmlCreator.endP();
            if (null != request.attribute("stackTrace")) {
                htmlCreator.startP("message-body");
                htmlCreator.add(request.attribute("stackTrace").toString().replace("\n", "<br/>"));
                htmlCreator.endP();
            }
            response.html(htmlCreator.html());
        } else {
            response.html("<center><h1>500 Internal Server Error</h1><hr/></center>");
        }
    }

    protected void renderPage(Response response, ModelAndView modelAndView) {
        StringWriter sw = new StringWriter();
        try {
            WebContext.blade().templateEngine().render(modelAndView, sw);
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])sw.toString().getBytes("utf-8"));
            DefaultFullHttpResponse fullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.statusCode()), buffer);
            response.body(new RawBody((FullHttpResponse)fullHttpResponse));
        }
        catch (Exception e) {
            log.error("Render view error", (Throwable)e);
        }
    }

    protected String getStackTrace(Throwable exception) {
        StringWriter errors = new StringWriter();
        exception.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }
}

