/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.http.session;

import com.blade.event.Event;
import com.blade.event.EventManager;
import com.blade.event.EventType;
import com.blade.mvc.http.Session;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SessionManager {
    private EventManager eventManager;
    private Map<String, Session> sessionMap = new ConcurrentHashMap<String, Session>();

    public SessionManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public Session getSession(String id) {
        return this.sessionMap.get(id);
    }

    public void createSession(Session session) {
        this.sessionMap.put(session.id(), session);
        Event event = new Event();
        event.attribute("session", session);
        this.eventManager.fireEvent(EventType.SESSION_CREATED, event);
    }

    public void clear() {
        this.sessionMap.clear();
    }

    public void destorySession(Session session) {
        session.attributes().clear();
        this.sessionMap.remove(session.id());
        Event event = new Event();
        event.attribute("session", session);
        this.eventManager.fireEvent(EventType.SESSION_DESTROY, event);
    }

    public Map<String, Session> sessionMap() {
        return this.sessionMap;
    }
}

