/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.multipart;

import com.blade.kit.json.JsonIgnore;
import java.util.Arrays;

public class FileItem {
    private String name;
    private String fileName;
    private String contentType;
    private long length;
    @JsonIgnore
    private byte[] data;

    public FileItem(String name, String fileName, String contentType, long length) {
        this.name = name;
        this.fileName = fileName;
        this.contentType = contentType;
        this.length = length;
    }

    public String toString() {
        long kb = this.length / 1024L;
        return "FileItem(name='" + this.name + '\'' + ", fileName='" + this.fileName + '\'' + ", contentType='" + this.contentType + '\'' + ", size=" + (kb < 1L ? 1L : kb) + "KB)";
    }

    private FileItem() {
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getLength() {
        return this.length;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileItem)) {
            return false;
        }
        FileItem other = (FileItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        long $length = this.getLength();
        result = result * 59 + (int)($length >>> 32 ^ $length);
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }
}

