/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.route;

import com.blade.kit.StringKit;
import com.blade.mvc.route.PathBuilderMeta;
import java.util.Arrays;

public class PathRegexBuilder {
    private static final String PATH_VARIABLE_REPLACE = "([^/]+)";
    private static final String DEFAULT_SEPARATOR = "/";
    private static final String DEFAULT_START = "(/";
    private static final String DEFAULT_END = ")|";
    private final StringBuilder pathBuilder;
    private final String separator;

    public PathRegexBuilder(StringBuilder pathBuilder, String separator) {
        this.pathBuilder = pathBuilder;
        this.separator = separator;
    }

    public PathRegexBuilder(StringBuilder pathBuilder) {
        this.pathBuilder = pathBuilder;
        this.separator = DEFAULT_SEPARATOR;
    }

    public PathRegexBuilder() {
        this.pathBuilder = new StringBuilder(DEFAULT_START);
        this.separator = DEFAULT_SEPARATOR;
    }

    public PathRegexBuilder join(String content) {
        this.pathBuilder.append(content).append(this.separator);
        return this;
    }

    public String build(boolean isSuffix) {
        if (isSuffix) {
            this.pathBuilder.append(DEFAULT_END);
        }
        return this.pathBuilder.toString();
    }

    public String parsePath(String path) {
        if (StringKit.isBlank(path)) {
            return path;
        }
        String[] pathModule = path.split(DEFAULT_SEPARATOR);
        Arrays.stream(pathModule).filter(row -> !row.isEmpty()).map(row -> {
            if (row.indexOf(":") == -1) {
                return new PathBuilderMeta.PathBuilder().withName((String)row).withType(PathBuilderMeta.PathTypeEnum.COMMON).build();
            }
            String[] itemPath = row.split(":");
            if (StringKit.isBlank(itemPath[0])) {
                return new PathBuilderMeta.PathBuilder().withName(itemPath[1]).withRegex(PATH_VARIABLE_REPLACE).withType(PathBuilderMeta.PathTypeEnum.PARAM).build();
            }
            return new PathBuilderMeta.PathBuilder().withName(itemPath[0]).withRegex("(" + itemPath[1] + ")").withType(PathBuilderMeta.PathTypeEnum.REGEX).build();
        }).forEach(row -> {
            if (row.getType() == PathBuilderMeta.PathTypeEnum.COMMON) {
                this.join(row.getName());
            } else {
                this.join(row.getRegex());
            }
        });
        this.pathBuilder.deleteCharAt(this.pathBuilder.length() - 1);
        return this.build(true);
    }
}

