/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.route;

import com.blade.ioc.annotation.Order;
import com.blade.kit.Assert;
import com.blade.kit.BladeKit;
import com.blade.kit.PathKit;
import com.blade.kit.ReflectKit;
import com.blade.kit.StringKit;
import com.blade.mvc.RouteContext;
import com.blade.mvc.handler.RouteHandler;
import com.blade.mvc.handler.RouteHandler0;
import com.blade.mvc.hook.Signature;
import com.blade.mvc.hook.WebHook;
import com.blade.mvc.http.HttpMethod;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.mvc.route.PathRegexBuilder;
import com.blade.mvc.route.Route;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteMatcher {
    private static final Logger log = LoggerFactory.getLogger(RouteMatcher.class);
    private static final Pattern PATH_VARIABLE_PATTERN = Pattern.compile("/([^:/]*):([^/]+)");
    private static final String METHOD_NAME = "handle";
    private Map<String, Route> routes = new HashMap<String, Route>();
    private Map<String, List<Route>> hooks = new HashMap<String, List<Route>>();
    private List<Route> middleware = null;
    private Map<String, Method[]> classMethodPool = new ConcurrentHashMap<String, Method[]>();
    private Map<Class<?>, Object> controllerPool = new ConcurrentHashMap();
    private Map<HttpMethod, Map<Integer, FastRouteMappingInfo>> regexRoutes = new HashMap<HttpMethod, Map<Integer, FastRouteMappingInfo>>();
    private Map<String, Route> staticRoutes = new HashMap<String, Route>();
    private Map<HttpMethod, Pattern> regexRoutePatterns = new HashMap<HttpMethod, Pattern>();
    private Map<HttpMethod, Integer> indexes = new HashMap<HttpMethod, Integer>();
    private Map<HttpMethod, StringBuilder> patternBuilders = new HashMap<HttpMethod, StringBuilder>();
    private List<String> webSockets = new ArrayList<String>(4);

    @Deprecated
    private Route addRoute(HttpMethod httpMethod, String path, RouteHandler0 handler, String methodName) throws NoSuchMethodException {
        Class<?> handleType = handler.getClass();
        Method method = handleType.getMethod(methodName, Request.class, Response.class);
        return this.addRoute(httpMethod, path, handler, RouteHandler0.class, method);
    }

    private Route addRoute(HttpMethod httpMethod, String path, RouteHandler handler, String methodName) throws NoSuchMethodException {
        Class<?> handleType = handler.getClass();
        Method method = handleType.getMethod(methodName, RouteContext.class);
        return this.addRoute(httpMethod, path, handler, RouteHandler.class, method);
    }

    Route addRoute(Route route) {
        String path = route.getPath();
        HttpMethod httpMethod = route.getHttpMethod();
        Object controller = route.getTarget();
        Class<?> controllerType = route.getTargetType();
        Method method = route.getAction();
        return this.addRoute(httpMethod, path, controller, controllerType, method);
    }

    private Route addRoute(HttpMethod httpMethod, String path, Object controller, Class<?> controllerType, Method method) {
        path = "*".equals(path) ? "/.*" : path;
        String key = (path = path.replace("/**", "/.*").replace("/*", "/.*")) + "#" + httpMethod.toString();
        if (this.routes.containsKey(key)) {
            log.warn("\tRoute {} -> {} has exist", (Object)path, (Object)httpMethod.toString());
        }
        Route route = new Route(httpMethod, path, controller, controllerType, method);
        if (BladeKit.isWebHook(httpMethod)) {
            Order order = controllerType.getAnnotation(Order.class);
            if (null != order) {
                route.setSort(order.value());
            }
            if (this.hooks.containsKey(key)) {
                this.hooks.get(key).add(route);
            } else {
                ArrayList<Route> empty = new ArrayList<Route>();
                empty.add(route);
                this.hooks.put(key, empty);
            }
        } else {
            this.routes.put(key, route);
        }
        return route;
    }

    @Deprecated
    public Route addRoute(String path, RouteHandler0 handler, HttpMethod httpMethod) {
        try {
            return this.addRoute(httpMethod, path, handler, METHOD_NAME);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public Route addRoute(String path, RouteHandler handler, HttpMethod httpMethod) {
        try {
            return this.addRoute(httpMethod, path, handler, METHOD_NAME);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public void route(String path, Class<?> clazz, String methodName) {
        Assert.notNull(methodName, "Method name not is null");
        HttpMethod httpMethod = HttpMethod.ALL;
        if (methodName.contains(":")) {
            String[] methodArr = methodName.split(":");
            httpMethod = HttpMethod.valueOf(methodArr[0].toUpperCase());
            methodName = methodArr[1];
        }
        this.route(path, clazz, methodName, httpMethod);
    }

    public void route(String path, Class<?> clazz, String methodName, HttpMethod httpMethod) {
        try {
            Assert.notNull(path, "Route path not is null!");
            Assert.notNull(clazz, "Route type not is null!");
            Assert.notNull(methodName, "Method name not is null");
            Assert.notNull((Object)httpMethod, "Request Method not is null");
            Method[] methods = this.classMethodPool.computeIfAbsent(clazz.getName(), k -> clazz.getMethods());
            if (null == methods) {
                return;
            }
            for (Method method : methods) {
                if (!method.getName().equals(methodName)) continue;
                Object controller = this.controllerPool.computeIfAbsent(clazz, k -> ReflectKit.newInstance(clazz));
                this.addRoute(httpMethod, path, controller, clazz, method);
            }
        }
        catch (Exception e) {
            log.error("Add route method error", (Throwable)e);
        }
    }

    public Route lookupRoute(String httpMethod, String path) {
        String routeKey = (path = this.parsePath(path)) + '#' + httpMethod.toUpperCase();
        Route route = this.staticRoutes.get(routeKey);
        if (null != route) {
            return route;
        }
        route = this.staticRoutes.get(path + "#ALL");
        if (null != route) {
            return route;
        }
        LinkedHashMap<String, String> uriVariables = new LinkedHashMap<String, String>();
        HttpMethod requestMethod = HttpMethod.valueOf(httpMethod);
        Pattern pattern = this.regexRoutePatterns.get((Object)requestMethod);
        if (null == pattern && null != (pattern = this.regexRoutePatterns.get((Object)HttpMethod.ALL))) {
            requestMethod = HttpMethod.ALL;
        }
        if (null == pattern) {
            return null;
        }
        Matcher matcher = null;
        if (path != null) {
            matcher = pattern.matcher(path);
        }
        boolean matched = false;
        if (matcher != null) {
            matched = matcher.matches();
        }
        if (!matched) {
            requestMethod = HttpMethod.ALL;
            pattern = this.regexRoutePatterns.get((Object)requestMethod);
            if (null == pattern) {
                return null;
            }
            if (path != null) {
                matcher = pattern.matcher(path);
            }
            boolean bl = matched = matcher != null && matcher.matches();
        }
        if (matched) {
            String uriVariable;
            int i = 1;
            while (matcher.group(i) == null) {
                ++i;
            }
            FastRouteMappingInfo mappingInfo = this.regexRoutes.get((Object)requestMethod).get(i);
            route = mappingInfo.getRoute();
            int j = 0;
            while (++i <= matcher.groupCount() && (uriVariable = matcher.group(i)) != null) {
                String pathVariable = this.cleanPathVariable(mappingInfo.getVariableNames().get(j++));
                uriVariables.put(pathVariable, uriVariable);
            }
            route.setPathParams(uriVariables);
            log.trace("lookup path: " + path + " uri variables: " + uriVariables);
        }
        return route;
    }

    private String cleanPathVariable(String pathVariable) {
        if (pathVariable.contains(".")) {
            return pathVariable.substring(0, pathVariable.indexOf(46));
        }
        return pathVariable;
    }

    public boolean hasBeforeHook() {
        return this.hooks.values().stream().flatMap(Collection::stream).anyMatch(route -> route.getHttpMethod().equals((Object)HttpMethod.BEFORE));
    }

    public boolean hasAfterHook() {
        return this.hooks.values().stream().flatMap(Collection::stream).anyMatch(route -> route.getHttpMethod().equals((Object)HttpMethod.AFTER));
    }

    public List<Route> getBefore(String path) {
        String cleanPath = this.parsePath(path);
        List<Route> collect = this.hooks.values().stream().flatMap(Collection::stream).sorted(Comparator.comparingInt(Route::getSort)).filter(route -> route.getHttpMethod() == HttpMethod.BEFORE && this.matchesPath(route.getPath(), cleanPath)).collect(Collectors.toList());
        this.giveMatch(path, collect);
        return collect;
    }

    public List<Route> getAfter(String path) {
        String cleanPath = this.parsePath(path);
        List<Route> afters = this.hooks.values().stream().flatMap(Collection::stream).sorted(Comparator.comparingInt(Route::getSort)).filter(route -> route.getHttpMethod() == HttpMethod.AFTER && this.matchesPath(route.getPath(), cleanPath)).collect(Collectors.toList());
        this.giveMatch(path, afters);
        return afters;
    }

    public List<Route> getMiddleware() {
        return this.middleware;
    }

    private void giveMatch(String uri, List<Route> routes) {
        routes.stream().sorted((o1, o2) -> {
            if (o2.getPath().equals(uri)) {
                return o2.getPath().indexOf(uri);
            }
            return -1;
        });
    }

    private boolean matchesPath(String routePath, String pathToMatch) {
        routePath = PathKit.VAR_REGEXP_PATTERN.matcher(routePath).replaceAll("([^#/?.]+)");
        return pathToMatch.matches("(?i)" + routePath);
    }

    private String parsePath(String path) {
        path = PathKit.fixPath(path);
        try {
            URI uri = new URI(path);
            return uri.getPath();
        }
        catch (URISyntaxException e) {
            return path;
        }
    }

    public void register() {
        this.routes.values().forEach(route -> BladeKit.logAddRoute(log, route));
        this.hooks.values().stream().flatMap(Collection::stream).forEach(route -> BladeKit.logAddRoute(log, route));
        Stream.of(this.routes.values(), this.hooks.values().stream().findAny().orElse(new ArrayList())).flatMap(Collection::stream).forEach(this::registerRoute);
        this.patternBuilders.keySet().stream().filter(BladeKit::notIsWebHook).forEach(httpMethod -> {
            StringBuilder patternBuilder = this.patternBuilders.get(httpMethod);
            if (patternBuilder.length() > 1) {
                patternBuilder.setCharAt(patternBuilder.length() - 1, '$');
            }
            log.debug("Fast Route Method: {}, regex: {}", (Object)httpMethod, (Object)patternBuilder);
            this.regexRoutePatterns.put((HttpMethod)((Object)httpMethod), Pattern.compile(patternBuilder.toString()));
        });
        this.webSockets.forEach(path -> BladeKit.logWebSocket(log, path));
    }

    private void registerRoute(Route route) {
        String path = this.parsePath(route.getPath());
        Matcher matcher = null;
        if (path != null) {
            matcher = PATH_VARIABLE_PATTERN.matcher(path);
        }
        boolean find = false;
        ArrayList<String> uriVariableNames = new ArrayList<String>();
        while (matcher != null && matcher.find()) {
            if (!find) {
                find = true;
            }
            String regexName = matcher.group(1);
            String regexValue = matcher.group(2);
            if (StringKit.isBlank(regexName)) {
                uriVariableNames.add(regexValue);
                continue;
            }
            uriVariableNames.add(regexName);
        }
        HttpMethod httpMethod = route.getHttpMethod();
        if (find || BladeKit.isWebHook(httpMethod)) {
            if (this.regexRoutes.get((Object)httpMethod) == null) {
                this.regexRoutes.put(httpMethod, new HashMap());
                this.patternBuilders.put(httpMethod, new StringBuilder("^"));
                this.indexes.put(httpMethod, 1);
            }
            int i = this.indexes.get((Object)httpMethod);
            this.regexRoutes.get((Object)httpMethod).put(i, new FastRouteMappingInfo(route, uriVariableNames));
            this.indexes.put(httpMethod, i + uriVariableNames.size() + 1);
            this.patternBuilders.get((Object)httpMethod).append(new PathRegexBuilder().parsePath(path));
        } else {
            String routeKey = path + '#' + httpMethod.toString();
            this.staticRoutes.putIfAbsent(routeKey, route);
        }
    }

    public Map<String, Route> getRoutes() {
        return this.routes;
    }

    public List<String> getWebSockets() {
        return this.webSockets;
    }

    public Map<String, List<Route>> getHooks() {
        return this.hooks;
    }

    public Map<String, Route> getStaticRoutes() {
        return this.staticRoutes;
    }

    public void clear() {
        this.routes.clear();
        this.hooks.clear();
        this.classMethodPool.clear();
        this.controllerPool.clear();
        this.regexRoutePatterns.clear();
        this.staticRoutes.clear();
        this.regexRoutes.clear();
        this.indexes.clear();
        this.patternBuilders.clear();
    }

    public void initMiddleware(List<WebHook> hooks) {
        this.middleware = hooks.stream().map(webHook -> {
            Method method = ReflectKit.getMethod(WebHook.class, "before", Signature.class);
            return new Route(HttpMethod.BEFORE, "/.*", webHook, WebHook.class, method);
        }).collect(Collectors.toList());
    }

    public void addWebSocket(String path) {
        this.webSockets.add(path);
    }

    private class FastRouteMappingInfo {
        Route route;
        List<String> variableNames;

        FastRouteMappingInfo(Route route, List<String> variableNames) {
            this.route = route;
            this.variableNames = variableNames;
        }

        public Route getRoute() {
            return this.route;
        }

        List<String> getVariableNames() {
            return this.variableNames;
        }
    }
}

