/*
 * Decompiled with CFR 0.152.
 */
package com.blade.security.web.auth;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AuthOption {
    private String realm;
    private Set<String> urlStartExclusions;
    private Map<String, String> accounts;

    public AuthOption addUser(String username, String password) {
        this.accounts.put(username, password);
        return this;
    }

    public AuthOption urlStartExclusions(String ... urls) {
        this.urlStartExclusions.clear();
        this.urlStartExclusions.addAll(Arrays.asList(urls));
        return this;
    }

    public AuthOption addUrlStartExclusion(String url) {
        this.urlStartExclusions.add(url);
        return this;
    }

    private static String $default$realm() {
        return "Authorization Required";
    }

    private static Set<String> $default$urlStartExclusions() {
        return new HashSet<String>(Arrays.asList("/"));
    }

    private static Map<String, String> $default$accounts() {
        return new HashMap<String, String>();
    }

    public static AuthOptionBuilder builder() {
        return new AuthOptionBuilder();
    }

    public String getRealm() {
        return this.realm;
    }

    public Set<String> getUrlStartExclusions() {
        return this.urlStartExclusions;
    }

    public Map<String, String> getAccounts() {
        return this.accounts;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setUrlStartExclusions(Set<String> urlStartExclusions) {
        this.urlStartExclusions = urlStartExclusions;
    }

    public void setAccounts(Map<String, String> accounts) {
        this.accounts = accounts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthOption)) {
            return false;
        }
        AuthOption other = (AuthOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$realm = this.getRealm();
        String other$realm = other.getRealm();
        if (this$realm == null ? other$realm != null : !this$realm.equals(other$realm)) {
            return false;
        }
        Set<String> this$urlStartExclusions = this.getUrlStartExclusions();
        Set<String> other$urlStartExclusions = other.getUrlStartExclusions();
        if (this$urlStartExclusions == null ? other$urlStartExclusions != null : !((Object)this$urlStartExclusions).equals(other$urlStartExclusions)) {
            return false;
        }
        Map<String, String> this$accounts = this.getAccounts();
        Map<String, String> other$accounts = other.getAccounts();
        return !(this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthOption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $realm = this.getRealm();
        result = result * 59 + ($realm == null ? 43 : $realm.hashCode());
        Set<String> $urlStartExclusions = this.getUrlStartExclusions();
        result = result * 59 + ($urlStartExclusions == null ? 43 : ((Object)$urlStartExclusions).hashCode());
        Map<String, String> $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        return result;
    }

    public String toString() {
        return "AuthOption(realm=" + this.getRealm() + ", urlStartExclusions=" + this.getUrlStartExclusions() + ", accounts=" + this.getAccounts() + ")";
    }

    public AuthOption() {
    }

    public AuthOption(String realm, Set<String> urlStartExclusions, Map<String, String> accounts) {
        this.realm = realm;
        this.urlStartExclusions = urlStartExclusions;
        this.accounts = accounts;
    }

    public static class AuthOptionBuilder {
        private boolean realm$set;
        private String realm;
        private boolean urlStartExclusions$set;
        private Set<String> urlStartExclusions;
        private boolean accounts$set;
        private Map<String, String> accounts;

        AuthOptionBuilder() {
        }

        public AuthOptionBuilder realm(String realm) {
            this.realm = realm;
            this.realm$set = true;
            return this;
        }

        public AuthOptionBuilder urlStartExclusions(Set<String> urlStartExclusions) {
            this.urlStartExclusions = urlStartExclusions;
            this.urlStartExclusions$set = true;
            return this;
        }

        public AuthOptionBuilder accounts(Map<String, String> accounts) {
            this.accounts = accounts;
            this.accounts$set = true;
            return this;
        }

        public AuthOption build() {
            String realm = this.realm;
            if (!this.realm$set) {
                realm = AuthOption.$default$realm();
            }
            Set urlStartExclusions = this.urlStartExclusions;
            if (!this.urlStartExclusions$set) {
                urlStartExclusions = AuthOption.$default$urlStartExclusions();
            }
            Map accounts = this.accounts;
            if (!this.accounts$set) {
                accounts = AuthOption.$default$accounts();
            }
            return new AuthOption(realm, urlStartExclusions, accounts);
        }

        public String toString() {
            return "AuthOption.AuthOptionBuilder(realm=" + this.realm + ", urlStartExclusions=" + this.urlStartExclusions + ", accounts=" + this.accounts + ")";
        }
    }
}

