/*
 * Decompiled with CFR 0.152.
 */
package com.blade.security.web.csrf;

import com.blade.kit.PasswordKit;
import com.blade.kit.StringKit;
import com.blade.kit.UUID;
import com.blade.mvc.RouteContext;
import com.blade.mvc.hook.WebHook;
import com.blade.security.web.csrf.CsrfOption;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsrfMiddleware
implements WebHook {
    private static final Logger log = LoggerFactory.getLogger(CsrfMiddleware.class);
    private CsrfOption csrfOption = CsrfOption.builder().build();
    private final String sessionToken = "_csrf_token_session";

    public CsrfMiddleware(CsrfOption csrfOption) {
        this.csrfOption = csrfOption;
    }

    @Override
    public boolean before(RouteContext context) {
        if (this.csrfOption.isIgnoreMethod(context.method())) {
            if (this.csrfOption.isStartExclusion(context.uri())) {
                return true;
            }
            this.genToken(context);
            return true;
        }
        if (this.csrfOption.isExclusion(context.uri())) {
            return true;
        }
        String tokenUUID = (String)context.session().attribute("_csrf_token_session");
        if (StringKit.isEmpty(tokenUUID)) {
            this.csrfOption.getErrorHandler().accept(context);
            return false;
        }
        String token = this.csrfOption.getTokenGetter().apply(context.request());
        if (StringKit.isEmpty(token)) {
            this.csrfOption.getErrorHandler().accept(context);
            return false;
        }
        String hash = new String(Base64.getDecoder().decode(token));
        if (!PasswordKit.checkPassword(tokenUUID, hash)) {
            this.csrfOption.getErrorHandler().accept(context);
            return false;
        }
        return true;
    }

    public String genToken(RouteContext context) {
        String tokenUUID = (String)context.session().attribute("_csrf_token_session");
        if (StringKit.isEmpty(tokenUUID)) {
            tokenUUID = UUID.UU64();
            context.session().attribute("_csrf_token_session", tokenUUID);
        }
        String token = Base64.getEncoder().encodeToString(PasswordKit.hashPassword(tokenUUID).getBytes());
        context.attribute("_csrf_token", token);
        context.attribute("_csrf_token_input", "<input type='hidden' name='_token' value='" + token + "'/>");
        return token;
    }

    public CsrfMiddleware() {
    }
}

