/*
 * Decompiled with CFR 0.152.
 */
package com.blade.security.web.csrf;

import com.blade.kit.StringKit;
import com.blade.mvc.RouteContext;
import com.blade.mvc.http.Request;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;

public class CsrfOption {
    static final Set<String> DEFAULT_IGNORE_METHODS = new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS", "PUT", "DELETE"));
    static final Consumer<RouteContext> DEFAULT_ERROR_HANDLER = context -> context.badRequest().text("CSRF token mismatch.");
    static final Function<Request, String> DEFAULT_TOKEN_GETTER = request -> request.query("_token").orElseGet(() -> {
        if (StringKit.isNotBlank(request.header("X-CSRF-TOKEN"))) {
            return request.header("X-CSRF-TOKEN");
        }
        if (StringKit.isNotBlank(request.header("X-XSRF-TOKEN"))) {
            return request.header("X-XSRF-TOKEN");
        }
        return "";
    });
    private Set<String> urlExclusions;
    private Set<String> urlStartExclusions;
    private Set<String> ignoreMethods;
    private Consumer<RouteContext> errorHandler;
    private Function<Request, String> tokenGetter;

    public boolean isIgnoreMethod(String method) {
        return this.ignoreMethods.contains(method);
    }

    public CsrfOption startExclusion(String ... urls) {
        if (urls == null) {
            throw new NullPointerException("urls");
        }
        this.urlStartExclusions.addAll(Arrays.asList(urls));
        return this;
    }

    public CsrfOption exclusion(String ... urls) {
        if (urls == null) {
            throw new NullPointerException("urls");
        }
        this.urlExclusions.addAll(Arrays.asList(urls));
        return this;
    }

    public boolean isStartExclusion(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        for (String excludeURL : this.urlStartExclusions) {
            if (!url.startsWith(excludeURL)) continue;
            return true;
        }
        return false;
    }

    public boolean isExclusion(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        for (String excludeURL : this.urlExclusions) {
            if (!url.equals(excludeURL)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> $default$urlExclusions() {
        return new HashSet<String>();
    }

    private static Set<String> $default$urlStartExclusions() {
        return new HashSet<String>();
    }

    private static Set<String> $default$ignoreMethods() {
        return DEFAULT_IGNORE_METHODS;
    }

    private static Consumer<RouteContext> $default$errorHandler() {
        return DEFAULT_ERROR_HANDLER;
    }

    private static Function<Request, String> $default$tokenGetter() {
        return DEFAULT_TOKEN_GETTER;
    }

    public static CsrfOptionBuilder builder() {
        return new CsrfOptionBuilder();
    }

    public Set<String> getUrlExclusions() {
        return this.urlExclusions;
    }

    public Set<String> getUrlStartExclusions() {
        return this.urlStartExclusions;
    }

    public Set<String> getIgnoreMethods() {
        return this.ignoreMethods;
    }

    public Consumer<RouteContext> getErrorHandler() {
        return this.errorHandler;
    }

    public Function<Request, String> getTokenGetter() {
        return this.tokenGetter;
    }

    public void setUrlExclusions(Set<String> urlExclusions) {
        this.urlExclusions = urlExclusions;
    }

    public void setUrlStartExclusions(Set<String> urlStartExclusions) {
        this.urlStartExclusions = urlStartExclusions;
    }

    public void setIgnoreMethods(Set<String> ignoreMethods) {
        this.ignoreMethods = ignoreMethods;
    }

    public void setErrorHandler(Consumer<RouteContext> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setTokenGetter(Function<Request, String> tokenGetter) {
        this.tokenGetter = tokenGetter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CsrfOption)) {
            return false;
        }
        CsrfOption other = (CsrfOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$urlExclusions = this.getUrlExclusions();
        Set<String> other$urlExclusions = other.getUrlExclusions();
        if (this$urlExclusions == null ? other$urlExclusions != null : !((Object)this$urlExclusions).equals(other$urlExclusions)) {
            return false;
        }
        Set<String> this$urlStartExclusions = this.getUrlStartExclusions();
        Set<String> other$urlStartExclusions = other.getUrlStartExclusions();
        if (this$urlStartExclusions == null ? other$urlStartExclusions != null : !((Object)this$urlStartExclusions).equals(other$urlStartExclusions)) {
            return false;
        }
        Set<String> this$ignoreMethods = this.getIgnoreMethods();
        Set<String> other$ignoreMethods = other.getIgnoreMethods();
        if (this$ignoreMethods == null ? other$ignoreMethods != null : !((Object)this$ignoreMethods).equals(other$ignoreMethods)) {
            return false;
        }
        Consumer<RouteContext> this$errorHandler = this.getErrorHandler();
        Consumer<RouteContext> other$errorHandler = other.getErrorHandler();
        if (this$errorHandler == null ? other$errorHandler != null : !this$errorHandler.equals(other$errorHandler)) {
            return false;
        }
        Function<Request, String> this$tokenGetter = this.getTokenGetter();
        Function<Request, String> other$tokenGetter = other.getTokenGetter();
        return !(this$tokenGetter == null ? other$tokenGetter != null : !this$tokenGetter.equals(other$tokenGetter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CsrfOption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $urlExclusions = this.getUrlExclusions();
        result = result * 59 + ($urlExclusions == null ? 43 : ((Object)$urlExclusions).hashCode());
        Set<String> $urlStartExclusions = this.getUrlStartExclusions();
        result = result * 59 + ($urlStartExclusions == null ? 43 : ((Object)$urlStartExclusions).hashCode());
        Set<String> $ignoreMethods = this.getIgnoreMethods();
        result = result * 59 + ($ignoreMethods == null ? 43 : ((Object)$ignoreMethods).hashCode());
        Consumer<RouteContext> $errorHandler = this.getErrorHandler();
        result = result * 59 + ($errorHandler == null ? 43 : $errorHandler.hashCode());
        Function<Request, String> $tokenGetter = this.getTokenGetter();
        result = result * 59 + ($tokenGetter == null ? 43 : $tokenGetter.hashCode());
        return result;
    }

    public String toString() {
        return "CsrfOption(urlExclusions=" + this.getUrlExclusions() + ", urlStartExclusions=" + this.getUrlStartExclusions() + ", ignoreMethods=" + this.getIgnoreMethods() + ", errorHandler=" + this.getErrorHandler() + ", tokenGetter=" + this.getTokenGetter() + ")";
    }

    public CsrfOption() {
    }

    public CsrfOption(Set<String> urlExclusions, Set<String> urlStartExclusions, Set<String> ignoreMethods, Consumer<RouteContext> errorHandler, Function<Request, String> tokenGetter) {
        this.urlExclusions = urlExclusions;
        this.urlStartExclusions = urlStartExclusions;
        this.ignoreMethods = ignoreMethods;
        this.errorHandler = errorHandler;
        this.tokenGetter = tokenGetter;
    }

    public static class CsrfOptionBuilder {
        private boolean urlExclusions$set;
        private Set<String> urlExclusions;
        private boolean urlStartExclusions$set;
        private Set<String> urlStartExclusions;
        private boolean ignoreMethods$set;
        private Set<String> ignoreMethods;
        private boolean errorHandler$set;
        private Consumer<RouteContext> errorHandler;
        private boolean tokenGetter$set;
        private Function<Request, String> tokenGetter;

        CsrfOptionBuilder() {
        }

        public CsrfOptionBuilder urlExclusions(Set<String> urlExclusions) {
            this.urlExclusions = urlExclusions;
            this.urlExclusions$set = true;
            return this;
        }

        public CsrfOptionBuilder urlStartExclusions(Set<String> urlStartExclusions) {
            this.urlStartExclusions = urlStartExclusions;
            this.urlStartExclusions$set = true;
            return this;
        }

        public CsrfOptionBuilder ignoreMethods(Set<String> ignoreMethods) {
            this.ignoreMethods = ignoreMethods;
            this.ignoreMethods$set = true;
            return this;
        }

        public CsrfOptionBuilder errorHandler(Consumer<RouteContext> errorHandler) {
            this.errorHandler = errorHandler;
            this.errorHandler$set = true;
            return this;
        }

        public CsrfOptionBuilder tokenGetter(Function<Request, String> tokenGetter) {
            this.tokenGetter = tokenGetter;
            this.tokenGetter$set = true;
            return this;
        }

        public CsrfOption build() {
            Set urlExclusions = this.urlExclusions;
            if (!this.urlExclusions$set) {
                urlExclusions = CsrfOption.$default$urlExclusions();
            }
            Set urlStartExclusions = this.urlStartExclusions;
            if (!this.urlStartExclusions$set) {
                urlStartExclusions = CsrfOption.$default$urlStartExclusions();
            }
            Set ignoreMethods = this.ignoreMethods;
            if (!this.ignoreMethods$set) {
                ignoreMethods = CsrfOption.$default$ignoreMethods();
            }
            Consumer errorHandler = this.errorHandler;
            if (!this.errorHandler$set) {
                errorHandler = CsrfOption.$default$errorHandler();
            }
            Function tokenGetter = this.tokenGetter;
            if (!this.tokenGetter$set) {
                tokenGetter = CsrfOption.$default$tokenGetter();
            }
            return new CsrfOption(urlExclusions, urlStartExclusions, ignoreMethods, errorHandler, tokenGetter);
        }

        public String toString() {
            return "CsrfOption.CsrfOptionBuilder(urlExclusions=" + this.urlExclusions + ", urlStartExclusions=" + this.urlStartExclusions + ", ignoreMethods=" + this.ignoreMethods + ", errorHandler=" + this.errorHandler + ", tokenGetter=" + this.tokenGetter + ")";
        }
    }
}

