/*
 * Decompiled with CFR 0.152.
 */
package com.blade.security.web.xss;

import com.blade.kit.StringKit;
import com.blade.mvc.RouteContext;
import com.blade.mvc.hook.WebHook;
import com.blade.mvc.http.StringBody;
import com.blade.security.web.filter.HTMLFilter;
import com.blade.security.web.xss.XssOption;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class XssMiddleware
implements WebHook {
    private static final HTMLFilter HTML_FILTER = new HTMLFilter();
    private XssOption xssOption = XssOption.builder().build();

    public XssMiddleware(XssOption xssOption) {
        this.xssOption = xssOption;
    }

    @Override
    public boolean before(RouteContext context) {
        String body;
        if (this.xssOption.isExclusion(context.uri())) {
            return true;
        }
        this.filterHeaders(context.headers());
        this.filterParameters(context.parameters());
        if (context.contentType().toLowerCase().contains("json") && StringKit.isNotEmpty(body = context.bodyToString())) {
            String filterBody = this.stripXSS(body);
            context.body(new StringBody(filterBody));
        }
        return true;
    }

    protected void filterHeaders(Map<String, String> headers) {
        headers.forEach((key, value) -> headers.put((String)key, this.stripXSS((String)value)));
    }

    protected void filterParameters(Map<String, List<String>> parameters) {
        Set<Map.Entry<String, List<String>>> entries = parameters.entrySet();
        for (Map.Entry<String, List<String>> entry : entries) {
            List snzValues = entry.getValue().stream().map(this::stripXSS).collect(Collectors.toList());
            parameters.remove(entry.getKey());
            parameters.put(entry.getKey(), snzValues);
        }
    }

    protected String stripXSS(String value) {
        return HTML_FILTER.filter(value);
    }

    public XssMiddleware() {
    }
}

