/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.Environment;
import com.blade.event.BeanProcessor;
import com.blade.event.Event;
import com.blade.event.EventType;
import com.blade.ioc.DynamicContext;
import com.blade.ioc.Ioc;
import com.blade.ioc.annotation.Bean;
import com.blade.ioc.annotation.Value;
import com.blade.ioc.bean.BeanDefine;
import com.blade.ioc.bean.ClassInfo;
import com.blade.ioc.bean.OrderComparator;
import com.blade.kit.Ansi;
import com.blade.kit.BladeKit;
import com.blade.kit.NamedThreadFactory;
import com.blade.kit.ReflectKit;
import com.blade.kit.StringKit;
import com.blade.loader.BladeLoader;
import com.blade.mvc.Const;
import com.blade.mvc.WebContext;
import com.blade.mvc.annotation.Path;
import com.blade.mvc.annotation.URLPattern;
import com.blade.mvc.handler.DefaultExceptionHandler;
import com.blade.mvc.handler.ExceptionHandler;
import com.blade.mvc.hook.WebHook;
import com.blade.mvc.http.session.SessionCleaner;
import com.blade.mvc.route.RouteBuilder;
import com.blade.mvc.route.RouteMatcher;
import com.blade.mvc.ui.template.DefaultEngine;
import com.blade.server.Server;
import com.blade.server.netty.EpollKit;
import com.blade.server.netty.HttpServerInitializer;
import com.blade.server.netty.NettyServerGroup;
import com.blade.task.Task;
import com.blade.task.TaskContext;
import com.blade.task.TaskManager;
import com.blade.task.TaskStruct;
import com.blade.task.annotation.Schedule;
import com.blade.task.cron.CronExecutorService;
import com.blade.task.cron.CronExpression;
import com.blade.task.cron.CronThreadPoolExecutor;
import com.blade.watcher.EnvironmentWatcher;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.ResourceLeakDetector;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
implements Server {
    private static final Logger log = LoggerFactory.getLogger(NettyServer.class);
    private Blade blade;
    private Environment environment;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel channel;
    private RouteBuilder routeBuilder;
    private List<BeanProcessor> processors;
    private List<BladeLoader> loaders;
    private List<TaskStruct> taskStruts = new ArrayList<TaskStruct>();
    private final int padSize = 26;
    private volatile boolean isStop;

    @Override
    public void start(Blade blade, String[] args) throws Exception {
        this.blade = blade;
        this.environment = blade.environment();
        this.processors = blade.processors();
        this.loaders = blade.loaders();
        long startMs = System.currentTimeMillis();
        log.info("{} {}{}", new Object[]{StringKit.padRight("environment.jdk.version", 26), BladeKit.getPrefixSymbol(), System.getProperty("java.version")});
        log.info("{} {}{}", new Object[]{StringKit.padRight("environment.user.dir", 26), BladeKit.getPrefixSymbol(), System.getProperty("user.dir")});
        log.info("{} {}{}", new Object[]{StringKit.padRight("environment.java.io.tmpdir", 26), BladeKit.getPrefixSymbol(), System.getProperty("java.io.tmpdir")});
        log.info("{} {}{}", new Object[]{StringKit.padRight("environment.user.timezone", 26), BladeKit.getPrefixSymbol(), System.getProperty("user.timezone")});
        log.info("{} {}{}", new Object[]{StringKit.padRight("environment.file.encoding", 26), BladeKit.getPrefixSymbol(), System.getProperty("file.encoding")});
        log.info("{} {}{}", new Object[]{StringKit.padRight("environment.classpath", 26), BladeKit.getPrefixSymbol(), Const.CLASSPATH});
        this.initConfig();
        String contextPath = this.environment.get("app.context-path", "/");
        WebContext.init(blade, contextPath);
        this.initIoc();
        this.watchEnv();
        this.startServer(startMs);
        this.sessionCleaner();
        this.startTask();
        this.shutdownHook();
    }

    private void sessionCleaner() {
        if (null != this.blade.sessionManager()) {
            Thread sessionCleanerThread = new Thread(new SessionCleaner(this.blade.sessionManager()));
            sessionCleanerThread.setName("session-cleaner");
            sessionCleanerThread.start();
        }
    }

    private void initIoc() {
        List<BeanDefine> beanDefines;
        RouteMatcher routeMatcher = this.blade.routeMatcher();
        routeMatcher.initMiddleware(this.blade.middleware());
        this.routeBuilder = new RouteBuilder(routeMatcher);
        this.blade.scanPackages().stream().flatMap(DynamicContext::recursionFindClasses).map(ClassInfo::getClazz).filter(ReflectKit::isNormalClass).forEach(this::parseCls);
        routeMatcher.register();
        this.loaders.stream().sorted(new OrderComparator()).forEach(b -> b.preLoad(this.blade));
        this.processors.stream().sorted(new OrderComparator()).forEach(b -> b.preHandle(this.blade));
        Ioc ioc = this.blade.ioc();
        if (BladeKit.isNotEmpty(ioc.getBeans())) {
            log.info("{}Register bean: {}", (Object)BladeKit.getStartedSymbol(), ioc.getBeans());
        }
        if (BladeKit.isNotEmpty(beanDefines = ioc.getBeanDefines())) {
            beanDefines.forEach(b -> {
                BladeKit.injection(ioc, b);
                BladeKit.injectionValue(this.environment, b);
                List<TaskStruct> cronExpressions = BladeKit.getTasks(b.getType());
                if (null != cronExpressions) {
                    this.taskStruts.addAll(cronExpressions);
                }
            });
        }
        this.loaders.stream().sorted(new OrderComparator()).forEach(b -> b.load(this.blade));
        this.processors.stream().sorted(new OrderComparator()).forEach(b -> b.processor(this.blade));
    }

    private void startServer(long startMs) throws Exception {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        boolean SSL = this.environment.getBoolean("server.ssl.enable", false);
        SslContext sslCtx = null;
        if (SSL) {
            String certFilePath = this.environment.get("server.ssl.cert-path", null);
            String privateKeyPath = this.environment.get("server.ssl.private-key-path", null);
            String privateKeyPassword = this.environment.get("server.ssl.private-key-pass", null);
            log.info("{}SSL CertChainFile  Path: {}", (Object)BladeKit.getStartedSymbol(), (Object)certFilePath);
            log.info("{}SSL PrivateKeyFile Path: {}", (Object)BladeKit.getStartedSymbol(), (Object)privateKeyPath);
            sslCtx = SslContextBuilder.forServer((File)new File(certFilePath), (File)new File(privateKeyPath), (String)privateKeyPassword).build();
        }
        int backlog = this.environment.getInt("server.netty.so-backlog", 1024);
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)backlog);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        bootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        int acceptThreadCount = this.environment.getInt("server.netty.accept-thread-count", 1);
        int ioThreadCount = this.environment.getInt("server.netty.io-thread-count", 0);
        if (BladeKit.epollIsAvailable()) {
            log.info("{}Use EpollEventLoopGroup", (Object)BladeKit.getStartedSymbol());
            bootstrap.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
            NettyServerGroup nettyServerGroup = EpollKit.group(acceptThreadCount, ioThreadCount);
            this.bossGroup = nettyServerGroup.getBoosGroup();
            this.workerGroup = nettyServerGroup.getWorkerGroup();
            bootstrap.group(this.bossGroup, this.workerGroup).channel(nettyServerGroup.getSocketChannel());
        } else {
            log.info("{}Use NioEventLoopGroup", (Object)BladeKit.getStartedSymbol());
            this.bossGroup = new NioEventLoopGroup(acceptThreadCount, (ThreadFactory)new NamedThreadFactory("boss@"));
            this.workerGroup = new NioEventLoopGroup(ioThreadCount, (ThreadFactory)new NamedThreadFactory("worker@"));
            bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class);
        }
        ((ServerBootstrap)bootstrap.handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)new HttpServerInitializer(sslCtx, this.blade, (ScheduledExecutorService)this.bossGroup.next()));
        String address = this.environment.get("server.address", "0.0.0.0");
        Integer port = this.environment.getInt("server.port", 9000);
        this.channel = bootstrap.bind(address, port.intValue()).sync().channel();
        String appName = this.environment.get("app.name", "Blade");
        String url = Ansi.BgRed.and(Ansi.Black).format(" %s:%d ", address, port);
        String protocol = SSL ? "https" : "http";
        log.info("{}{} initialize successfully, Time elapsed: {} ms", new Object[]{BladeKit.getStartedSymbol(), appName, System.currentTimeMillis() - startMs});
        log.info("{}Blade start with {}", (Object)BladeKit.getStartedSymbol(), (Object)url);
        log.info("{}Open browser access {}://{}:{} \u26a1\r\n", new Object[]{BladeKit.getStartedSymbol(), protocol, address.replace("0.0.0.0", "127.0.0.1"), port});
        this.blade.eventManager().fireEvent(EventType.SERVER_STARTED, new Event().attribute("blade", this.blade));
    }

    private void startTask() {
        if (this.taskStruts.isEmpty()) {
            return;
        }
        int corePoolSize = this.environment.getInt("app.task.thread-count", Runtime.getRuntime().availableProcessors() + 1);
        CronExecutorService executorService = TaskManager.getExecutorService();
        if (null == executorService) {
            executorService = new CronThreadPoolExecutor(corePoolSize, new NamedThreadFactory("task@"));
            TaskManager.init(executorService);
        }
        AtomicInteger jobCount = new AtomicInteger();
        for (TaskStruct taskStruct : this.taskStruts) {
            this.addTask(executorService, jobCount, taskStruct);
        }
    }

    private void addTask(CronExecutorService executorService, AtomicInteger jobCount, TaskStruct taskStruct) {
        try {
            Schedule schedule = taskStruct.getSchedule();
            String jobName = StringKit.isBlank(schedule.name()) ? "task-" + jobCount.getAndIncrement() : schedule.name();
            Task task = new Task(jobName, new CronExpression(schedule.cron()), schedule.delay());
            TaskContext taskContext = new TaskContext(task);
            task.setTask(() -> {
                Object target = this.blade.ioc().getBean(taskStruct.getType());
                Method method = taskStruct.getMethod();
                try {
                    if (method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(TaskContext.class)) {
                        taskStruct.getMethod().invoke(target, taskContext);
                    } else {
                        taskStruct.getMethod().invoke(target, new Object[0]);
                    }
                }
                catch (Exception e) {
                    log.error("Task method error", (Throwable)e);
                }
            });
            ScheduledFuture<?> future = executorService.submit(task);
            task.setFuture(future);
            TaskManager.addTask(task);
        }
        catch (Exception e) {
            log.warn("{}Add task fail: {}", (Object)BladeKit.getPrefixSymbol(), (Object)e.getMessage());
        }
    }

    private void parseCls(Class<?> clazz) {
        if (null != clazz.getAnnotation(Bean.class) || null != clazz.getAnnotation(Value.class)) {
            this.blade.register(clazz);
        }
        if (null != clazz.getAnnotation(Path.class)) {
            if (null == this.blade.ioc().getBean(clazz)) {
                this.blade.register(clazz);
            }
            Object controller = this.blade.ioc().getBean(clazz);
            this.routeBuilder.addRouter(clazz, controller);
        }
        if (ReflectKit.hasInterface(clazz, WebHook.class) && null != clazz.getAnnotation(Bean.class)) {
            Object hook = this.blade.ioc().getBean(clazz);
            URLPattern URLPattern2 = clazz.getAnnotation(URLPattern.class);
            if (null == URLPattern2) {
                this.routeBuilder.addWebHook(clazz, "/.*", hook);
            } else {
                Stream.of(URLPattern2.values()).forEach(pattern -> this.routeBuilder.addWebHook(clazz, (String)pattern, hook));
            }
        }
        if (ReflectKit.hasInterface(clazz, BladeLoader.class) && null != clazz.getAnnotation(Bean.class)) {
            this.loaders.add((BladeLoader)this.blade.ioc().getBean(clazz));
        }
        if (ReflectKit.hasInterface(clazz, BeanProcessor.class) && null != clazz.getAnnotation(Bean.class)) {
            this.processors.add((BeanProcessor)this.blade.ioc().getBean(clazz));
        }
        if (this.isExceptionHandler(clazz)) {
            ExceptionHandler exceptionHandler = (ExceptionHandler)this.blade.ioc().getBean(clazz);
            this.blade.exceptionHandler(exceptionHandler);
        }
    }

    private boolean isExceptionHandler(Class<?> clazz) {
        return null != clazz.getAnnotation(Bean.class) && (ReflectKit.hasInterface(clazz, ExceptionHandler.class) || clazz.getSuperclass().equals(DefaultExceptionHandler.class));
    }

    private void watchEnv() {
        boolean watchEnv = this.environment.getBoolean("app.watch-env", true);
        log.info("{}Watched environment: {}", new Object[]{BladeKit.getStartedSymbol(), watchEnv, BladeKit.getStartedSymbol()});
        if (watchEnv) {
            Thread thread = new Thread(new EnvironmentWatcher());
            thread.setName("watch@thread");
            thread.start();
        }
    }

    private void initConfig() {
        String templatePath;
        if (null != this.blade.bootClass()) {
            this.blade.scanPackages(this.blade.bootClass().getPackage().getName());
        }
        this.printBanner();
        String statics = this.environment.get("mvc.statics", "");
        if (StringKit.isNotBlank(statics)) {
            this.blade.addStatics(statics.split(","));
        }
        if ((templatePath = this.environment.get("mvc.template.path", "templates")).charAt(0) == '/') {
            templatePath = templatePath.substring(1);
        }
        if (templatePath.endsWith("/")) {
            templatePath = templatePath.substring(0, templatePath.length() - 1);
        }
        DefaultEngine.TEMPLATE_PATH = templatePath;
    }

    private void shutdownHook() {
        Thread shutdownThread = new Thread(this::stop);
        shutdownThread.setName("shutdown@thread");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    @Override
    public void stop() {
        if (this.isStop) {
            return;
        }
        this.isStop = true;
        System.out.println();
        log.info("{}Blade shutdown ...", (Object)BladeKit.getStartedSymbol());
        try {
            WebContext.clean();
            if (this.bossGroup != null) {
                this.bossGroup.shutdownGracefully();
            }
            if (this.workerGroup != null) {
                this.workerGroup.shutdownGracefully();
            }
            log.info("{}Blade shutdown successful", (Object)BladeKit.getStartedSymbol());
        }
        catch (Exception e) {
            log.error("Blade shutdown error", (Throwable)e);
        }
    }

    @Override
    public void stopAndWait() {
        if (this.isStop) {
            return;
        }
        this.isStop = true;
        System.out.println();
        log.info("{}Blade shutdown ...", (Object)BladeKit.getStartedSymbol());
        try {
            if (this.bossGroup != null) {
                this.bossGroup.shutdownGracefully().sync();
            }
            if (this.workerGroup != null) {
                this.workerGroup.shutdownGracefully().sync();
            }
            log.info("{}Blade shutdown successful", (Object)BladeKit.getStartedSymbol());
        }
        catch (Exception e) {
            log.error("Blade shutdown error", (Throwable)e);
        }
    }

    @Override
    public void join() throws InterruptedException {
        this.channel.closeFuture().sync();
    }

    private void printBanner() {
        if (null != this.blade.bannerText()) {
            System.out.println(this.blade.bannerText());
        } else {
            String text = Const.BANNER_TEXT + "\r\n" + StringKit.padLeft(" :: Blade :: (v", 51) + "2.0.9.BETA3" + ") " + "\r\n";
            System.out.println(Ansi.Magenta.format(text, new Object[0]));
        }
    }
}

