/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.exception.BladeException;
import com.blade.exception.InternalErrorException;
import com.blade.exception.NotFoundException;
import com.blade.kit.BladeCache;
import com.blade.kit.BladeKit;
import com.blade.kit.ReflectKit;
import com.blade.mvc.RouteContext;
import com.blade.mvc.WebContext;
import com.blade.mvc.annotation.JSON;
import com.blade.mvc.annotation.Path;
import com.blade.mvc.handler.RequestHandler;
import com.blade.mvc.handler.RouteHandler;
import com.blade.mvc.handler.RouteHandler0;
import com.blade.mvc.hook.WebHook;
import com.blade.mvc.http.BodyWriter;
import com.blade.mvc.http.EmptyBody;
import com.blade.mvc.http.RawBody;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.mvc.http.StreamBody;
import com.blade.mvc.http.StringBody;
import com.blade.mvc.http.ViewBody;
import com.blade.mvc.route.Route;
import com.blade.mvc.route.RouteMatcher;
import com.blade.mvc.ui.ModelAndView;
import com.blade.reflectasm.MethodAccess;
import com.blade.server.netty.HttpConst;
import com.blade.server.netty.HttpServerInitializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteMethodHandler
implements RequestHandler<ChannelHandlerContext> {
    private static final Logger log = LoggerFactory.getLogger(RouteMethodHandler.class);
    private final RouteMatcher routeMatcher = WebContext.blade().routeMatcher();
    private final boolean hasMiddleware = this.routeMatcher.getMiddleware().size() > 0;
    private final boolean hasBeforeHook = this.routeMatcher.hasBeforeHook();
    private final boolean hasAfterHook = this.routeMatcher.hasAfterHook();

    public void handleResponse(final Request request, final Response response, final ChannelHandlerContext context) {
        response.body().write(new BodyWriter<Void>(){

            @Override
            public Void onText(StringBody body) {
                return RouteMethodHandler.this.handleFullResponse(RouteMethodHandler.this.createTextResponse(request, response, body.content()), context, request.keepAlive());
            }

            @Override
            public Void onStream(StreamBody body) {
                return RouteMethodHandler.this.handleStreamResponse(response, body.content(), context, request.keepAlive());
            }

            @Override
            public Void onView(ViewBody body) {
                try {
                    StringWriter sw = new StringWriter();
                    WebContext.blade().templateEngine().render(body.modelAndView(), sw);
                    response.contentType("text/html; charset=UTF-8");
                    return RouteMethodHandler.this.handleFullResponse(RouteMethodHandler.this.createTextResponse(request, response, sw.toString()), context, request.keepAlive());
                }
                catch (Exception e) {
                    log.error("Render view error", (Throwable)e);
                    return null;
                }
            }

            @Override
            public Void onEmpty(EmptyBody emptyBody) {
                return RouteMethodHandler.this.handleFullResponse(RouteMethodHandler.this.createTextResponse(request, response, ""), context, request.keepAlive());
            }

            @Override
            public Void onRawBody(RawBody body) {
                return RouteMethodHandler.this.handleFullResponse(body.httpResponse(), context, request.keepAlive());
            }
        });
    }

    public Void handleFullResponse(FullHttpResponse response, ChannelHandlerContext context, boolean keepAlive) {
        if (context.channel().isActive()) {
            if (!keepAlive) {
                context.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                response.headers().set(HttpConst.CONNECTION, (Object)HttpConst.KEEP_ALIVE);
                context.write((Object)response, context.voidPromise());
            }
            context.flush();
        }
        return null;
    }

    public Map<String, String> getDefaultHeader() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(HttpConst.DATE.toString(), HttpServerInitializer.date.toString());
        map.put(HttpConst.X_POWER_BY.toString(), HttpConst.VERSION.toString());
        return map;
    }

    public Void handleStreamResponse(Response response, InputStream body, ChannelHandlerContext context, boolean keepAlive) {
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.statusCode()));
        httpResponse.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        response.headers().forEach((key, value) -> httpResponse.headers().set(key, value));
        context.write((Object)response);
        context.write((Object)new ChunkedStream(body));
        ChannelFuture lastContentFuture = context.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!keepAlive) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        return null;
    }

    public FullHttpResponse createTextResponse(Request request, Response response, String body) {
        Map<String, String> headers = response.headers();
        headers.putAll(this.getDefaultHeader());
        if (response.cookiesRaw().size() > 0) {
            response.cookiesRaw().forEach(cookie -> headers.put(HttpConst.SET_COOKIE.toString(), ServerCookieEncoder.LAX.encode(cookie)));
        }
        ByteBuf bodyBuf = Unpooled.wrappedBuffer((byte[])body.getBytes(StandardCharsets.UTF_8));
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.statusCode()), null == bodyBuf ? Unpooled.buffer((int)0) : bodyBuf);
        httpResponse.headers().set(HttpConst.CONTENT_LENGTH, (Object)httpResponse.content().readableBytes());
        headers.forEach((key, value) -> httpResponse.headers().set(key, value));
        return httpResponse;
    }

    private void routeHandle(RouteContext context) {
        Object routeHandler;
        Object target = context.routeTarget();
        if (null == target) {
            Class<?> clazz = context.routeAction().getDeclaringClass();
            target = WebContext.blade().getBean(clazz);
            context.route().setTarget(target);
        }
        if (context.targetType() == RouteHandler.class) {
            routeHandler = (RouteHandler)target;
            routeHandler.handle(context);
        } else if (context.targetType() == RouteHandler0.class) {
            routeHandler = (RouteHandler0)target;
            routeHandler.handle(context.request(), context.response());
        } else {
            boolean isRestful;
            Method actionMethod = context.routeAction();
            Class<?> returnType = actionMethod.getReturnType();
            Path path = target.getClass().getAnnotation(Path.class);
            JSON JSON2 = actionMethod.getAnnotation(JSON.class);
            boolean bl = isRestful = null != JSON2 || null != path && path.restful();
            if (isRestful) {
                if (!context.isIE()) {
                    context.contentType("application/json; charset=UTF-8");
                } else {
                    context.contentType("text/html; charset=UTF-8");
                }
            }
            int len = actionMethod.getParameterTypes().length;
            MethodAccess methodAccess = BladeCache.getMethodAccess(target.getClass());
            Object returnParam = methodAccess.invoke(target, actionMethod.getName(), len > 0 ? context.routeParameters() : null);
            if (null == returnParam) {
                return;
            }
            if (isRestful) {
                context.json(returnParam);
                return;
            }
            if (returnType == String.class) {
                context.body(new ViewBody(new ModelAndView(returnParam.toString())));
                return;
            }
            if (returnType == ModelAndView.class) {
                context.body(new ViewBody((ModelAndView)returnParam));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean invokeHook(RouteContext context, Route hookRoute) throws Exception {
        Object returnParam;
        Method hookMethod = hookRoute.getAction();
        Object target = hookRoute.getTarget();
        if (null == target) {
            Class<?> clazz = hookRoute.getAction().getDeclaringClass();
            target = WebContext.blade().ioc().getBean(clazz);
            hookRoute.setTarget(target);
        }
        int len = hookMethod.getParameterTypes().length;
        hookMethod.setAccessible(true);
        if (len > 0) {
            MethodAccess methodAccess;
            if (len == 1) {
                methodAccess = BladeCache.getMethodAccess(target.getClass());
                returnParam = methodAccess.invoke(target, hookMethod.getName(), new Object[]{context});
            } else {
                if (len != 2) throw new InternalErrorException("Bad web hook structure");
                methodAccess = BladeCache.getMethodAccess(target.getClass());
                returnParam = methodAccess.invoke(target, hookMethod.getName(), new Object[]{context.request(), context.response()});
            }
        } else {
            returnParam = ReflectKit.invokeMethod(target, hookMethod, new Object[0]);
        }
        if (null == returnParam) {
            return true;
        }
        Class<?> returnType = returnParam.getClass();
        if (returnType != Boolean.class && returnType != Boolean.TYPE) return true;
        return Boolean.valueOf(returnParam.toString());
    }

    private boolean invokeMiddleware(List<Route> middleware, RouteContext context) throws BladeException {
        if (BladeKit.isEmpty(middleware)) {
            return true;
        }
        for (Route route : middleware) {
            WebHook webHook = (WebHook)route.getTarget();
            boolean flag = webHook.before(context);
            if (flag) continue;
            return false;
        }
        return true;
    }

    private boolean invokeHook(List<Route> hooks, RouteContext context) throws Exception {
        for (Route hook : hooks) {
            if (hook.getTargetType() == RouteHandler.class) {
                RouteHandler routeHandler = (RouteHandler)hook.getTarget();
                routeHandler.handle(context);
                continue;
            }
            if (hook.getTargetType() == RouteHandler0.class) {
                RouteHandler0 routeHandler = (RouteHandler0)hook.getTarget();
                routeHandler.handle(context.request(), context.response());
                continue;
            }
            boolean flag = this.invokeHook(context, hook);
            if (flag) continue;
            return false;
        }
        return true;
    }

    @Override
    public void handle(ChannelHandlerContext ctx, Request request, Response response) throws Exception {
        RouteContext context = new RouteContext(request, response);
        String uri = context.uri();
        Route route = this.routeMatcher.lookupRoute(context.method(), uri);
        if (null == route) {
            BladeKit.log404(log, context.method(), context.uri());
            throw new NotFoundException(context.uri());
        }
        context.initRoute(route);
        if (this.hasMiddleware && !this.invokeMiddleware(this.routeMatcher.getMiddleware(), context)) {
            return;
        }
        context.injectParameters();
        if (this.hasBeforeHook && !this.invokeHook(this.routeMatcher.getBefore(uri), context)) {
            return;
        }
        this.routeHandle(context);
        if (this.hasAfterHook) {
            this.invokeHook(this.routeMatcher.getAfter(uri), context);
        }
    }
}

