/*
 * Decompiled with CFR 0.152.
 */
package com.blade.task.cron;

import com.blade.task.Task;
import com.blade.task.cron.CronExecutorService;
import com.blade.task.cron.CronExpression;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class CronThreadPoolExecutor
extends ScheduledThreadPoolExecutor
implements CronExecutorService {
    public CronThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    @Override
    public ScheduledFuture<?> submit(Task task) {
        if (task == null) {
            throw new NullPointerException();
        }
        CronExpression expression = task.getCronExpression();
        Runnable scheduleTask = () -> {
            Date now = new Date();
            Date time = expression.getNextValidTimeAfter(now);
            try {
                while (time != null && task.isRunning()) {
                    this.schedule(task.getTask(), time.getTime() - now.getTime(), TimeUnit.MILLISECONDS);
                    while (now.before(time)) {
                        Thread.sleep(time.getTime() - now.getTime());
                        now = new Date();
                    }
                    time = expression.getNextValidTimeAfter(now);
                }
            }
            catch (CancellationException | RejectedExecutionException runtimeException) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
        return this.schedule(scheduleTask, task.getDelay(), TimeUnit.MILLISECONDS);
    }
}

