/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Properties;

public final class RomUtils {
    private static final String[] ROM_HUAWEI = new String[]{"huawei"};
    private static final String[] ROM_VIVO = new String[]{"vivo"};
    private static final String[] ROM_XIAOMI = new String[]{"xiaomi"};
    private static final String[] ROM_OPPO = new String[]{"oppo"};
    private static final String[] ROM_LEECO = new String[]{"leeco", "letv"};
    private static final String[] ROM_360 = new String[]{"360", "qiku"};
    private static final String[] ROM_ZTE = new String[]{"zte"};
    private static final String[] ROM_ONEPLUS = new String[]{"oneplus"};
    private static final String[] ROM_NUBIA = new String[]{"nubia"};
    private static final String[] ROM_COOLPAD = new String[]{"coolpad", "yulong"};
    private static final String[] ROM_LG = new String[]{"lg", "lge"};
    private static final String[] ROM_GOOGLE = new String[]{"google"};
    private static final String[] ROM_SAMSUNG = new String[]{"samsung"};
    private static final String[] ROM_MEIZU = new String[]{"meizu"};
    private static final String[] ROM_LENOVO = new String[]{"lenovo"};
    private static final String[] ROM_SMARTISAN = new String[]{"smartisan", "deltainno"};
    private static final String[] ROM_HTC = new String[]{"htc"};
    private static final String[] ROM_SONY = new String[]{"sony"};
    private static final String[] ROM_GIONEE = new String[]{"gionee", "amigo"};
    private static final String[] ROM_MOTOROLA = new String[]{"motorola"};
    private static final String VERSION_PROPERTY_HUAWEI = "ro.build.version.emui";
    private static final String VERSION_PROPERTY_VIVO = "ro.vivo.os.build.display.id";
    private static final String VERSION_PROPERTY_XIAOMI = "ro.build.version.incremental";
    private static final String VERSION_PROPERTY_OPPO = "ro.build.version.opporom";
    private static final String VERSION_PROPERTY_LEECO = "ro.letv.release.version";
    private static final String VERSION_PROPERTY_360 = "ro.build.uiversion";
    private static final String VERSION_PROPERTY_ZTE = "ro.build.MiFavor_version";
    private static final String VERSION_PROPERTY_ONEPLUS = "ro.rom.version";
    private static final String VERSION_PROPERTY_NUBIA = "ro.build.rom.id";
    private static final String UNKNOWN = "unknown";
    private static RomInfo bean = null;

    private RomUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isHuawei() {
        return ROM_HUAWEI[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isVivo() {
        return ROM_VIVO[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isXiaomi() {
        return ROM_XIAOMI[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isOppo() {
        return ROM_OPPO[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isLeeco() {
        return ROM_LEECO[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean is360() {
        return ROM_360[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isZte() {
        return ROM_ZTE[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isOneplus() {
        return ROM_ONEPLUS[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isNubia() {
        return ROM_NUBIA[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isCoolpad() {
        return ROM_COOLPAD[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isLg() {
        return ROM_LG[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isGoogle() {
        return ROM_GOOGLE[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isSamsung() {
        return ROM_SAMSUNG[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isMeizu() {
        return ROM_MEIZU[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isLenovo() {
        return ROM_LENOVO[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isSmartisan() {
        return ROM_SMARTISAN[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isHtc() {
        return ROM_HTC[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isSony() {
        return ROM_SONY[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isGionee() {
        return ROM_GIONEE[0].equals(RomUtils.getRomInfo().name);
    }

    public static boolean isMotorola() {
        return ROM_MOTOROLA[0].equals(RomUtils.getRomInfo().name);
    }

    public static RomInfo getRomInfo() {
        String manufacturer;
        if (bean != null) {
            return bean;
        }
        bean = new RomInfo();
        String brand = RomUtils.getBrand();
        if (RomUtils.isRightRom(brand, manufacturer = RomUtils.getManufacturer(), ROM_HUAWEI)) {
            bean.name = RomUtils.ROM_HUAWEI[0];
            String version = RomUtils.getRomVersion(VERSION_PROPERTY_HUAWEI);
            String[] temp = version.split("_");
            if (temp.length > 1) {
                bean.version = temp[1];
            } else {
                bean.version = version;
            }
            return bean;
        }
        if (RomUtils.isRightRom(brand, manufacturer, ROM_VIVO)) {
            bean.name = RomUtils.ROM_VIVO[0];
            bean.version = RomUtils.getRomVersion(VERSION_PROPERTY_VIVO);
            return bean;
        }
        if (RomUtils.isRightRom(brand, manufacturer, ROM_XIAOMI)) {
            bean.name = RomUtils.ROM_XIAOMI[0];
            bean.version = RomUtils.getRomVersion(VERSION_PROPERTY_XIAOMI);
            return bean;
        }
        if (RomUtils.isRightRom(brand, manufacturer, ROM_OPPO)) {
            bean.name = RomUtils.ROM_OPPO[0];
            bean.version = RomUtils.getRomVersion(VERSION_PROPERTY_OPPO);
            return bean;
        }
        if (RomUtils.isRightRom(brand, manufacturer, ROM_LEECO)) {
            bean.name = RomUtils.ROM_LEECO[0];
            bean.version = RomUtils.getRomVersion(VERSION_PROPERTY_LEECO);
            return bean;
        }
        if (RomUtils.isRightRom(brand, manufacturer, ROM_360)) {
            bean.name = RomUtils.ROM_360[0];
            bean.version = RomUtils.getRomVersion(VERSION_PROPERTY_360);
            return bean;
        }
        if (RomUtils.isRightRom(brand, manufacturer, ROM_ZTE)) {
            bean.name = RomUtils.ROM_ZTE[0];
            bean.version = RomUtils.getRomVersion(VERSION_PROPERTY_ZTE);
            return bean;
        }
        if (RomUtils.isRightRom(brand, manufacturer, ROM_ONEPLUS)) {
            bean.name = RomUtils.ROM_ONEPLUS[0];
            bean.version = RomUtils.getRomVersion(VERSION_PROPERTY_ONEPLUS);
            return bean;
        }
        if (RomUtils.isRightRom(brand, manufacturer, ROM_NUBIA)) {
            bean.name = RomUtils.ROM_NUBIA[0];
            bean.version = RomUtils.getRomVersion(VERSION_PROPERTY_NUBIA);
            return bean;
        }
        if (RomUtils.isRightRom(brand, manufacturer, ROM_COOLPAD)) {
            bean.name = RomUtils.ROM_COOLPAD[0];
        } else if (RomUtils.isRightRom(brand, manufacturer, ROM_LG)) {
            bean.name = RomUtils.ROM_LG[0];
        } else if (RomUtils.isRightRom(brand, manufacturer, ROM_GOOGLE)) {
            bean.name = RomUtils.ROM_GOOGLE[0];
        } else if (RomUtils.isRightRom(brand, manufacturer, ROM_SAMSUNG)) {
            bean.name = RomUtils.ROM_SAMSUNG[0];
        } else if (RomUtils.isRightRom(brand, manufacturer, ROM_MEIZU)) {
            bean.name = RomUtils.ROM_MEIZU[0];
        } else if (RomUtils.isRightRom(brand, manufacturer, ROM_LENOVO)) {
            bean.name = RomUtils.ROM_LENOVO[0];
        } else if (RomUtils.isRightRom(brand, manufacturer, ROM_SMARTISAN)) {
            bean.name = RomUtils.ROM_SMARTISAN[0];
        } else if (RomUtils.isRightRom(brand, manufacturer, ROM_HTC)) {
            bean.name = RomUtils.ROM_HTC[0];
        } else if (RomUtils.isRightRom(brand, manufacturer, ROM_SONY)) {
            bean.name = RomUtils.ROM_SONY[0];
        } else if (RomUtils.isRightRom(brand, manufacturer, ROM_GIONEE)) {
            bean.name = RomUtils.ROM_GIONEE[0];
        } else if (RomUtils.isRightRom(brand, manufacturer, ROM_MOTOROLA)) {
            bean.name = RomUtils.ROM_MOTOROLA[0];
        } else {
            bean.name = manufacturer;
        }
        bean.version = RomUtils.getRomVersion("");
        return bean;
    }

    private static boolean isRightRom(String brand, String manufacturer, String ... names) {
        for (String name : names) {
            if (!brand.contains(name) && !manufacturer.contains(name)) continue;
            return true;
        }
        return false;
    }

    private static String getManufacturer() {
        try {
            String manufacturer = Build.MANUFACTURER;
            if (!TextUtils.isEmpty((CharSequence)manufacturer)) {
                return manufacturer.toLowerCase();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return UNKNOWN;
    }

    private static String getBrand() {
        try {
            String brand = Build.BRAND;
            if (!TextUtils.isEmpty((CharSequence)brand)) {
                return brand.toLowerCase();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return UNKNOWN;
    }

    private static String getRomVersion(String propertyName) {
        String ret = "";
        if (!TextUtils.isEmpty((CharSequence)propertyName)) {
            ret = RomUtils.getSystemProperty(propertyName);
        }
        if (TextUtils.isEmpty((CharSequence)ret) || ret.equals(UNKNOWN)) {
            try {
                String display = Build.DISPLAY;
                if (!TextUtils.isEmpty((CharSequence)display)) {
                    ret = display.toLowerCase();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (TextUtils.isEmpty((CharSequence)ret)) {
            return UNKNOWN;
        }
        return ret;
    }

    private static String getSystemProperty(String name) {
        String prop = RomUtils.getSystemPropertyByShell(name);
        if (!TextUtils.isEmpty((CharSequence)prop)) {
            return prop;
        }
        prop = RomUtils.getSystemPropertyByStream(name);
        if (!TextUtils.isEmpty((CharSequence)prop)) {
            return prop;
        }
        if (Build.VERSION.SDK_INT < 28) {
            return RomUtils.getSystemPropertyByReflect(name);
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSystemPropertyByShell(String propName) {
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + propName);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            String ret = input.readLine();
            if (ret != null) {
                String string = ret;
                return string;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return "";
    }

    private static String getSystemPropertyByStream(String key) {
        try {
            Properties prop = new Properties();
            FileInputStream is = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
            prop.load(is);
            return prop.getProperty(key, "");
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getSystemPropertyByReflect(String key) {
        try {
            Class<?> clz = Class.forName("android.os.SystemProperties");
            Method getMethod = clz.getMethod("get", String.class, String.class);
            return (String)getMethod.invoke(clz, key, "");
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static class RomInfo {
        private String name;
        private String version;

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return "RomInfo{name=" + this.name + ", version=" + this.version + "}";
        }
    }
}

