/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.actor.scheduler.executor;

import com.blazebit.actor.ActorContext;
import com.blazebit.actor.ActorException;
import com.blazebit.actor.spi.Scheduler;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class ExecutorServiceScheduler
implements Scheduler {
    public static final String EXECUTOR_SERVICE_PROPERTY = "actor.scheduler.executor.executor_service";
    private static final Logger LOG = Logger.getLogger(ExecutorServiceScheduler.class.getName());
    private static final Class<?> MANAGED_EXECUTOR_SERVICE_CLASS;
    private final String name;
    private final ScheduledExecutorService executorService;

    public ExecutorServiceScheduler() {
        this(Executors.newSingleThreadScheduledExecutor());
    }

    public ExecutorServiceScheduler(ActorContext actorContext, String name) {
        this(name, ExecutorServiceScheduler.getExecutorService(actorContext, name));
    }

    public ExecutorServiceScheduler(ScheduledExecutorService executorService) {
        this(null, executorService);
    }

    public ExecutorServiceScheduler(String name, ScheduledExecutorService executorService) {
        if (executorService == null) {
            throw new ActorException("No executor service given");
        }
        this.name = name;
        this.executorService = executorService;
    }

    private static ScheduledExecutorService getExecutorService(ActorContext actorContext, String name) {
        Object executorService = null;
        if (name != null) {
            executorService = actorContext.getProperty("actor.scheduler.executor.executor_service." + name);
        }
        if (executorService != null) {
            if (executorService instanceof ScheduledExecutorService) {
                return (ScheduledExecutorService)executorService;
            }
            throw new ActorException("The object given via the property 'actor.scheduler.executor.executor_service." + name + "' should be a ScheduledExecutorService but isn't: " + executorService);
        }
        executorService = actorContext.getProperty(EXECUTOR_SERVICE_PROPERTY);
        if (executorService == null) {
            return (ScheduledExecutorService)actorContext.getService(ScheduledExecutorService.class);
        }
        if (executorService instanceof ScheduledExecutorService) {
            return (ScheduledExecutorService)executorService;
        }
        throw new ActorException("The object given via the property 'actor.scheduler.executor.executor_service' should be a ScheduledExecutorService but isn't: " + executorService);
    }

    public <T> Future<T> schedule(Callable<T> task, long delayMillis) {
        return this.executorService.schedule(task, delayMillis, TimeUnit.MILLISECONDS);
    }

    public boolean supportsStop() {
        return MANAGED_EXECUTOR_SERVICE_CLASS == null || !MANAGED_EXECUTOR_SERVICE_CLASS.isAssignableFrom(this.executorService.getClass());
    }

    public void stop() {
        if (!this.supportsStop()) {
            throw new UnsupportedOperationException();
        }
        this.executorService.shutdown();
    }

    public void stop(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.supportsStop()) {
            throw new UnsupportedOperationException();
        }
        this.executorService.shutdown();
        this.executorService.awaitTermination(timeout, unit);
    }

    static {
        Class<?> managedExecutorServiceClass = null;
        try {
            managedExecutorServiceClass = Class.forName("javax.enterprise.concurrent.ManagedExecutorService");
        }
        catch (ClassNotFoundException e) {
            LOG.warning("Couldn't find javax.enterprise.concurrent.ManagedExecutorService class, disabling shutdown detection");
        }
        MANAGED_EXECUTOR_SERVICE_CLASS = managedExecutorServiceClass;
    }
}

