/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.apt.service;

import com.blazebit.apt.AnnotationProcessingUtils;
import com.blazebit.apt.service.ServiceProvider;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.blazebit.apt.service.ServiceProvider"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class ServiceProviderAnnotationProcessor
extends AbstractProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.isEmpty()) {
            return true;
        }
        HashMap<String, ArrayList<String>> serviceProviders = new HashMap<String, ArrayList<String>>();
        for (Element element : roundEnv.getElementsAnnotatedWith(ServiceProvider.class)) {
            TypeElement typeElement = (TypeElement)element;
            AnnotationMirror annotation = AnnotationProcessingUtils.findAnnotationMirror(this.processingEnv, (Element)typeElement, ServiceProvider.class);
            if (annotation == null) continue;
            String service = AnnotationProcessingUtils.getAnnotationElementValue(this.processingEnv, annotation, "value").getValue().toString();
            ArrayList<String> providers = (ArrayList<String>)serviceProviders.get(service);
            if (providers == null) {
                providers = new ArrayList<String>();
                serviceProviders.put(service, providers);
            }
            providers.add(typeElement.getQualifiedName().toString());
        }
        String serviceFile = null;
        try {
            for (Map.Entry entry : serviceProviders.entrySet()) {
                serviceFile = (String)entry.getKey();
                FileObject providerFileObject = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", "META-INF/services/" + serviceFile, new Element[0]);
                List services = (List)entry.getValue();
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(providerFileObject.openWriter());
                    for (int i = 0; i < services.size(); ++i) {
                        writer.append((CharSequence)services.get(i)).append('\n');
                    }
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
        }
        catch (Exception exception) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(byteArrayOutputStream));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not create service file '" + serviceFile + "'\n" + byteArrayOutputStream.toString());
            return false;
        }
        return true;
    }
}

