/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.reflection;

import com.blazebit.reflection.MethodException;
import com.blazebit.reflection.MethodParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class ReflectionUtils {
    private static final Map<String, Class<?>> PRIMITIVE_NAME_TO_TYPE;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER;
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE;
    private static final Comparator<Field> FIELD_NAME_AND_DECLARING_CLASS_COMPARATOR;

    private ReflectionUtils() {
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        Class<?> clazz = PRIMITIVE_NAME_TO_TYPE.get(className);
        if (clazz == null) {
            clazz = Class.forName(className);
        }
        return clazz;
    }

    public static Class<?> getObjectClassOfPrimitve(Class<?> primitive) {
        Class<?> objectClass = PRIMITIVE_TO_WRAPPER.get(primitive);
        if (objectClass != null) {
            return objectClass;
        }
        return primitive;
    }

    public static Class<?> getWrapperClassOfPrimitve(Class<?> primitive) {
        return PRIMITIVE_TO_WRAPPER.get(primitive);
    }

    public static Class<?> getPrimitiveClassOfWrapper(Class<?> wrapperClass) {
        return WRAPPER_TO_PRIMITIVE.get(wrapperClass);
    }

    public static boolean isSubtype(Class<?> targetClazz, Class<?> superType) {
        return superType.isAssignableFrom(targetClazz);
    }

    public static Set<Class<?>> getSuperTypes(Class<?> clazz) {
        return ReflectionUtils.getSuperTypes(clazz, Object.class);
    }

    public static Set<Class<?>> getSuperTypes(Class<?> clazz, Class<?> commonSuperType) {
        LinkedHashSet list = new LinkedHashSet();
        ReflectionUtils.addSuperTypes(list, clazz, commonSuperType);
        return list;
    }

    private static void addSuperTypes(Set<Class<?>> superTypes, Class<?> clazz, Class<?> commonSuperType) {
        Class<?> traverseClass = clazz;
        do {
            if (ReflectionUtils.isSubtype(traverseClass, commonSuperType)) {
                superTypes.add(traverseClass);
            }
            for (Class<?> interfaceClass : traverseClass.getInterfaces()) {
                if (!ReflectionUtils.isSubtype(interfaceClass, commonSuperType)) continue;
                superTypes.add(interfaceClass);
            }
            for (Class<?> interfaceClass : traverseClass.getInterfaces()) {
                if (!ReflectionUtils.isSubtype(interfaceClass, commonSuperType)) continue;
                ReflectionUtils.addSuperTypes(superTypes, interfaceClass, commonSuperType);
            }
        } while ((traverseClass = traverseClass.getSuperclass()) != null);
    }

    public static Class<?> getFieldType(Class<?> clazz, String fieldName) {
        Field f = ReflectionUtils.getField(clazz, fieldName);
        if (f == null) {
            return null;
        }
        return f.getType();
    }

    public static Class<?> getResolvedFieldType(Class<?> clazz, String fieldName) {
        return ReflectionUtils.getResolvedFieldType(clazz, ReflectionUtils.getField(clazz, fieldName));
    }

    public static Class<?> getResolvedFieldType(Class<?> clazz, Field f) {
        if (f == null) {
            return null;
        }
        if (f.getGenericType() instanceof TypeVariable) {
            return ReflectionUtils.resolveTypeVariable(clazz, (TypeVariable)f.getGenericType());
        }
        return f.getType();
    }

    public static Class<?>[] getResolvedFieldTypeArguments(Class<?> clazz, String fieldName) {
        return ReflectionUtils.getResolvedFieldTypeArguments(clazz, ReflectionUtils.getField(clazz, fieldName));
    }

    public static Class<?>[] getResolvedFieldTypeArguments(Class<?> clazz, Field f) {
        if (f == null) {
            return null;
        }
        return ReflectionUtils.resolveTypeArguments(clazz, f.getGenericType());
    }

    public static Class<?>[] resolveTypeArguments(Class<?> concreteClass, Type type) {
        if (type instanceof ParameterizedType) {
            return ReflectionUtils.resolveTypeArguments(concreteClass, (ParameterizedType)type);
        }
        return new Class[0];
    }

    public static Class<?>[] resolveTypeArguments(Class<?> concreteClass, ParameterizedType parameterizedType) {
        if (parameterizedType == null) {
            return null;
        }
        Type[] argumentTypes = parameterizedType.getActualTypeArguments();
        Class[] resolvedClasses = new Class[argumentTypes.length];
        for (int i = 0; i < argumentTypes.length; ++i) {
            resolvedClasses[i] = ReflectionUtils.resolveType(concreteClass, argumentTypes[i]);
        }
        return resolvedClasses;
    }

    public static Type resolve(Class<?> concreteClass, Type type) {
        if (type instanceof TypeVariable) {
            return ReflectionUtils.resolveTypeVariableType(concreteClass, (TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return ReflectionUtils.getArrayClass((GenericArrayType)type);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getLowerBounds().length > 0) {
                return ReflectionUtils.resolve(concreteClass, wildcardType.getLowerBounds()[0]);
            }
            return ReflectionUtils.resolve(concreteClass, wildcardType.getUpperBounds()[0]);
        }
        return type;
    }

    public static Class<?> resolveType(Class<?> concreteClass, Type type) {
        if (type instanceof TypeVariable) {
            return ReflectionUtils.resolveTypeVariable(concreteClass, (TypeVariable)type);
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            return ReflectionUtils.getArrayClass((GenericArrayType)type);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getLowerBounds().length > 0) {
                return ReflectionUtils.resolveType(concreteClass, wildcardType.getLowerBounds()[0]);
            }
            return ReflectionUtils.resolveType(concreteClass, wildcardType.getUpperBounds()[0]);
        }
        return (Class)type;
    }

    private static Class<?> getArrayClass(GenericArrayType genericArrayType) {
        Class componentClass;
        Type componentType = genericArrayType.getGenericComponentType();
        if (componentType instanceof Class) {
            componentClass = (Class)componentType;
        } else if (componentType instanceof ParameterizedType) {
            componentClass = (Class)((ParameterizedType)componentType).getRawType();
        } else {
            throw new IllegalArgumentException("Unsupported array component type: " + componentType);
        }
        Object o = Array.newInstance(componentClass, 0);
        return o.getClass();
    }

    private static Class<?> getClassThatContainsTypeVariable(TypeVariable<?> typeVariable) {
        if (typeVariable.getGenericDeclaration().getClass() == Class.class) {
            return (Class)typeVariable.getGenericDeclaration();
        }
        if (typeVariable.getGenericDeclaration().getClass() == Method.class) {
            return ((Method)typeVariable.getGenericDeclaration()).getDeclaringClass();
        }
        if (typeVariable.getGenericDeclaration().getClass() == Constructor.class) {
            return ((Constructor)typeVariable.getGenericDeclaration()).getDeclaringClass();
        }
        return null;
    }

    public static Type resolveTypeVariableType(Class<?> concreteClass, TypeVariable<?> typeVariable) {
        Class<?> classThatContainsTypeVariable = ReflectionUtils.getClassThatContainsTypeVariable(typeVariable);
        if (concreteClass == classThatContainsTypeVariable) {
            return ReflectionUtils.resolve(concreteClass, typeVariable.getBounds()[0]);
        }
        if (!ReflectionUtils.isSubtype(concreteClass, classThatContainsTypeVariable)) {
            throw new IllegalArgumentException("The given concrete class is not a subtype of the class that contain the type variable!");
        }
        int position = ReflectionUtils.getTypeVariablePosition(typeVariable);
        if (position == -1) {
            throw new IllegalArgumentException("Type variable not found in its container class!");
        }
        Set<Class<?>> superTypes = ReflectionUtils.getSuperTypes(concreteClass, classThatContainsTypeVariable);
        ArrayList classStack = new ArrayList(superTypes.size());
        Type resolvedType = typeVariable;
        superTypes.remove(classThatContainsTypeVariable);
        classStack.addAll(superTypes);
        block0: while (!classStack.isEmpty() && !(resolvedType instanceof Class)) {
            Class classToInspect = (Class)classStack.remove(classStack.size() - 1);
            Type[] genericInterfaces = classToInspect.getGenericInterfaces();
            ArrayList<Type> typesToInspect = new ArrayList<Type>(genericInterfaces.length + 1);
            typesToInspect.add(classToInspect.getGenericSuperclass());
            Collections.addAll(typesToInspect, genericInterfaces);
            for (Type classToInspectType : typesToInspect) {
                ParameterizedType parameterizedClassToInspect;
                if (!(classToInspectType instanceof ParameterizedType) || !classThatContainsTypeVariable.equals((parameterizedClassToInspect = (ParameterizedType)classToInspectType).getRawType())) continue;
                if (parameterizedClassToInspect.getActualTypeArguments().length < position + 1) {
                    throw new IllegalArgumentException("Could not resolve type");
                }
                resolvedType = parameterizedClassToInspect.getActualTypeArguments()[position];
                if (resolvedType instanceof TypeVariable) {
                    position = ReflectionUtils.getTypeVariablePosition(classToInspect, resolvedType);
                    classThatContainsTypeVariable = ReflectionUtils.getClassThatContainsTypeVariable(resolvedType);
                    continue block0;
                }
                if (resolvedType instanceof ParameterizedType) {
                    resolvedType = ((ParameterizedType)resolvedType).getRawType();
                    continue block0;
                }
                if (resolvedType instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)resolvedType;
                    if (wildcardType.getLowerBounds().length > 0) {
                        resolvedType = ReflectionUtils.resolveType(concreteClass, wildcardType.getLowerBounds()[0]);
                        continue block0;
                    }
                    resolvedType = ReflectionUtils.resolveType(concreteClass, wildcardType.getUpperBounds()[0]);
                    continue block0;
                }
                if (!(resolvedType instanceof Class)) continue;
                continue block0;
            }
        }
        return resolvedType;
    }

    public static Class<?> resolveTypeVariable(Class<?> concreteClass, TypeVariable<?> typeVariable) {
        Type resolvedType = ReflectionUtils.resolveTypeVariableType(concreteClass, typeVariable);
        return ReflectionUtils.resolveType(concreteClass, resolvedType);
    }

    public static int getTypeVariablePosition(TypeVariable<?> typeVariable) {
        return ReflectionUtils.getTypeVariablePosition(typeVariable.getGenericDeclaration(), typeVariable);
    }

    public static int getTypeVariablePosition(GenericDeclaration genericDeclartion, TypeVariable<?> typeVariable) {
        int position = -1;
        TypeVariable<?>[] typeVariableDeclarationParameters = genericDeclartion.getTypeParameters();
        for (int i = 0; i < typeVariableDeclarationParameters.length; ++i) {
            if (!typeVariableDeclarationParameters[i].equals(typeVariable)) continue;
            position = i;
            break;
        }
        return position;
    }

    public static Field[] getInstanceFields(Class<?> clazz) {
        return ReflectionUtils.getNonMatchingFields(clazz, 8);
    }

    public static Field[] getStaticFields(Class<?> clazz) {
        return ReflectionUtils.getMatchingFields(clazz, 8);
    }

    public static Field[] getMatchingFields(Class<?> clazz, final int modifiers) {
        final TreeSet<Field> fields = new TreeSet<Field>(FIELD_NAME_AND_DECLARING_CLASS_COMPARATOR);
        ReflectionUtils.traverseHierarchy(clazz, new TraverseTask<Field>(){

            @Override
            public Field run(Class<?> clazz) {
                Field[] fieldArray = clazz.getDeclaredFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    if ((modifiers & fieldArray[i].getModifiers()) == 0) continue;
                    fields.add(fieldArray[i]);
                }
                return null;
            }
        });
        return fields.toArray(new Field[fields.size()]);
    }

    public static Field[] getNonMatchingFields(Class<?> clazz, final int modifiers) {
        final TreeSet<Field> fields = new TreeSet<Field>(FIELD_NAME_AND_DECLARING_CLASS_COMPARATOR);
        ReflectionUtils.traverseHierarchy(clazz, new TraverseTask<Field>(){

            @Override
            public Field run(Class<?> clazz) {
                Field[] fieldArray = clazz.getDeclaredFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    if ((modifiers & fieldArray[i].getModifiers()) != 0) continue;
                    fields.add(fieldArray[i]);
                }
                return null;
            }
        });
        return fields.toArray(new Field[fields.size()]);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        final String internedName = fieldName.intern();
        return ReflectionUtils.traverseHierarchy(clazz, new TraverseTask<Field>(){

            @Override
            public Field run(Class<?> clazz) {
                Field[] fields = clazz.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    if (fields[i].getName() != internedName) continue;
                    return fields[i];
                }
                return null;
            }
        });
    }

    public static Class<?> getMethodReturnType(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method m = ReflectionUtils.getMethod(clazz, methodName, parameterTypes);
        if (m == null) {
            return null;
        }
        return m.getReturnType();
    }

    public static Class<?>[] getMethodParameterTypes(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method m = ReflectionUtils.getMethod(clazz, methodName, parameterTypes);
        if (m == null) {
            return null;
        }
        return m.getParameterTypes();
    }

    public static Class<?>[] getMethodExceptionTypes(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method m = ReflectionUtils.getMethod(clazz, methodName, parameterTypes);
        if (m == null) {
            return null;
        }
        return m.getExceptionTypes();
    }

    public static Class<?> getResolvedMethodReturnType(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.getResolvedMethodReturnType(clazz, ReflectionUtils.getMethod(clazz, methodName, parameterTypes));
    }

    public static Class<?> getResolvedMethodReturnType(Class<?> clazz, Method m) {
        if (m == null) {
            return null;
        }
        if (m.getGenericReturnType() instanceof TypeVariable) {
            return ReflectionUtils.resolveTypeVariable(clazz, (TypeVariable)m.getGenericReturnType());
        }
        return m.getReturnType();
    }

    public static Class<?>[] getResolvedMethodReturnTypeArguments(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.getResolvedMethodReturnTypeArguments(clazz, ReflectionUtils.getMethod(clazz, methodName, parameterTypes));
    }

    public static Class<?>[] getResolvedMethodReturnTypeArguments(Class<?> clazz, Method m) {
        if (m == null) {
            return null;
        }
        return ReflectionUtils.resolveTypeArguments(clazz, m.getGenericReturnType());
    }

    public static Class<?>[] getResolvedMethodParameterTypes(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.getResolvedMethodParameterTypes(clazz, ReflectionUtils.getMethod(clazz, methodName, parameterTypes));
    }

    public static Class<?>[] getResolvedMethodParameterTypes(Class<?> clazz, Method m) {
        if (m == null) {
            return null;
        }
        Type[] genericParameterTypes = m.getGenericParameterTypes();
        Class[] parameterTypes = new Class[genericParameterTypes.length];
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            parameterTypes[i] = genericParameterTypes[i] instanceof TypeVariable ? ReflectionUtils.resolveTypeVariable(clazz, (TypeVariable)genericParameterTypes[i]) : (genericParameterTypes[i] instanceof ParameterizedType ? (Class)((ParameterizedType)genericParameterTypes[i]).getRawType() : (Class)genericParameterTypes[i]);
        }
        return parameterTypes;
    }

    public static Class<?>[][] getResolvedMethodParameterTypesArguments(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.getResolvedMethodParameterTypesArguments(clazz, ReflectionUtils.getMethod(clazz, methodName, parameterTypes));
    }

    public static Class<?>[][] getResolvedMethodParameterTypesArguments(Class<?> clazz, Method method) {
        int parameterCount = method.getParameterTypes().length;
        Class[][] parameterTypeArguments = new Class[parameterCount][];
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        for (int i = 0; i < parameterCount; ++i) {
            parameterTypeArguments[i] = ReflectionUtils.resolveTypeArguments(clazz, genericParameterTypes[i]);
        }
        return parameterTypeArguments;
    }

    public static Class<?>[] getResolvedMethodExceptionTypes(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.getResolvedMethodExceptionTypes(clazz, ReflectionUtils.getMethod(clazz, methodName, parameterTypes));
    }

    public static Class<?>[] getResolvedMethodExceptionTypes(Class<?> clazz, Method m) {
        if (m == null) {
            return null;
        }
        Type[] genericExceptionTypes = m.getGenericExceptionTypes();
        Class[] exceptionTypes = new Class[genericExceptionTypes.length];
        for (int i = 0; i < genericExceptionTypes.length; ++i) {
            exceptionTypes[i] = genericExceptionTypes[i] instanceof TypeVariable ? ReflectionUtils.resolveTypeVariable(clazz, (TypeVariable)genericExceptionTypes[i]) : (genericExceptionTypes[i] instanceof ParameterizedType ? (Class)((ParameterizedType)genericExceptionTypes[i]).getRawType() : (Class)genericExceptionTypes[i]);
        }
        return exceptionTypes;
    }

    public static MethodParameter[] getMethodParameters(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.getMethodParameters(clazz, ReflectionUtils.getMethod(clazz, methodName, parameterTypes));
    }

    public static MethodParameter[] getMethodParameters(Class<?> clazz, Method m) {
        if (m == null) {
            return null;
        }
        Type[] exceptionTypes = m.getGenericExceptionTypes();
        MethodParameter[] methodParameters = new MethodParameter[exceptionTypes.length];
        for (int i = 0; i < exceptionTypes.length; ++i) {
            methodParameters[i] = new MethodParameter(m, i);
        }
        return methodParameters;
    }

    public static MethodException[] getMethodExceptions(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.getMethodExceptions(clazz, ReflectionUtils.getMethod(clazz, methodName, parameterTypes));
    }

    public static MethodException[] getMethodExceptions(Class<?> clazz, Method m) {
        if (m == null) {
            return null;
        }
        Type[] exceptionTypes = m.getGenericExceptionTypes();
        MethodException[] methodExceptions = new MethodException[exceptionTypes.length];
        for (int i = 0; i < exceptionTypes.length; ++i) {
            methodExceptions[i] = new MethodException(m, i);
        }
        return methodExceptions;
    }

    public static Method getMethod(Class<?> clazz, String methodName, final Class<?> ... parameterTypes) {
        final String internedName = methodName.intern();
        return ReflectionUtils.traverseHierarchy(clazz, new TraverseTask<Method>(){

            @Override
            public Method run(Class<?> clazz) {
                Method[] methods = clazz.getDeclaredMethods();
                Method res = null;
                for (int i = 0; i < methods.length; ++i) {
                    Method m = methods[i];
                    if (m.getName() != internedName || !ReflectionUtils.arrayContentsEq(parameterTypes, m.getParameterTypes()) || res != null && !res.getReturnType().isAssignableFrom(m.getReturnType())) continue;
                    res = m;
                }
                return res;
            }
        });
    }

    private static <T> T traverseHierarchy(Class<?> clazz, TraverseTask<T> task) {
        LinkedList classQueue = new LinkedList();
        classQueue.add(clazz);
        while (!classQueue.isEmpty()) {
            Class traverseClass = (Class)classQueue.remove();
            T result = task.run(traverseClass);
            if (result != null) {
                return result;
            }
            if (traverseClass.getSuperclass() != null) {
                classQueue.add(traverseClass.getSuperclass());
            }
            for (Class<?> interfaceClass : traverseClass.getInterfaces()) {
                classQueue.add(interfaceClass);
            }
        }
        return null;
    }

    private static boolean arrayContentsEq(Object[] a1, Object[] a2) {
        if (a1 == null) {
            return a2 == null || a2.length == 0;
        }
        if (a2 == null) {
            return a1.length == 0;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static Method getMethod(Class<?> clazz, final Class<? extends Annotation> annotation) {
        return ReflectionUtils.traverseHierarchy(clazz, new TraverseTask<Method>(){

            @Override
            public Method run(Class<?> clazz) {
                Method[] methods = clazz.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method m = methods[i];
                    if (m.getAnnotation(annotation) == null) continue;
                    return m;
                }
                return null;
            }
        });
    }

    public static List<Method> getMethods(Class<?> clazz, final Class<? extends Annotation> annotation) {
        final ArrayList<Method> methods = new ArrayList<Method>();
        ReflectionUtils.traverseHierarchy(clazz, new TraverseTask<Method>(){

            @Override
            public Method run(Class<?> clazz) {
                Method[] methodArray = clazz.getDeclaredMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    Method m = methodArray[i];
                    if (m.getAnnotation(annotation) == null) continue;
                    methods.add(m);
                }
                return null;
            }
        });
        return methods;
    }

    public static Method getGetter(Class<?> clazz, String fieldName) {
        StringBuilder sb = new StringBuilder("get").append(Character.toUpperCase(fieldName.charAt(0))).append(fieldName, 1, fieldName.length());
        final String internedGetName = sb.toString().intern();
        final String internedIsName = sb.replace(0, 3, "is").toString().intern();
        return ReflectionUtils.traverseHierarchy(clazz, new TraverseTask<Method>(){

            @Override
            public Method run(Class<?> clazz) {
                Method[] methods = clazz.getDeclaredMethods();
                Method res = null;
                for (int i = 0; i < methods.length; ++i) {
                    Method m = methods[i];
                    if (!ReflectionUtils.isGetterSignature(m)) continue;
                    if (m.getName() == internedGetName && (res == null || res.getReturnType().isAssignableFrom(m.getReturnType()))) {
                        res = m;
                    }
                    if (m.getName() != internedIsName || res != null && !res.getReturnType().isAssignableFrom(m.getReturnType())) continue;
                    res = m;
                }
                return res;
            }
        });
    }

    private static boolean isGetterSignature(Method m) {
        return m != null && !Void.TYPE.equals(m.getReturnType()) && m.getParameterTypes().length == 0;
    }

    public static boolean isGetter(Method m) {
        return m != null && (m.getName().startsWith("get") || m.getName().startsWith("is")) && !Void.TYPE.equals(m.getReturnType()) && m.getParameterTypes().length == 0;
    }

    public static Method getSetter(Class<?> clazz, String fieldName) {
        StringBuilder sb = new StringBuilder("set").append(Character.toUpperCase(fieldName.charAt(0))).append(fieldName, 1, fieldName.length());
        final String internedName = sb.toString().intern();
        return ReflectionUtils.traverseHierarchy(clazz, new TraverseTask<Method>(){

            @Override
            public Method run(Class<?> clazz) {
                Method[] methods = clazz.getDeclaredMethods();
                Method res = null;
                for (int i = 0; i < methods.length; ++i) {
                    Method m = methods[i];
                    if (!ReflectionUtils.isSetterSignature(m) || m.getName() != internedName || res != null && !res.getParameterTypes()[0].isAssignableFrom(m.getParameterTypes()[0])) continue;
                    res = m;
                }
                return res;
            }
        });
    }

    private static boolean isSetterSignature(Method m) {
        return m != null && m.getReturnType().equals(Void.TYPE) && m.getParameterTypes().length == 1;
    }

    public static boolean isSetter(Method m) {
        return m != null && m.getName().startsWith("set") && m.getReturnType().equals(Void.TYPE) && m.getParameterTypes().length == 1;
    }

    static {
        HashMap<String, Class<Object>> primitiveNameToType = new HashMap<String, Class<Object>>();
        primitiveNameToType.put("int", Integer.TYPE);
        primitiveNameToType.put("long", Long.TYPE);
        primitiveNameToType.put("double", Double.TYPE);
        primitiveNameToType.put("float", Float.TYPE);
        primitiveNameToType.put("boolean", Boolean.TYPE);
        primitiveNameToType.put("char", Character.TYPE);
        primitiveNameToType.put("byte", Byte.TYPE);
        primitiveNameToType.put("void", Void.TYPE);
        primitiveNameToType.put("short", Short.TYPE);
        PRIMITIVE_NAME_TO_TYPE = Collections.unmodifiableMap(primitiveNameToType);
        HashMap<Class<Object>, Class<Short>> primitiveToWrapper = new HashMap<Class<Object>, Class<Short>>();
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapper.put(Character.TYPE, Character.class);
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Void.TYPE, Void.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_WRAPPER = Collections.unmodifiableMap(primitiveToWrapper);
        HashMap<Class<Short>, Class<Object>> wrapperToPrimitive = new HashMap<Class<Short>, Class<Object>>();
        wrapperToPrimitive.put(Integer.class, Integer.TYPE);
        wrapperToPrimitive.put(Long.class, Long.TYPE);
        wrapperToPrimitive.put(Double.class, Double.TYPE);
        wrapperToPrimitive.put(Float.class, Float.TYPE);
        wrapperToPrimitive.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitive.put(Character.class, Character.TYPE);
        wrapperToPrimitive.put(Byte.class, Byte.TYPE);
        wrapperToPrimitive.put(Void.class, Void.TYPE);
        wrapperToPrimitive.put(Short.class, Short.TYPE);
        WRAPPER_TO_PRIMITIVE = Collections.unmodifiableMap(wrapperToPrimitive);
        FIELD_NAME_AND_DECLARING_CLASS_COMPARATOR = new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                int result = o1.getName().compareTo(o2.getName());
                return result == 0 ? o1.getDeclaringClass().getName().compareTo(o2.getDeclaringClass().getName()) : result;
            }
        };
    }

    private static interface TraverseTask<T> {
        public T run(Class<?> var1);
    }
}

