/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.collection;

import com.blazebit.regex.Pattern;
import com.blazebit.regex.node.CharNode;
import com.blazebit.regex.node.CharRangeNode;
import com.blazebit.regex.node.ComplementNode;
import com.blazebit.regex.node.DotNode;
import com.blazebit.regex.node.EmptyNode;
import com.blazebit.regex.node.Node;
import com.blazebit.regex.node.OptionalNode;
import com.blazebit.regex.node.OrNode;
import com.blazebit.regex.node.RepeatNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PatternTrie<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TrieNode<V> root = new TrieNode();
    private final Map<Integer, List<PatternParameter>> patternParameters = new HashMap<Integer, List<PatternParameter>>();
    private int patternIds = 0;

    public PatternTrie<V> add(CharSequence key, V value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Map<Parameter, ExtendedPattern> emptyMap = Collections.emptyMap();
        this.add(key.toString().toCharArray(), value, -1, emptyMap);
        return this;
    }

    public ParameterizedKeyBuilder<V> parameterized(CharSequence pattern, final V value) {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        final char[] chars = pattern.toString().toCharArray();
        if (chars.length > 0) {
            final LinkedHashMap<Parameter, ExtendedPattern> parameters = new LinkedHashMap<Parameter, ExtendedPattern>();
            ExtendedPattern parameterPattern = new ExtendedPattern(".*", false);
            int parameterStartIndex = -1;
            block4: for (int cursor = 0; cursor < chars.length; ++cursor) {
                switch (chars[cursor]) {
                    case '{': {
                        if (parameterStartIndex > -1 && cursor != 0 && chars[cursor - 1] != '\\') {
                            throw new IllegalArgumentException("Unescaped '{' in parameter name at position " + cursor);
                        }
                        parameterStartIndex = cursor;
                        continue block4;
                    }
                    case '}': {
                        if (parameterStartIndex < 0 && cursor != 0 && chars[cursor - 1] != '\\') {
                            throw new IllegalArgumentException("Unescaped '{' found at position " + cursor);
                        }
                        String parameterName = new String(chars, parameterStartIndex + 1, cursor - parameterStartIndex - 1);
                        if (parameters.put(new Parameter(parameterName, parameterStartIndex), parameterPattern) != null) {
                            throw new IllegalArgumentException("Parameter name '" + parameterName + "' is used twice at position " + parameterStartIndex);
                        }
                        parameterStartIndex = -1;
                        continue block4;
                    }
                }
            }
            if (parameterStartIndex > -1) {
                throw new IllegalArgumentException("Unclosed bracket at position " + parameterStartIndex);
            }
            return new ParameterizedKeyBuilder<V>(){

                @Override
                public ParameterizedKeyBuilder<V> matchingNot(String parameterName, String pattern) {
                    if (parameterName == null) {
                        throw new NullPointerException("parameterName");
                    }
                    if (parameters.put(new Parameter(parameterName, -1), new ExtendedPattern(pattern, true)) == null) {
                        throw new IllegalArgumentException("Unknown parameter '" + parameterName + "'");
                    }
                    return this;
                }

                @Override
                public ParameterizedKeyBuilder<V> matching(String parameterName, String pattern) {
                    if (parameterName == null) {
                        throw new NullPointerException("parameterName");
                    }
                    if (parameters.put(new Parameter(parameterName, -1), new ExtendedPattern(pattern, false)) == null) {
                        throw new IllegalArgumentException("Unknown parameter '" + parameterName + "'");
                    }
                    return this;
                }

                @Override
                public void add() {
                    PatternTrie.this.add(chars, value, PatternTrie.this.patternIds++, parameters);
                }
            };
        }
        return new ParameterizedKeyBuilder<V>(){

            @Override
            public ParameterizedKeyBuilder<V> matchingNot(String parameterName, String pattern) {
                if (parameterName == null) {
                    throw new NullPointerException("parameterName");
                }
                throw new IllegalArgumentException("Unknown parameter '" + parameterName + "'");
            }

            @Override
            public ParameterizedKeyBuilder<V> matching(String parameterName, String pattern) {
                if (parameterName == null) {
                    throw new NullPointerException("parameterName");
                }
                throw new IllegalArgumentException("Unknown parameter '" + parameterName + "'");
            }

            @Override
            public void add() {
                Map emptyMap = Collections.emptyMap();
                PatternTrie.this.add(chars, value, -1, emptyMap);
            }
        };
    }

    public Set<ParameterizedValue<V>> resolve(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        HashSet<ParameterizedValue<V>> result = new HashSet<ParameterizedValue<V>>();
        char[] chars = key.toString().toCharArray();
        Map<TrieNode<V>, Map<PatternParameter, ParameterResult>> currentNodes = new HashMap(1);
        if (this.root != null) {
            currentNodes.put(this.root, new HashMap(0));
        }
        for (int i = 0; i < chars.length && !currentNodes.isEmpty(); ++i) {
            currentNodes = this.findMatchingNodes(currentNodes, chars[i]);
        }
        for (Map.Entry entry : currentNodes.entrySet()) {
            System.out.println(((TrieNode)entry.getKey()).value + " ----");
            for (ParameterResult parameterResult : ((Map)entry.getValue()).values()) {
                System.out.println(parameterResult.parameter.name + " - " + parameterResult.parameter.patternId + " - " + parameterResult.value.toString());
            }
        }
        if (!currentNodes.isEmpty()) {
            for (Map.Entry<Object, Object> entry : currentNodes.entrySet()) {
                TrieNode node = (TrieNode)entry.getKey();
                if (!node.inUse) continue;
                for (Object nodeValue : node.value) {
                    ParameterizedValueImpl value = new ParameterizedValueImpl(nodeValue);
                    for (ParameterResult parameterResult : ((Map)entry.getValue()).values()) {
                        if (!parameterResult.ended) continue;
                        value.setParameter(parameterResult.parameter.name, parameterResult.value.toString());
                    }
                    result.add(value);
                }
            }
        }
        return result;
    }

    private Map<TrieNode<V>, Map<PatternParameter, ParameterResult>> findMatchingNodes(Map<TrieNode<V>, Map<PatternParameter, ParameterResult>> nodes, char c) {
        HashMap<TrieNode<Map<PatternParameter, ParameterResult>>, Map<PatternParameter, ParameterResult>> matchingNodes = new HashMap<TrieNode<Map<PatternParameter, ParameterResult>>, Map<PatternParameter, ParameterResult>>(1);
        for (Map.Entry<TrieNode<V>, Map<PatternParameter, ParameterResult>> nodeEntry : nodes.entrySet()) {
            TrieNode<V> node = nodeEntry.getKey();
            TrieNode childNode = ((TrieNode)node).anyCharChild;
            if (childNode != null) {
                matchingNodes.put(childNode, this.getParameterResult(nodeEntry.getValue(), c, childNode.associatedParameters, childNode.associatedParametersEnd));
            }
            if ((childNode = (TrieNode)((TrieNode)node).children.get(Character.valueOf(c))) != null) {
                matchingNodes.put(childNode, this.getParameterResult(nodeEntry.getValue(), c, childNode.associatedParameters, childNode.associatedParametersEnd));
            }
            for (Map.Entry entry : ((TrieNode)node).complementChildren.entrySet()) {
                childNode = (TrieNode)entry.getValue();
                if (((Character)entry.getKey()).charValue() == c && childNode.associatedParametersEnd.isEmpty()) continue;
                matchingNodes.put(childNode, this.getParameterResult(nodeEntry.getValue(), c, childNode.associatedParameters, childNode.associatedParametersEnd));
            }
            if (((TrieNode)node).anyCharChild != null || !((TrieNode)node).children.isEmpty() || !((TrieNode)node).complementChildren.isEmpty()) continue;
            for (Map.Entry<Object, Object> entry : nodeEntry.getValue().entrySet()) {
                if (!((TrieNode)node).associatedParametersEnd.contains(entry.getKey())) continue;
                matchingNodes.put(node, this.getParameterResult(nodeEntry.getValue(), c, ((TrieNode)node).associatedParameters, ((TrieNode)node).associatedParametersEnd));
            }
        }
        return matchingNodes;
    }

    private Map<PatternParameter, ParameterResult> getParameterResult(Map<PatternParameter, ParameterResult> parameterResults, char c, Set<PatternParameter> associatedParameters, Set<PatternParameter> associatedParametersEnd) {
        parameterResults = new HashMap<PatternParameter, ParameterResult>(parameterResults);
        for (PatternParameter parameter : associatedParameters) {
            ParameterResult parameterResult = parameterResults.get(parameter);
            if (parameterResult == null) {
                parameterResult = new ParameterResult(parameter);
                parameterResults.put(parameter, parameterResult);
            }
            parameterResult.value.append(c);
            if (!associatedParametersEnd.contains(parameter)) continue;
            parameterResult.ended = true;
        }
        return parameterResults;
    }

    private void add(char[] pattern, V value, int patternId, Map<Parameter, ExtendedPattern> parameters) {
        int cursor;
        if (pattern.length == 0) {
            this.update(this.root, value);
        }
        if (parameters.isEmpty()) {
            TrieNode currentNode = this.root;
            TrieNode lastNode = null;
            for (cursor = 0; cursor < pattern.length && currentNode != null; ++cursor) {
                lastNode = currentNode;
                currentNode = (TrieNode)currentNode.children.get(Character.valueOf(pattern[cursor]));
            }
            if (currentNode == null) {
                --cursor;
                while (cursor < pattern.length - 1) {
                    TrieNode nextNode = new TrieNode();
                    lastNode.children.put(Character.valueOf(pattern[cursor]), nextNode);
                    lastNode = nextNode;
                    ++cursor;
                }
                lastNode.children.put(Character.valueOf(pattern[cursor]), new TrieNode<V>(value));
            } else {
                this.update(currentNode, value);
            }
        } else {
            ArrayList<Map.Entry<Parameter, ExtendedPattern>> parameterEntries = new ArrayList<Map.Entry<Parameter, ExtendedPattern>>(parameters.entrySet());
            List<TrieNode<V>> currentNodes = new ArrayList<TrieNode<V>>();
            currentNodes.add(this.root);
            this.patternParameters.put(patternId, new ArrayList());
            int currentParameterIndex = 0;
            Parameter currentParameter = (Parameter)((Map.Entry)parameterEntries.get(currentParameterIndex)).getKey();
            int currentParameterStart = currentParameter.startPosition;
            while (cursor < pattern.length - 1) {
                if (currentParameterStart == cursor) {
                    PatternParameter patternParameter = new PatternParameter(patternId, currentParameterIndex, currentParameter.name);
                    this.patternParameters.get(patternId).add(patternParameter);
                    currentNodes = this.getOrCreatePatternNodes(currentNodes, patternParameter, (ExtendedPattern)((Map.Entry)parameterEntries.get(currentParameterIndex)).getValue());
                    cursor = currentParameterStart + currentParameter.name.length();
                    if (++currentParameterIndex < parameterEntries.size()) {
                        ++cursor;
                        currentParameter = (Parameter)((Map.Entry)parameterEntries.get(currentParameterIndex)).getKey();
                        currentParameterStart = currentParameter.startPosition;
                    }
                } else {
                    currentNodes = this.getOrCreate(currentNodes, Character.valueOf(pattern[cursor]), null);
                }
                ++cursor;
            }
            if (cursor == pattern.length - 1) {
                this.update(currentNodes, value);
            } else {
                this.update(this.getOrCreate(currentNodes, Character.valueOf(pattern[cursor]), null), value);
            }
        }
    }

    private void update(TrieNode<V> node, V value) {
        if (((TrieNode)node).inUse) {
            ((TrieNode)node).value.add(value);
        } else {
            ((TrieNode)node).value = new ArrayList();
            ((TrieNode)node).value.add(value);
            ((TrieNode)node).inUse = true;
        }
    }

    private void update(List<TrieNode<V>> nodes, V value) {
        for (int i = 0; i < nodes.size(); ++i) {
            this.update(nodes.get(i), value);
        }
    }

    private List<TrieNode<V>> getOrCreate(List<TrieNode<V>> nodes, Character c, PatternParameter parameter) {
        ArrayList<TrieNode<V>> resultNodes = new ArrayList<TrieNode<V>>(nodes.size());
        for (int i = 0; i < nodes.size(); ++i) {
            TrieNode node = (TrieNode)((TrieNode)nodes.get(i)).children.get(c);
            if (node == null) {
                node = new TrieNode();
                ((TrieNode)nodes.get(i)).children.put(c, node);
            }
            resultNodes.add(node);
            if (parameter == null) continue;
            node.associatedParameters.add(parameter);
        }
        return resultNodes;
    }

    private List<TrieNode<V>> getOrCreateAnyChar(List<TrieNode<V>> nodes, PatternParameter parameter) {
        ArrayList<TrieNode<V>> resultNodes = new ArrayList<TrieNode<V>>(nodes.size());
        for (int i = 0; i < nodes.size(); ++i) {
            TrieNode node = ((TrieNode)nodes.get(i)).anyCharChild;
            if (node == null) {
                node = new TrieNode();
                ((TrieNode)nodes.get(i)).anyCharChild = node;
            }
            resultNodes.add(node);
            if (parameter == null) continue;
            node.associatedParameters.add(parameter);
        }
        return resultNodes;
    }

    private List<TrieNode<V>> getOrCreateComplement(List<TrieNode<V>> nodes, Character c, PatternParameter parameter) {
        ArrayList<TrieNode<V>> resultNodes = new ArrayList<TrieNode<V>>(nodes.size());
        for (int i = 0; i < nodes.size(); ++i) {
            TrieNode node = (TrieNode)((TrieNode)nodes.get(i)).complementChildren.get(c);
            if (node == null) {
                node = new TrieNode();
                ((TrieNode)nodes.get(i)).complementChildren.put(c, node);
            }
            resultNodes.add(node);
            if (parameter == null) continue;
            node.associatedParameters.add(parameter);
        }
        return resultNodes;
    }

    private void mergeIntoNodes(List<TrieNode<V>> nodes, TrieNode<V> node) {
        int i;
        TrieNode tempTargetNode;
        TrieNode<V> targetNode;
        int i2;
        ArrayList<TrieNode<V>> newTargetNodes;
        if (nodes.isEmpty()) {
            return;
        }
        for (Map.Entry tempNodeEntry : ((TrieNode)node).children.entrySet()) {
            newTargetNodes = new ArrayList<TrieNode<V>>();
            for (i2 = 0; i2 < nodes.size(); ++i2) {
                targetNode = nodes.get(i2);
                tempTargetNode = (TrieNode)((TrieNode)targetNode).children.get(tempNodeEntry.getKey());
                if (tempTargetNode == null) {
                    ((TrieNode)targetNode).children.put(tempNodeEntry.getKey(), tempNodeEntry.getValue());
                    continue;
                }
                newTargetNodes.add(tempTargetNode);
            }
            this.mergeIntoNodes(newTargetNodes, (TrieNode)tempNodeEntry.getValue());
        }
        for (Map.Entry tempNodeEntry : ((TrieNode)node).complementChildren.entrySet()) {
            newTargetNodes = new ArrayList();
            for (i2 = 0; i2 < nodes.size(); ++i2) {
                targetNode = nodes.get(i2);
                tempTargetNode = (TrieNode)((TrieNode)targetNode).complementChildren.get(tempNodeEntry.getKey());
                if (tempTargetNode == null) {
                    ((TrieNode)targetNode).complementChildren.put(tempNodeEntry.getKey(), tempNodeEntry.getValue());
                    continue;
                }
                newTargetNodes.add(tempTargetNode);
            }
            this.mergeIntoNodes(newTargetNodes, (TrieNode)tempNodeEntry.getValue());
        }
        ArrayList<TrieNode<V>> newTargetNodes2 = new ArrayList<TrieNode<V>>();
        for (i = 0; i < nodes.size(); ++i) {
            TrieNode<V> targetNode2 = nodes.get(i);
            TrieNode tempTargetNode2 = ((TrieNode)targetNode2).anyCharChild;
            if (tempTargetNode2 == null) {
                ((TrieNode)targetNode2).anyCharChild = ((TrieNode)node).anyCharChild;
            } else {
                newTargetNodes2.add(tempTargetNode2);
            }
            ((TrieNode)targetNode2).associatedParameters.addAll(((TrieNode)node).associatedParameters);
            ((TrieNode)targetNode2).associatedParametersEnd.addAll(((TrieNode)node).associatedParametersEnd);
        }
        if (((TrieNode)node).anyCharChild != null) {
            this.mergeIntoNodes(newTargetNodes2, ((TrieNode)node).anyCharChild);
        }
        if (((TrieNode)node).inUse) {
            for (i = 0; i < nodes.size(); ++i) {
                for (int j = 0; j < ((TrieNode)node).value.size(); ++j) {
                    this.update(nodes.get(i), ((TrieNode)node).value.get(j));
                }
            }
        }
    }

    private List<TrieNode<V>> getOrCreatePatternNodes(List<TrieNode<V>> lastNodes, PatternParameter parameter, ExtendedPattern pattern) {
        TraverseContext context = new TraverseContext(parameter);
        if (pattern.negated) {
            context.complement();
        }
        this.traverse(Pattern.parse(pattern.pattern), context, lastNodes, pattern.negated);
        ArrayList<TrieNode<V>> result = new ArrayList<TrieNode<V>>(context.getEndStates().size());
        for (TrieNode endState : context.getEndStates()) {
            endState.associatedParametersEnd.add(parameter);
            result.add(endState);
        }
        return result;
    }

    private boolean moreRequiredExists(Node node, TraverseContext<V> context) {
        for (Node nextNode = node.getNext(); nextNode != null; nextNode = nextNode.getNext()) {
            if (nextNode instanceof OptionalNode || nextNode instanceof RepeatNode && ((RepeatNode)nextNode).getMin() != 0) continue;
            return true;
        }
        return false;
    }

    private List<TrieNode<V>> traverse(Node node, TraverseContext<V> context, List<TrieNode<V>> trieNodes, boolean negated) {
        List<Object> newNodes = null;
        boolean moreRequiredSet = false;
        if (!context.hasMoreRequired()) {
            moreRequiredSet = this.moreRequiredExists(node, context);
            context.setHasMoreRequired(moreRequiredSet);
        }
        if (node instanceof OrNode) {
            OrNode orNode = (OrNode)node;
            List<Node> nodes = orNode.getNodes();
            newNodes = new ArrayList(trieNodes.size() * nodes.size());
            for (int i = 0; i < nodes.size(); ++i) {
                newNodes.addAll(this.traverse(nodes.get(i), context, trieNodes, negated));
            }
        } else if (node instanceof RepeatNode) {
            List<Object> tempNodes;
            RepeatNode repeatNode = (RepeatNode)node;
            TrieNode tempNode = new TrieNode();
            ArrayList<TrieNode<V>> tempNodeList = new ArrayList<TrieNode<V>>(1);
            tempNodeList.add(tempNode);
            newNodes = this.traverse(repeatNode.getDecorated(), context, tempNodeList, negated);
            if (repeatNode.getMax() != Integer.MAX_VALUE) {
                tempNodes = newNodes;
                newNodes = new ArrayList();
                for (int i = 1; i < repeatNode.getMax(); ++i) {
                    tempNodes = this.traverse(repeatNode.getDecorated(), context, tempNodes, negated);
                    if (i + 1 < repeatNode.getMin()) continue;
                    newNodes.addAll(tempNodes);
                }
            } else if (repeatNode.getMin() != 0) {
                tempNodes = newNodes;
                newNodes = new ArrayList();
                for (int i = 1; i < repeatNode.getMin() - 1; ++i) {
                    tempNodes = this.traverse(repeatNode.getDecorated(), context, tempNodes, negated);
                }
                if (repeatNode.getMin() != 1) {
                    TrieNode minFulfilledNode = new TrieNode();
                    ArrayList<TrieNode<V>> minFulfilledNodeList = new ArrayList<TrieNode<V>>(1);
                    minFulfilledNodeList.add(minFulfilledNode);
                    newNodes = this.traverse(repeatNode.getDecorated(), context, minFulfilledNodeList, negated);
                    this.mergeIntoNodes(tempNodes, minFulfilledNode);
                    this.mergeIntoNodes(newNodes, minFulfilledNode);
                } else {
                    newNodes = tempNodes;
                    this.mergeIntoNodes(newNodes, tempNode);
                }
            } else {
                this.mergeIntoNodes(newNodes, tempNode);
            }
            this.mergeIntoNodes(trieNodes, tempNode);
            if (repeatNode.getMin() == 0) {
                newNodes.addAll(trieNodes);
            }
        } else if (node instanceof OptionalNode) {
            newNodes = this.traverse(((OptionalNode)node).getDecorated(), context, trieNodes, negated);
            newNodes.addAll(trieNodes);
        } else if (node instanceof ComplementNode) {
            context.complement();
            newNodes = this.traverse(((ComplementNode)node).getDecorated(), context, trieNodes, negated);
            context.complement();
        } else if (node instanceof CharRangeNode) {
            int i;
            newNodes = new ArrayList(trieNodes.size());
            CharRangeNode rangeNode = (CharRangeNode)node;
            int start = rangeNode.getStart();
            char end = rangeNode.getEnd();
            if (context.isComplement()) {
                for (i = start; i <= end; ++i) {
                    newNodes.addAll(this.getOrCreateComplement(trieNodes, Character.valueOf((char)i), ((TraverseContext)context).parameter));
                }
            } else {
                for (i = start; i <= end; ++i) {
                    newNodes.addAll(this.getOrCreate(trieNodes, Character.valueOf((char)i), ((TraverseContext)context).parameter));
                }
            }
        } else if (node instanceof CharNode) {
            newNodes = context.isComplement() ? this.getOrCreateComplement(trieNodes, Character.valueOf(((CharNode)node).getCharacter()), ((TraverseContext)context).parameter) : this.getOrCreate(trieNodes, Character.valueOf(((CharNode)node).getCharacter()), ((TraverseContext)context).parameter);
        } else if (node instanceof DotNode) {
            newNodes = this.getOrCreateAnyChar(trieNodes, ((TraverseContext)context).parameter);
        } else {
            if (node instanceof EmptyNode) {
                throw new IllegalArgumentException("Empty bracket not allowed");
            }
            throw new IllegalArgumentException("Unknown node");
        }
        if (newNodes != null) {
            if (!context.hasMoreRequired() || negated) {
                for (int i = 0; i < newNodes.size(); ++i) {
                    context.addEndState((TrieNode)newNodes.get(i));
                }
            }
            if (moreRequiredSet) {
                context.setHasMoreRequired(false);
            }
            if (node.getNext() != null) {
                newNodes = this.traverse(node.getNext(), context, newNodes, negated);
            }
        }
        return newNodes;
    }

    public String toString() {
        HashMap<PatternParameter, Integer> parameterCount = new HashMap<PatternParameter, Integer>();
        for (List<PatternParameter> params : this.patternParameters.values()) {
            for (PatternParameter param : params) {
                parameterCount.put(param, 0);
            }
        }
        return PatternTrie.toString(this.root, new StringBuilder(), 0, parameterCount, 100).toString();
    }

    private static boolean anyReachedThreshold(Map<PatternParameter, Integer> parameterCount, Set<PatternParameter> parameters, int charCountThreshold) {
        for (PatternParameter param : parameters) {
            if (parameterCount.get(param) != charCountThreshold) continue;
            return true;
        }
        return false;
    }

    private static <V> StringBuilder toString(TrieNode<V> node, StringBuilder sb, int depth, Map<PatternParameter, Integer> parameterCount, int charCountThreshold) {
        Object entry;
        if (((TrieNode)node).inUse) {
            sb.append(" => ");
            sb.append(((TrieNode)node).value == null ? "null" : ((TrieNode)node).value.toString());
            sb.append('\n');
            depth += 2;
            for (int i = 0; i < depth; ++i) {
                sb.append(' ');
            }
        }
        for (PatternParameter patternParameter : ((TrieNode)node).associatedParameters) {
            parameterCount.put(patternParameter, parameterCount.get(patternParameter) + 1);
        }
        if (((TrieNode)node).children.size() == 1 && ((TrieNode)node).complementChildren.size() == 0 && ((TrieNode)node).anyCharChild == null) {
            entry = ((TrieNode)node).children.entrySet().iterator().next();
            sb.append('[');
            sb.append(entry.getKey());
            sb.append(']');
            if (PatternTrie.anyReachedThreshold(parameterCount, ((TrieNode)entry.getValue()).associatedParameters, charCountThreshold)) {
                sb.append("(...)");
            } else {
                PatternTrie.toString((TrieNode)entry.getValue(), sb, depth, parameterCount, charCountThreshold);
            }
        } else if (((TrieNode)node).children.size() == 0 && ((TrieNode)node).complementChildren.size() == 1 && ((TrieNode)node).anyCharChild == null) {
            entry = ((TrieNode)node).complementChildren.entrySet().iterator().next();
            sb.append('[').append('^');
            sb.append(entry.getKey());
            sb.append(']');
            if (PatternTrie.anyReachedThreshold(parameterCount, ((TrieNode)entry.getValue()).associatedParameters, charCountThreshold)) {
                sb.append("(...)");
            } else {
                PatternTrie.toString((TrieNode)entry.getValue(), sb, depth, parameterCount, charCountThreshold);
            }
        } else if (((TrieNode)node).children.size() == 0 && ((TrieNode)node).complementChildren.size() == 0 && ((TrieNode)node).anyCharChild != null) {
            sb.append('.');
            if (PatternTrie.anyReachedThreshold(parameterCount, ((TrieNode)node).anyCharChild.associatedParameters, charCountThreshold)) {
                sb.append("(...)");
            } else {
                PatternTrie.toString(((TrieNode)node).anyCharChild, sb, depth, parameterCount, charCountThreshold);
            }
        } else {
            int i;
            depth += 2;
            for (Map.Entry entry2 : ((TrieNode)node).children.entrySet()) {
                sb.append('\n');
                for (i = 0; i < depth; ++i) {
                    sb.append(' ');
                }
                sb.append('[');
                sb.append(entry2.getKey());
                sb.append(']');
                if (PatternTrie.anyReachedThreshold(parameterCount, ((TrieNode)entry2.getValue()).associatedParameters, charCountThreshold)) {
                    sb.append("(...)");
                    continue;
                }
                PatternTrie.toString((TrieNode)entry2.getValue(), sb, depth, parameterCount, charCountThreshold);
            }
            for (Map.Entry entry3 : ((TrieNode)node).complementChildren.entrySet()) {
                sb.append('\n');
                for (i = 0; i < depth; ++i) {
                    sb.append(' ');
                }
                sb.append('[').append('^');
                sb.append(entry3.getKey());
                sb.append(']');
                if (PatternTrie.anyReachedThreshold(parameterCount, ((TrieNode)entry3.getValue()).associatedParameters, charCountThreshold)) {
                    sb.append("(...)");
                    continue;
                }
                PatternTrie.toString((TrieNode)entry3.getValue(), sb, depth, parameterCount, charCountThreshold);
            }
            if (((TrieNode)node).anyCharChild != null) {
                sb.append('\n');
                for (int i2 = 0; i2 < depth; ++i2) {
                    sb.append(' ');
                }
                sb.append('.');
                if (PatternTrie.anyReachedThreshold(parameterCount, ((TrieNode)node).anyCharChild.associatedParameters, charCountThreshold)) {
                    sb.append("(...)");
                } else {
                    PatternTrie.toString(((TrieNode)node).anyCharChild, sb, depth, parameterCount, charCountThreshold);
                }
            }
        }
        return sb;
    }

    private static final class TraverseContext<V> {
        private boolean hasMoreRequired = false;
        private boolean complement = false;
        private final Set<TrieNode<V>> endStates = new HashSet<TrieNode<V>>();
        private final PatternParameter parameter;

        public TraverseContext(PatternParameter parameter) {
            this.parameter = parameter;
        }

        public void addEndState(TrieNode<V> state) {
            this.endStates.add(state);
        }

        public Set<TrieNode<V>> getEndStates() {
            return this.endStates;
        }

        public boolean isComplement() {
            return this.complement;
        }

        public void complement() {
            this.complement = !this.complement;
        }

        public boolean hasMoreRequired() {
            return this.hasMoreRequired;
        }

        public void setHasMoreRequired(boolean hasMoreRequired) {
            this.hasMoreRequired = hasMoreRequired;
        }
    }

    private static final class TrieNode<V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<Character, TrieNode<V>> children = new HashMap<Character, TrieNode<V>>();
        private final Map<Character, TrieNode<V>> complementChildren = new HashMap<Character, TrieNode<V>>();
        private List<V> value;
        private boolean inUse;
        private TrieNode<V> anyCharChild;
        private final Set<PatternParameter> associatedParameters = new HashSet<PatternParameter>();
        private final Set<PatternParameter> associatedParametersEnd = new HashSet<PatternParameter>();

        public TrieNode(V value) {
            this.value = new ArrayList<V>();
            this.value.add(value);
            this.inUse = true;
        }

        public TrieNode() {
            this.inUse = false;
        }

        public String toString() {
            return this.toString(0);
        }

        private String toString(int depth) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Character, TrieNode<V>> entry : this.children.entrySet()) {
                int i;
                for (i = 0; i < depth; ++i) {
                    sb.append(' ');
                }
                sb.append('[').append(entry.getKey()).append("] = {\n").append(super.toString(depth + 1));
                sb.append("\n");
                for (i = 0; i < depth; ++i) {
                    sb.append(' ');
                }
                sb.append("}");
            }
            return sb.toString();
        }
    }

    private static final class ParameterizedValueImpl<V>
    implements ParameterizedValue<V> {
        private V value;
        private final Map<String, String> parameters = new HashMap<String, String>();

        public ParameterizedValueImpl(V value) {
            this.value = value;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public String getParameter(String patternKey) {
            return this.parameters.get(patternKey);
        }

        @Override
        public Set<String> getParameterNames() {
            return this.parameters.keySet();
        }

        public void setParameter(String patternKey, String value) {
            this.parameters.put(patternKey, value);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ParameterizedValueImpl)) {
                return false;
            }
            ParameterizedValueImpl other = (ParameterizedValueImpl)obj;
            if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    private static final class ExtendedPattern {
        private final String pattern;
        private final boolean negated;

        public ExtendedPattern(String pattern, boolean negated) {
            this.pattern = pattern;
            this.negated = negated;
        }
    }

    private static final class Parameter {
        private final String name;
        private final int startPosition;

        public Parameter(String name, int startPosition) {
            this.name = name;
            this.startPosition = startPosition;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter other = (Parameter)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    private static final class PatternParameter {
        private final int patternId;
        private final int parameterIndex;
        private final String name;

        public PatternParameter(int patternId, int parameterIndex, String name) {
            this.patternId = patternId;
            this.parameterIndex = parameterIndex;
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.parameterIndex;
            result = 31 * result + this.patternId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PatternParameter other = (PatternParameter)obj;
            if (this.parameterIndex != other.parameterIndex) {
                return false;
            }
            return this.patternId == other.patternId;
        }
    }

    private static class ParameterResult {
        private PatternParameter parameter;
        private StringBuilder value;
        private boolean ended = false;

        public ParameterResult(PatternParameter parameter) {
            this.parameter = parameter;
            this.value = new StringBuilder();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.parameter == null ? 0 : this.parameter.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ParameterResult)) {
                return false;
            }
            ParameterResult other = (ParameterResult)obj;
            return !(this.parameter == null ? other.parameter != null : !this.parameter.equals(other.parameter));
        }
    }

    public static interface ParameterizedValue<V> {
        public V getValue();

        public String getParameter(String var1);

        public Set<String> getParameterNames();
    }

    public static interface ParameterizedKeyBuilder<V> {
        public ParameterizedKeyBuilder<V> matching(String var1, String var2);

        public ParameterizedKeyBuilder<V> matchingNot(String var1, String var2);

        public void add();
    }
}

