/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.reflection;

import com.blazebit.lang.ValueAccessor;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class PropertyPathExpression<X, Y>
implements ValueAccessor<X, Y> {
    private final Class<X> source;
    private String[] explodedPropertyPath;
    private Method[] getterChain;
    private Method leafGetter;
    private Method leafSetter;
    private volatile boolean dirty = true;

    public PropertyPathExpression(Class<X> source, String propertyPath) {
        this(source, propertyPath.split("\\."));
    }

    private PropertyPathExpression(Class<X> source, String[] explodedPropertyPath) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        this.source = source;
        this.explodedPropertyPath = explodedPropertyPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.dirty) {
            PropertyPathExpression propertyPathExpression = this;
            synchronized (propertyPathExpression) {
                if (this.dirty) {
                    String[] properties = this.explodedPropertyPath;
                    int getterChainLength = properties.length - 1;
                    ArrayList<Method> getters = new ArrayList<Method>(getterChainLength);
                    Class<Object> current = this.source;
                    if (getterChainLength > 0) {
                        for (int i = 0; i < getterChainLength; ++i) {
                            Method getter = ReflectionUtils.getGetter(current, properties[i]);
                            getters.add(getter);
                            current = ReflectionUtils.getResolvedMethodReturnType(current, getter);
                            if (current == null) break;
                        }
                    }
                    this.getterChain = getters.toArray(new Method[0]);
                    if (current != null) {
                        this.leafGetter = ReflectionUtils.getGetter(current, properties[getterChainLength]);
                        this.leafSetter = ReflectionUtils.getSetter(current, properties[getterChainLength]);
                    }
                    this.dirty = false;
                }
            }
        }
    }

    @Override
    public final Y getValue(X target) {
        return this.getValue(target, false);
    }

    public final Y getNullSafeValue(X target) {
        return this.getValue(target, true);
    }

    private Y getValue(X target, boolean nullSafe) {
        this.initialize();
        try {
            Object leafObj = this.getLeafObject(target, nullSafe);
            Method getter = this.leafGetter == null && leafObj != null ? ReflectionUtils.getGetter(leafObj.getClass(), this.explodedPropertyPath[this.explodedPropertyPath.length - 1]) : this.leafGetter;
            return (Y)(nullSafe && leafObj == null ? null : getter.invoke(leafObj, new Object[0]));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final void setValue(X target, Y value) {
        this.initialize();
        try {
            Object leafObj = this.getLeafObject(target, false);
            Method setter = this.leafSetter == null && leafObj != null ? ReflectionUtils.getSetter(leafObj.getClass(), this.explodedPropertyPath[this.explodedPropertyPath.length - 1]) : this.leafSetter;
            setter.invoke(leafObj, value);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Object getLeafObject(X target, boolean nullSafe) throws IllegalAccessException, InvocationTargetException {
        int i;
        if (nullSafe && target == null) {
            return null;
        }
        if (target != null && !this.source.isInstance(target)) {
            throw new IllegalArgumentException("Given target is not instance of the source class");
        }
        Object current = target;
        Method[] getters = this.getterChain;
        if (getters.length > 0) {
            for (i = 0; i < getters.length; ++i) {
                if ((current = getters[i].invoke(current, new Object[0])) != null) continue;
                if (nullSafe) {
                    return null;
                }
                throw new NullPointerException(getters[i].getName() + " returned null");
            }
        }
        String[] properties = this.explodedPropertyPath;
        while (i < properties.length - 1) {
            if ((current = ReflectionUtils.getGetter(current.getClass(), properties[i]).invoke(current, new Object[0])) == null) {
                if (nullSafe) {
                    return null;
                }
                throw new NullPointerException(properties[i] + " returned null");
            }
            ++i;
        }
        return current;
    }
}

