/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.exception;

import java.lang.reflect.InvocationTargetException;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static void doThrow(Throwable e) {
        ExceptionUtils.doThrow0(e);
    }

    private static <T extends Throwable> void doThrow0(Throwable e) throws T {
        throw e;
    }

    @SafeVarargs
    public static Throwable unwrap(Throwable t, Class<? extends Throwable> ... throwableClasses) {
        Throwable unwrapped = t;
        while (unwrapped != null && ExceptionUtils.isInstance(unwrapped, throwableClasses)) {
            if (unwrapped.getCause() == null && unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            unwrapped = unwrapped.getCause();
        }
        return unwrapped;
    }

    public static Throwable unwrap(Throwable t, Class<? extends Throwable> throwableClass) {
        Throwable unwrapped = t;
        while (unwrapped != null && throwableClass.isInstance(unwrapped)) {
            if (unwrapped.getCause() == null && unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            unwrapped = unwrapped.getCause();
        }
        return unwrapped;
    }

    private static boolean isInstance(Throwable t, Class<? extends Throwable> ... throwableClasses) {
        for (int i = 0; i < throwableClasses.length; ++i) {
            if (!throwableClasses[i].isInstance(t)) continue;
            return true;
        }
        return false;
    }

    private static boolean equals(Class<? extends Throwable> t, Class<? extends Throwable> ... throwableClasses) {
        for (int i = 0; i < throwableClasses.length; ++i) {
            if (!throwableClasses[i].equals(t)) continue;
            return true;
        }
        return false;
    }

    public static Throwable getCause(Throwable e, Class<? extends Throwable> ... causes) {
        if (e == null || causes == null || causes.length < 1) {
            return null;
        }
        if (ExceptionUtils.isInstance(e, causes)) {
            if (e.getCause() == null || e.getCause().equals(e) || !ExceptionUtils.equals(e.getClass(), causes)) {
                return e;
            }
            return ExceptionUtils.getCause(e.getCause(), causes);
        }
        if (e.getCause() == null && e instanceof InvocationTargetException) {
            return ExceptionUtils.getCause(((InvocationTargetException)e).getTargetException(), causes);
        }
        if (e.getCause() == null) {
            return null;
        }
        return ExceptionUtils.getCause(e.getCause(), causes);
    }
}

