/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.i18n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

public final class LocaleUtils {
    private LocaleUtils() {
    }

    public static Locale getLocale(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        int found = 0;
        int position = 0;
        char[] chars = string.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '_') continue;
            switch (found) {
                case 0: {
                    string = new String(chars, position, i - position);
                    position = i + 1;
                    break;
                }
                case 1: {
                    if (chars.length > i + 1) {
                        return new Locale(string, new String(chars, position, i - position), new String(chars, i + 1, chars.length - i - 1));
                    }
                    return new Locale(string, new String(chars, position, i - position), "");
                }
            }
            ++found;
        }
        switch (found) {
            case 0: {
                return new Locale(string);
            }
            case 1: {
                return new Locale(string, new String(chars, position, chars.length - position));
            }
        }
        return null;
    }

    public static Locale resolveLocale(Iterable<Locale> preferredLocales, Collection<Locale> supportedLocales, Locale defaultLocale) {
        return LocaleUtils.resolveLocale(preferredLocales.iterator(), supportedLocales, defaultLocale);
    }

    public static Locale resolveLocale(Iterable<Locale> preferredLocales, Collection<Locale> supportedLocales, Locale defaultLocale, boolean strictVarianMatching) {
        return LocaleUtils.resolveLocale(preferredLocales.iterator(), supportedLocales, defaultLocale, strictVarianMatching);
    }

    public static Locale resolveLocale(Iterator<Locale> preferredLocales, Collection<Locale> supportedLocales, Locale defaultLocale) {
        return LocaleUtils.resolveLocale(preferredLocales, supportedLocales, defaultLocale, true);
    }

    public static Locale resolveLocale(Iterator<Locale> preferredLocales, Collection<Locale> supportedLocales, Locale defaultLocale, boolean strictVarianMatching) {
        return LocaleUtils.resolveLocale(preferredLocales, supportedLocales, defaultLocale, true, strictVarianMatching);
    }

    public static Locale resolveLocale(Iterator<Locale> preferredLocales, Collection<Locale> supportedLocales, Locale defaultLocale, boolean countryMatching, boolean strictVariantMatching) {
        if (supportedLocales == null || supportedLocales.isEmpty()) {
            return defaultLocale;
        }
        if (preferredLocales == null || !preferredLocales.hasNext()) {
            return defaultLocale;
        }
        ArrayList<Locale> countryMatchingLocales = new ArrayList<Locale>();
        do {
            Locale preferredLocale;
            if (supportedLocales.contains(preferredLocale = preferredLocales.next()) || defaultLocale != null && defaultLocale.equals(preferredLocale)) {
                return preferredLocale;
            }
            String preferredLocaleLanguage = preferredLocale.getLanguage();
            String preferredLocaleCountry = preferredLocale.getCountry();
            if (LocaleUtils.empty(preferredLocaleLanguage)) continue;
            Locale lastLanguageMatch = null;
            Locale lastLanguageAndCountryMatch = null;
            boolean languageMatching = false;
            for (Locale supportedLocale : supportedLocales) {
                if (supportedLocale == null) continue;
                if (LocaleUtils.equal(preferredLocaleLanguage, supportedLocale.getLanguage())) {
                    languageMatching = true;
                    if (LocaleUtils.equal(supportedLocale.getCountry(), preferredLocaleCountry)) {
                        if (lastLanguageAndCountryMatch == null && (!strictVariantMatching || LocaleUtils.empty(supportedLocale.getVariant()))) {
                            lastLanguageAndCountryMatch = supportedLocale;
                            continue;
                        }
                        if (lastLanguageAndCountryMatch == null || !LocaleUtils.empty(supportedLocale.getVariant())) continue;
                        lastLanguageAndCountryMatch = supportedLocale;
                        continue;
                    }
                    if (lastLanguageMatch != null && !LocaleUtils.empty(supportedLocale.getCountry())) continue;
                    lastLanguageMatch = supportedLocale;
                    continue;
                }
                if (!countryMatching || languageMatching || !LocaleUtils.equal(preferredLocaleCountry, supportedLocale.getCountry())) continue;
                countryMatchingLocales.add(supportedLocale);
            }
            if (lastLanguageAndCountryMatch == null && lastLanguageMatch == null) continue;
            return lastLanguageAndCountryMatch != null ? lastLanguageAndCountryMatch : lastLanguageMatch;
        } while (preferredLocales.hasNext());
        if (countryMatching && !countryMatchingLocales.isEmpty()) {
            return (Locale)countryMatchingLocales.get(0);
        }
        return defaultLocale;
    }

    private static boolean empty(String s) {
        return s == null || s.isEmpty();
    }

    private static boolean equal(String s1, String s2) {
        return s1 != null && s1.equalsIgnoreCase(s2);
    }
}

