/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.text;

import com.blazebit.text.AbstractFormat;
import com.blazebit.text.ParserContext;
import java.io.Serializable;
import java.lang.reflect.Method;

public class AbstractDateTimeFormatterFormat
extends AbstractFormat {
    private static final long serialVersionUID = 1L;
    private static final Class<?> DATE_TIME_FORMATTER_CLASS;
    private static final Method FORMAT_METHOD;
    private static final Method PARSE_METHOD;
    private final String contextFormatterName;
    private final Object formatter;
    private final Method factory;

    public AbstractDateTimeFormatterFormat(Class<?> valueClass, String contextFormatterName, String formatterFieldName) {
        super(valueClass);
        this.contextFormatterName = contextFormatterName;
        try {
            this.formatter = DATE_TIME_FORMATTER_CLASS.getField(formatterFieldName).get(null);
            this.factory = valueClass.getMethod("from", Class.forName("java.time.temporal.TemporalAccessor"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Serializable parse(String value, ParserContext context) {
        Object o = null;
        if (context != null && (o = context.getAttribute(this.contextFormatterName)) != null && !DATE_TIME_FORMATTER_CLASS.isInstance(o)) {
            throw new IllegalArgumentException("Illegal formatter object in context");
        }
        if (o == null) {
            o = this.formatter;
        }
        try {
            return (Serializable)this.factory.invoke(null, PARSE_METHOD.invoke(o, value));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public String format(Serializable value, ParserContext context) {
        Object o = null;
        if (context != null && (o = context.getAttribute(this.contextFormatterName)) != null && !DATE_TIME_FORMATTER_CLASS.isInstance(o)) {
            throw new IllegalArgumentException("Illegal formatter object in context");
        }
        if (o == null) {
            o = this.formatter;
        }
        try {
            return (String)FORMAT_METHOD.invoke(o, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static {
        try {
            DATE_TIME_FORMATTER_CLASS = Class.forName("java.time.format.DateTimeFormatter");
            FORMAT_METHOD = DATE_TIME_FORMATTER_CLASS.getMethod("format", Class.forName("java.time.temporal.TemporalAccessor"));
            PARSE_METHOD = DATE_TIME_FORMATTER_CLASS.getMethod("parse", CharSequence.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

