/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.domain;

import com.blazebit.domain.spi.DomainBuilderProvider;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class Domain {
    private static volatile DomainBuilderProvider cachedDefaultProvider;

    private Domain() {
    }

    public static DomainBuilderProvider getDefaultProvider() {
        DomainBuilderProvider defaultProvider = cachedDefaultProvider;
        if (defaultProvider == null) {
            ServiceLoader<DomainBuilderProvider> serviceLoader = ServiceLoader.load(DomainBuilderProvider.class);
            Iterator<DomainBuilderProvider> iterator = serviceLoader.iterator();
            if (iterator.hasNext()) {
                cachedDefaultProvider = iterator.next();
                return cachedDefaultProvider;
            }
            throw new IllegalStateException("No DomainBuilderProvider found on the class path. Please check if a valid implementation is on the class path.");
        }
        return defaultProvider;
    }
}

