/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.domain.runtime.model;

import com.blazebit.domain.runtime.model.ArrayCacheKey;
import com.blazebit.domain.runtime.model.CollectionDomainType;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.domain.runtime.model.DomainFunctionArgument;
import com.blazebit.domain.runtime.model.DomainFunctionTypeResolver;
import com.blazebit.domain.runtime.model.DomainModel;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.domain.runtime.model.DomainTypeResolverException;
import com.blazebit.domain.runtime.model.UnionDomainType;
import com.blazebit.domain.spi.DomainSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class StaticDomainFunctionTypeResolvers {
    public static final DomainFunctionTypeResolver FIRST_ARGUMENT_TYPE = new FirstArgumentDomainFunctionTypeResolver();
    public static final DomainFunctionTypeResolver SECOND_ARGUMENT_TYPE = new SecondArgumentDomainFunctionTypeResolver();
    public static final DomainFunctionTypeResolver THIRD_ARGUMENT_TYPE = new ThirdArgumentDomainFunctionTypeResolver();
    public static final DomainFunctionTypeResolver FOURTH_ARGUMENT_TYPE = new FourthArgumentDomainFunctionTypeResolver();
    public static final DomainFunctionTypeResolver STATIC_RETURN_TYPE = new StaticDomainFunctionTypeResolver();
    private static final Map<String, DomainFunctionTypeResolver> RETURNING_TYPE_NAME_CACHE = new ConcurrentHashMap<String, DomainFunctionTypeResolver>();
    private static final Map<ArrayCacheKey<String>, DomainFunctionTypeResolver> WIDEST_TYPE_NAME_CACHE = new ConcurrentHashMap<ArrayCacheKey<String>, DomainFunctionTypeResolver>();

    private StaticDomainFunctionTypeResolvers() {
    }

    public static DomainFunctionTypeResolver returning(String typeName) {
        DomainFunctionTypeResolver domainFunctionTypeResolver = RETURNING_TYPE_NAME_CACHE.get(typeName);
        if (domainFunctionTypeResolver == null) {
            domainFunctionTypeResolver = new ReturningTypeDomainFunctionTypeResolver(typeName);
            RETURNING_TYPE_NAME_CACHE.put(typeName, domainFunctionTypeResolver);
        }
        return domainFunctionTypeResolver;
    }

    public static DomainFunctionTypeResolver widest(String ... typeNames) {
        ArrayCacheKey<String> key = new ArrayCacheKey<String>(typeNames);
        DomainFunctionTypeResolver domainFunctionTypeResolver = WIDEST_TYPE_NAME_CACHE.get(key);
        if (domainFunctionTypeResolver == null) {
            domainFunctionTypeResolver = new WidestDomainFunctionTypeResolver(typeNames);
            WIDEST_TYPE_NAME_CACHE.put(key, domainFunctionTypeResolver);
        }
        return domainFunctionTypeResolver;
    }

    public static DomainFunctionTypeResolver nthArgument(int index) {
        return new NthArgumentDomainFunctionTypeResolver(index);
    }

    private static void validateArgumentTypes(Map<DomainFunctionArgument, DomainType> argumentTypes) {
        block0: for (Map.Entry<DomainFunctionArgument, DomainType> entry : argumentTypes.entrySet()) {
            DomainFunctionArgument functionArgument = entry.getKey();
            DomainType argumentType = functionArgument.getType();
            if (argumentType == null || entry.getValue() == null || argumentType instanceof CollectionDomainType && entry.getValue() instanceof CollectionDomainType && (((CollectionDomainType)argumentType).getElementType() == null || ((CollectionDomainType)entry.getValue()).getElementType() == null)) continue;
            if (argumentType instanceof UnionDomainType) {
                if (entry.getValue() instanceof CollectionDomainType) {
                    for (DomainType unionElement : ((UnionDomainType)argumentType).getUnionElements()) {
                        if (unionElement != entry.getValue() && (!(unionElement instanceof CollectionDomainType) || ((CollectionDomainType)unionElement).getElementType() != null)) continue;
                        continue block0;
                    }
                } else {
                    for (DomainType unionElement : ((UnionDomainType)argumentType).getUnionElements()) {
                        if (unionElement != entry.getValue()) continue;
                        continue block0;
                    }
                }
            }
            if (argumentType == entry.getValue()) continue;
            throw new DomainTypeResolverException("Unsupported argument type '" + entry.getValue() + "' for argument '" + functionArgument + "' of function '" + functionArgument.getOwner().getName() + "'! Expected type: " + argumentType);
        }
    }

    private static class StaticDomainFunctionTypeResolver
    implements DomainFunctionTypeResolver,
    Serializable {
        private StaticDomainFunctionTypeResolver() {
        }

        @Override
        public DomainType resolveType(DomainModel domainModel, DomainFunction function, Map<DomainFunctionArgument, DomainType> argumentTypes) {
            StaticDomainFunctionTypeResolvers.validateArgumentTypes(argumentTypes);
            return function.getResultType();
        }
    }

    public static class NthArgumentDomainFunctionTypeResolver
    implements DomainFunctionTypeResolver,
    DomainSerializer<DomainFunctionTypeResolver>,
    Serializable {
        private final int index;

        public NthArgumentDomainFunctionTypeResolver(int index) {
            this.index = index;
        }

        @Override
        public DomainType resolveType(DomainModel domainModel, DomainFunction function, Map<DomainFunctionArgument, DomainType> argumentTypes) {
            StaticDomainFunctionTypeResolvers.validateArgumentTypes(argumentTypes);
            for (DomainFunctionArgument domainFunctionArgument : function.getArguments()) {
                DomainType domainType = argumentTypes.get(domainFunctionArgument);
                if (domainType == null) continue;
                return domainType;
            }
            return null;
        }

        @Override
        public <T> T serialize(DomainModel domainModel, DomainFunctionTypeResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            return (T)("{\"NthArgumentDomainFunctionTypeResolver\":[" + this.index + "]}");
        }
    }

    public static class FourthArgumentDomainFunctionTypeResolver
    extends NthArgumentDomainFunctionTypeResolver {
        public FourthArgumentDomainFunctionTypeResolver() {
            super(3);
        }
    }

    public static class ThirdArgumentDomainFunctionTypeResolver
    extends NthArgumentDomainFunctionTypeResolver {
        public ThirdArgumentDomainFunctionTypeResolver() {
            super(2);
        }
    }

    public static class SecondArgumentDomainFunctionTypeResolver
    extends NthArgumentDomainFunctionTypeResolver {
        public SecondArgumentDomainFunctionTypeResolver() {
            super(1);
        }
    }

    public static class FirstArgumentDomainFunctionTypeResolver
    extends NthArgumentDomainFunctionTypeResolver {
        public FirstArgumentDomainFunctionTypeResolver() {
            super(0);
        }
    }

    private static class ReturningTypeDomainFunctionTypeResolver
    implements DomainFunctionTypeResolver,
    DomainSerializer<DomainFunctionTypeResolver>,
    Serializable {
        private final String typeName;

        public ReturningTypeDomainFunctionTypeResolver(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public DomainType resolveType(DomainModel domainModel, DomainFunction function, Map<DomainFunctionArgument, DomainType> argumentTypes) {
            StaticDomainFunctionTypeResolvers.validateArgumentTypes(argumentTypes);
            return domainModel.getType(this.typeName);
        }

        @Override
        public <T> T serialize(DomainModel domainModel, DomainFunctionTypeResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            return (T)("{\"FixedDomainFunctionTypeResolver\":[\"" + this.typeName + "\"]}");
        }
    }

    private static class WidestDomainFunctionTypeResolver
    implements DomainFunctionTypeResolver,
    DomainSerializer<DomainFunctionTypeResolver>,
    Serializable {
        private final String[] typeNames;

        public WidestDomainFunctionTypeResolver(String ... typeNames) {
            this.typeNames = typeNames;
        }

        @Override
        public DomainType resolveType(DomainModel domainModel, DomainFunction function, Map<DomainFunctionArgument, DomainType> argumentTypes) {
            int typeIndex = this.typeNames.length;
            DomainType domainType = null;
            for (Map.Entry<DomainFunctionArgument, DomainType> entry : argumentTypes.entrySet()) {
                DomainType type = entry.getValue();
                String typeName = type.getName();
                for (int i = 0; i < typeIndex; ++i) {
                    if (!typeName.equals(this.typeNames[i])) continue;
                    typeIndex = i;
                    domainType = type;
                    break;
                }
                if (typeIndex == 0) break;
                if (typeIndex != this.typeNames.length) continue;
                ArrayList<DomainType> preferredTypes = new ArrayList<DomainType>(this.typeNames.length);
                for (String name : this.typeNames) {
                    preferredTypes.add(domainModel.getType(name));
                }
                throw new DomainTypeResolverException("Unsupported argument type '" + type + "' for argument '" + entry.getKey() + "' of function '" + function.getName() + "'! Expected one of the following types: " + preferredTypes);
            }
            if (typeIndex == Integer.MAX_VALUE) {
                return domainModel.getType(this.typeNames[0]);
            }
            return domainType;
        }

        @Override
        public <T> T serialize(DomainModel domainModel, DomainFunctionTypeResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{\"WidestDomainFunctionTypeResolver\":[[");
            for (String typeName : this.typeNames) {
                sb.append('\"').append(typeName).append("\",");
            }
            sb.setCharAt(sb.length() - 1, ']');
            sb.append(']').append('}');
            return (T)sb.toString();
        }
    }
}

