/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.domain.runtime.model;

import com.blazebit.domain.runtime.model.ArrayCacheKey;
import com.blazebit.domain.runtime.model.DomainModel;
import com.blazebit.domain.runtime.model.DomainOperationTypeResolver;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.domain.runtime.model.DomainTypeResolverException;
import com.blazebit.domain.runtime.model.OperandRestrictedCacheKey;
import com.blazebit.domain.runtime.model.RestrictedCacheKey;
import com.blazebit.domain.spi.DomainSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class StaticDomainOperationTypeResolvers {
    private static final Map<String, DomainOperationTypeResolver> RETURNING_TYPE_NAME_CACHE = new ConcurrentHashMap<String, DomainOperationTypeResolver>();
    private static final Map<ArrayCacheKey<String>, DomainOperationTypeResolver> WIDEST_TYPE_NAME_CACHE = new ConcurrentHashMap<ArrayCacheKey<String>, DomainOperationTypeResolver>();
    private static final Map<RestrictedCacheKey<String>, DomainOperationTypeResolver> RESTRICTED_TYPE_NAME_CACHE = new ConcurrentHashMap<RestrictedCacheKey<String>, DomainOperationTypeResolver>();
    private static final Map<OperandRestrictedCacheKey<String>, DomainOperationTypeResolver> OPERAND_RESTRICTED_TYPE_NAME_CACHE = new ConcurrentHashMap<OperandRestrictedCacheKey<String>, DomainOperationTypeResolver>();

    private StaticDomainOperationTypeResolvers() {
    }

    public static DomainOperationTypeResolver returning(String typeName) {
        DomainOperationTypeResolver domainOperationTypeResolver = RETURNING_TYPE_NAME_CACHE.get(typeName);
        if (domainOperationTypeResolver == null) {
            domainOperationTypeResolver = new ReturningTypeDomainOperationTypeResolver(typeName);
            RETURNING_TYPE_NAME_CACHE.put(typeName, domainOperationTypeResolver);
        }
        return domainOperationTypeResolver;
    }

    public static DomainOperationTypeResolver returning(String returningTypeName, String ... supportedTypeNames) {
        RestrictedCacheKey<String> key = new RestrictedCacheKey<String>(returningTypeName, supportedTypeNames);
        DomainOperationTypeResolver domainOperationTypeResolver = RESTRICTED_TYPE_NAME_CACHE.get(key);
        if (domainOperationTypeResolver == null) {
            domainOperationTypeResolver = new RestrictedTypeDomainOperationTypeResolver(returningTypeName, supportedTypeNames);
            RESTRICTED_TYPE_NAME_CACHE.put(key, domainOperationTypeResolver);
        }
        return domainOperationTypeResolver;
    }

    public static DomainOperationTypeResolver returning(String returningTypeName, String[][] supportedTypeNamesPerOperand) {
        OperandRestrictedCacheKey<String> key = new OperandRestrictedCacheKey<String>(returningTypeName, supportedTypeNamesPerOperand);
        DomainOperationTypeResolver domainOperationTypeResolver = OPERAND_RESTRICTED_TYPE_NAME_CACHE.get(key);
        if (domainOperationTypeResolver == null) {
            domainOperationTypeResolver = new OperandRestrictedTypeDomainOperationTypeResolver(returningTypeName, supportedTypeNamesPerOperand);
            OPERAND_RESTRICTED_TYPE_NAME_CACHE.put(key, domainOperationTypeResolver);
        }
        return domainOperationTypeResolver;
    }

    public static DomainOperationTypeResolver widest(String ... typeNames) {
        ArrayCacheKey<String> key = new ArrayCacheKey<String>(typeNames);
        DomainOperationTypeResolver domainOperationTypeResolver = WIDEST_TYPE_NAME_CACHE.get(key);
        if (domainOperationTypeResolver == null) {
            domainOperationTypeResolver = new WidestTypeDomainOperationTypeResolver(typeNames);
            WIDEST_TYPE_NAME_CACHE.put(key, domainOperationTypeResolver);
        }
        return domainOperationTypeResolver;
    }

    private static class ReturningTypeDomainOperationTypeResolver
    implements DomainOperationTypeResolver,
    DomainSerializer<DomainOperationTypeResolver>,
    Serializable {
        private final String typeName;

        public ReturningTypeDomainOperationTypeResolver(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public DomainType resolveType(DomainModel domainModel, List<DomainType> domainTypes) {
            return domainModel.getType(this.typeName);
        }

        @Override
        public <T> T serialize(DomainModel domainModel, DomainOperationTypeResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            return (T)("{\"FixedDomainOperationTypeResolver\":[\"" + this.typeName + "\"]}");
        }
    }

    private static class WidestTypeDomainOperationTypeResolver
    implements DomainOperationTypeResolver,
    DomainSerializer<DomainOperationTypeResolver>,
    Serializable {
        private final String[] typeNames;

        public WidestTypeDomainOperationTypeResolver(String ... typeNames) {
            this.typeNames = typeNames;
        }

        @Override
        public DomainType resolveType(DomainModel domainModel, List<DomainType> domainTypes) {
            ArrayList<DomainType> preferredTypes = new ArrayList<DomainType>(this.typeNames.length);
            for (String typeName : this.typeNames) {
                preferredTypes.add(domainModel.getType(typeName));
            }
            int typeIndex = Integer.MAX_VALUE;
            for (int i = 0; i < domainTypes.size(); ++i) {
                DomainType domainType = domainTypes.get(i);
                int idx = preferredTypes.indexOf(domainType);
                if (idx == -1) {
                    throw new DomainTypeResolverException("The operation operand at index " + i + " with the domain type '" + domainType + "' is unsupported! Expected one of the following types: " + preferredTypes);
                }
                typeIndex = Math.min(typeIndex, idx);
            }
            if (typeIndex == Integer.MAX_VALUE) {
                return (DomainType)preferredTypes.get(0);
            }
            return (DomainType)preferredTypes.get(typeIndex);
        }

        @Override
        public <T> T serialize(DomainModel domainModel, DomainOperationTypeResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{\"WidestDomainOperationTypeResolver\":[[");
            for (String typeName : this.typeNames) {
                sb.append('\"').append(typeName).append("\",");
            }
            sb.setCharAt(sb.length() - 1, ']');
            sb.append(']').append('}');
            return (T)sb.toString();
        }
    }

    private static class OperandRestrictedTypeDomainOperationTypeResolver
    implements DomainOperationTypeResolver,
    DomainSerializer<DomainOperationTypeResolver>,
    Serializable {
        private final String returningTypeName;
        private final Set<String>[] supportedTypeNamesPerOperand;

        public OperandRestrictedTypeDomainOperationTypeResolver(String returningTypeName, String[][] supportedTypeNamesPerOperand) {
            this.returningTypeName = returningTypeName;
            Set[] perOperand = new Set[supportedTypeNamesPerOperand.length];
            for (int i = 0; i < supportedTypeNamesPerOperand.length; ++i) {
                perOperand[i] = new HashSet<String>(Arrays.asList(supportedTypeNamesPerOperand[i]));
            }
            this.supportedTypeNamesPerOperand = perOperand;
        }

        @Override
        public DomainType resolveType(DomainModel domainModel, List<DomainType> domainTypes) {
            for (int i = 0; i < domainTypes.size(); ++i) {
                Set<String> supportedTypeNames = this.supportedTypeNamesPerOperand[i];
                DomainType domainType = domainTypes.get(i);
                if (supportedTypeNames.contains(domainType.getName())) continue;
                ArrayList<DomainType> types = new ArrayList<DomainType>(supportedTypeNames.size());
                for (String typeName : supportedTypeNames) {
                    types.add(domainModel.getType(typeName));
                }
                throw new DomainTypeResolverException("The operation operand at index " + i + " with the domain type '" + domainType + "' is unsupported! Expected one of the following: " + types);
            }
            return domainModel.getType(this.returningTypeName);
        }

        @Override
        public <T> T serialize(DomainModel domainModel, DomainOperationTypeResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{\"OperandRestrictedDomainOperationTypeResolver\":[");
            sb.append('\"').append(this.returningTypeName).append("\",[");
            for (Set<String> typeNames : this.supportedTypeNamesPerOperand) {
                sb.append('[');
                for (String typeName : typeNames) {
                    sb.append('\"').append(typeName).append("\",");
                }
                sb.setCharAt(sb.length() - 1, ']');
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, ']');
            sb.append(']').append('}');
            return (T)sb.toString();
        }
    }

    private static class RestrictedTypeDomainOperationTypeResolver
    implements DomainOperationTypeResolver,
    DomainSerializer<DomainOperationTypeResolver>,
    Serializable {
        private final String returningTypeName;
        private final Set<String> supportedTypeNames;

        public RestrictedTypeDomainOperationTypeResolver(String returningTypeName, String ... supportedTypeNames) {
            this.returningTypeName = returningTypeName;
            this.supportedTypeNames = new HashSet<String>(Arrays.asList(supportedTypeNames));
        }

        @Override
        public DomainType resolveType(DomainModel domainModel, List<DomainType> domainTypes) {
            for (int i = 0; i < domainTypes.size(); ++i) {
                DomainType domainType = domainTypes.get(i);
                if (this.supportedTypeNames.contains(domainType.getName())) continue;
                ArrayList<DomainType> types = new ArrayList<DomainType>(this.supportedTypeNames.size());
                for (String typeName : this.supportedTypeNames) {
                    types.add(domainModel.getType(typeName));
                }
                throw new DomainTypeResolverException("The operation operand at index " + i + " with the domain type '" + domainType + "' is unsupported! Expected one of the following: " + types);
            }
            return domainModel.getType(this.returningTypeName);
        }

        @Override
        public <T> T serialize(DomainModel domainModel, DomainOperationTypeResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{\"RestrictedDomainOperationTypeResolver\":[");
            sb.append('\"').append(this.returningTypeName).append("\",[");
            for (String typeName : this.supportedTypeNames) {
                sb.append('\"').append(typeName).append("\",");
            }
            sb.setCharAt(sb.length() - 1, ']');
            sb.append(']').append('}');
            return (T)sb.toString();
        }
    }
}

