/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.domain.runtime.model;

import com.blazebit.domain.runtime.model.DomainModel;
import com.blazebit.domain.runtime.model.DomainPredicateTypeResolver;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.domain.runtime.model.DomainTypeResolverException;
import com.blazebit.domain.runtime.model.OperandRestrictedCacheKey;
import com.blazebit.domain.runtime.model.RestrictedCacheKey;
import com.blazebit.domain.spi.DomainSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class StaticDomainPredicateTypeResolvers {
    private static final Map<String, DomainPredicateTypeResolver> RETURNING_TYPE_NAME_CACHE = new ConcurrentHashMap<String, DomainPredicateTypeResolver>();
    private static final Map<RestrictedCacheKey<String>, DomainPredicateTypeResolver> RESTRICTED_TYPE_NAME_CACHE = new ConcurrentHashMap<RestrictedCacheKey<String>, DomainPredicateTypeResolver>();
    private static final Map<OperandRestrictedCacheKey<String>, DomainPredicateTypeResolver> OPERAND_RESTRICTED_TYPE_NAME_CACHE = new ConcurrentHashMap<OperandRestrictedCacheKey<String>, DomainPredicateTypeResolver>();

    private StaticDomainPredicateTypeResolvers() {
    }

    public static DomainPredicateTypeResolver returning(String typeName) {
        DomainPredicateTypeResolver domainOperationTypeResolver = RETURNING_TYPE_NAME_CACHE.get(typeName);
        if (domainOperationTypeResolver == null) {
            domainOperationTypeResolver = new ReturningTypeDomainPredicateTypeResolver(typeName);
            RETURNING_TYPE_NAME_CACHE.put(typeName, domainOperationTypeResolver);
        }
        return domainOperationTypeResolver;
    }

    public static DomainPredicateTypeResolver returning(String returningTypeName, String ... supportedTypeNames) {
        RestrictedCacheKey<String> key = new RestrictedCacheKey<String>(returningTypeName, supportedTypeNames);
        DomainPredicateTypeResolver domainPredicateTypeResolver = RESTRICTED_TYPE_NAME_CACHE.get(key);
        if (domainPredicateTypeResolver == null) {
            domainPredicateTypeResolver = new RestrictedTypeDomainPredicateTypeResolver(returningTypeName, supportedTypeNames);
            RESTRICTED_TYPE_NAME_CACHE.put(key, domainPredicateTypeResolver);
        }
        return domainPredicateTypeResolver;
    }

    public static DomainPredicateTypeResolver returning(String returningTypeName, String[][] supportedTypeNamesPerOperand) {
        OperandRestrictedCacheKey<String> key = new OperandRestrictedCacheKey<String>(returningTypeName, supportedTypeNamesPerOperand);
        DomainPredicateTypeResolver domainPredicateTypeResolver = OPERAND_RESTRICTED_TYPE_NAME_CACHE.get(key);
        if (domainPredicateTypeResolver == null) {
            domainPredicateTypeResolver = new OperandRestrictedTypeDomainPredicateTypeResolver(returningTypeName, supportedTypeNamesPerOperand);
            OPERAND_RESTRICTED_TYPE_NAME_CACHE.put(key, domainPredicateTypeResolver);
        }
        return domainPredicateTypeResolver;
    }

    private static class ReturningTypeDomainPredicateTypeResolver
    implements DomainPredicateTypeResolver,
    DomainSerializer<DomainPredicateTypeResolver>,
    Serializable {
        private final String typeName;

        public ReturningTypeDomainPredicateTypeResolver(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public DomainType resolveType(DomainModel domainModel, List<DomainType> domainTypes) {
            return domainModel.getType(this.typeName);
        }

        @Override
        public <T> T serialize(DomainModel domainModel, DomainPredicateTypeResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            return (T)("{\"FixedDomainPredicateTypeResolver\":[\"" + this.typeName + "\"]}");
        }
    }

    private static class OperandRestrictedTypeDomainPredicateTypeResolver
    implements DomainPredicateTypeResolver,
    DomainSerializer<DomainPredicateTypeResolver>,
    Serializable {
        private final String returningTypeName;
        private final Set<String>[] supportedTypeNamesPerOperand;

        public OperandRestrictedTypeDomainPredicateTypeResolver(String returningTypeName, String[][] supportedTypeNamesPerOperand) {
            this.returningTypeName = returningTypeName;
            Set[] perOperand = new Set[supportedTypeNamesPerOperand.length];
            for (int i = 0; i < supportedTypeNamesPerOperand.length; ++i) {
                perOperand[i] = new HashSet<String>(Arrays.asList(supportedTypeNamesPerOperand[i]));
            }
            this.supportedTypeNamesPerOperand = perOperand;
        }

        @Override
        public DomainType resolveType(DomainModel domainModel, List<DomainType> domainTypes) {
            for (int i = 0; i < domainTypes.size(); ++i) {
                Set<String> supportedTypeNames = this.supportedTypeNamesPerOperand[i];
                DomainType domainType = domainTypes.get(i);
                if (supportedTypeNames.contains(domainType.getName())) continue;
                ArrayList<DomainType> types = new ArrayList<DomainType>(supportedTypeNames.size());
                for (String typeName : supportedTypeNames) {
                    types.add(domainModel.getType(typeName));
                }
                throw new DomainTypeResolverException("The predicate operand at index " + i + " with the domain type '" + domainType + "' is unsupported! Expected one of the following types: " + types);
            }
            return domainModel.getType(this.returningTypeName);
        }

        @Override
        public <T> T serialize(DomainModel domainModel, DomainPredicateTypeResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{\"OperandRestrictedDomainPredicateTypeResolver\":[");
            sb.append('\"').append(this.returningTypeName).append("\",[");
            for (Set<String> supportedTypeNames : this.supportedTypeNamesPerOperand) {
                sb.append('[');
                for (String typeName : supportedTypeNames) {
                    sb.append('\"').append(typeName).append("\",");
                }
                sb.setCharAt(sb.length() - 1, ']');
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, ']');
            sb.append(']').append('}');
            return (T)sb.toString();
        }
    }

    private static class RestrictedTypeDomainPredicateTypeResolver
    implements DomainPredicateTypeResolver,
    DomainSerializer<DomainPredicateTypeResolver>,
    Serializable {
        private final String returningTypeName;
        private final Set<String> supportedTypeNames;

        public RestrictedTypeDomainPredicateTypeResolver(String returningTypeName, String ... supportedTypeNames) {
            this.returningTypeName = returningTypeName;
            this.supportedTypeNames = new HashSet<String>(Arrays.asList(supportedTypeNames));
        }

        @Override
        public DomainType resolveType(DomainModel domainModel, List<DomainType> domainTypes) {
            for (int i = 0; i < domainTypes.size(); ++i) {
                DomainType domainType = domainTypes.get(i);
                if (this.supportedTypeNames.contains(domainType.getName())) continue;
                ArrayList<DomainType> types = new ArrayList<DomainType>(this.supportedTypeNames.size());
                for (String typeName : this.supportedTypeNames) {
                    types.add(domainModel.getType(typeName));
                }
                throw new DomainTypeResolverException("The predicate operand at index " + i + " with the domain type '" + domainType + "' is unsupported! Expected one of the following types: " + types);
            }
            return domainModel.getType(this.returningTypeName);
        }

        @Override
        public <T> T serialize(DomainModel domainModel, DomainPredicateTypeResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            if (targetType != String.class || !"json".equals(format)) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{\"RestrictedDomainPredicateTypeResolver\":[");
            sb.append('\"').append(this.returningTypeName).append("\",[");
            for (String typeName : this.supportedTypeNames) {
                sb.append('\"').append(typeName).append("\",");
            }
            sb.setCharAt(sb.length() - 1, ']');
            sb.append(']').append('}');
            return (T)sb.toString();
        }
    }
}

