/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.domain.runtime.model;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;

public class TemporalInterval
implements Comparable<TemporalInterval> {
    private final int years;
    private final int months;
    private final int days;
    private final int hours;
    private final int minutes;
    private final int seconds;

    public TemporalInterval(int years, int months, int days, int hours, int minutes, int seconds) {
        if (years < 0) {
            throw new IllegalArgumentException("Invalid negative years: " + years);
        }
        if (months < 0) {
            throw new IllegalArgumentException("Invalid negative months: " + months);
        }
        if (days < 0) {
            throw new IllegalArgumentException("Invalid negative days: " + days);
        }
        if (hours < 0) {
            throw new IllegalArgumentException("Invalid negative hours: " + hours);
        }
        if (minutes < 0) {
            throw new IllegalArgumentException("Invalid negative minutes: " + minutes);
        }
        if (seconds < 0) {
            throw new IllegalArgumentException("Invalid negative seconds: " + seconds);
        }
        this.years = years;
        this.months = months;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemporalInterval interval = (TemporalInterval)o;
        return this.years == interval.years && this.months == interval.months && this.days == interval.days && this.hours == interval.hours && this.minutes == interval.minutes && this.seconds == interval.seconds;
    }

    public int hashCode() {
        return Objects.hash(this.years, this.months, this.days, this.hours, this.minutes, this.seconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.years != 0) {
            sb.append(this.years).append(" YEARS ");
        }
        if (this.months != 0) {
            sb.append(this.months).append(" MONTHS ");
        }
        if (this.days != 0) {
            sb.append(this.days).append(" DAYS ");
        }
        if (this.hours != 0) {
            sb.append(this.hours).append(" HOURS ");
        }
        if (this.minutes != 0) {
            sb.append(this.minutes).append(" MINUTES ");
        }
        if (this.seconds != 0) {
            sb.append(this.seconds).append(" SECONDS");
        }
        return sb.toString();
    }

    public TemporalInterval add(TemporalInterval interval2) {
        return new TemporalInterval(this.years + interval2.years, this.months + interval2.months, this.days + interval2.days, this.hours + interval2.hours, this.minutes + interval2.minutes, this.seconds + interval2.seconds);
    }

    public TemporalInterval subtract(TemporalInterval interval2) {
        return new TemporalInterval(this.years - interval2.years, this.months - interval2.months, this.days - interval2.days, this.hours - interval2.hours, this.minutes - interval2.minutes, this.seconds - interval2.seconds);
    }

    public Instant add(Instant instant) {
        return instant.atZone(ZoneOffset.UTC).plusYears(this.years).plusMonths(this.months).plusDays(this.days).plusHours(this.hours).plusMinutes(this.minutes).plusSeconds(this.seconds).toInstant();
    }

    public Instant subtract(Instant instant) {
        return instant.atZone(ZoneOffset.UTC).minusYears(this.years).minusMonths(this.months).minusDays(this.days).minusHours(this.hours).minusMinutes(this.minutes).minusSeconds(this.seconds).toInstant();
    }

    public LocalDate add(LocalDate localDate) {
        if (this.hours != 0 || this.minutes != 0 || this.seconds != 0) {
            throw new IllegalArgumentException("Can't add interval with non-date portion to DATE: " + this.toString());
        }
        return localDate.plusYears(this.years).plusMonths(this.months).plusDays(this.days);
    }

    public LocalDate subtract(LocalDate localDate) {
        if (this.hours != 0 || this.minutes != 0 || this.seconds != 0) {
            throw new IllegalArgumentException("Can't add interval with non-date portion to DATE: " + this.toString());
        }
        return localDate.minusYears(this.years).minusMonths(this.months).minusDays(this.days);
    }

    public LocalDateTime add(LocalDateTime localDateTime) {
        return localDateTime.plusYears(this.years).plusMonths(this.months).plusDays(this.days).plusHours(this.hours).plusMinutes(this.minutes).plusSeconds(this.seconds);
    }

    public LocalDateTime subtract(LocalDateTime localDateTime) {
        return localDateTime.minusYears(this.years).minusMonths(this.months).minusDays(this.days).minusHours(this.hours).minusMinutes(this.minutes).minusSeconds(this.seconds);
    }

    public ZonedDateTime add(ZonedDateTime zonedDateTime) {
        return zonedDateTime.plusYears(this.years).plusMonths(this.months).plusDays(this.days).plusHours(this.hours).plusMinutes(this.minutes).plusSeconds(this.seconds);
    }

    public ZonedDateTime subtract(ZonedDateTime zonedDateTime) {
        return zonedDateTime.minusYears(this.years).minusMonths(this.months).minusDays(this.days).minusHours(this.hours).minusMinutes(this.minutes).minusSeconds(this.seconds);
    }

    public OffsetDateTime add(OffsetDateTime offsetDateTime) {
        return offsetDateTime.plusYears(this.years).plusMonths(this.months).plusDays(this.days).plusHours(this.hours).plusMinutes(this.minutes).plusSeconds(this.seconds);
    }

    public OffsetDateTime subtract(OffsetDateTime offsetDateTime) {
        return offsetDateTime.minusYears(this.years).minusMonths(this.months).minusDays(this.days).minusHours(this.hours).minusMinutes(this.minutes).minusSeconds(this.seconds);
    }

    public LocalTime add(LocalTime localTime) {
        if (this.years != 0 || this.months != 0 || this.days != 0) {
            throw new IllegalArgumentException("Can't add interval with non-time portion to TIME: " + this.toString());
        }
        return localTime.plusHours(this.hours).plusMinutes(this.minutes).plusSeconds(this.seconds);
    }

    public LocalTime subtract(LocalTime localTime) {
        if (this.years != 0 || this.months != 0 || this.days != 0) {
            throw new IllegalArgumentException("Can't subtract interval with non-time portion from TIME: " + this.toString());
        }
        return localTime.minusHours(this.hours).minusMinutes(this.minutes).minusSeconds(this.seconds);
    }

    @Override
    public int compareTo(TemporalInterval o) {
        int cmp = Integer.compare(this.years, o.years);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(this.months, o.months);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(this.days, o.days);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(this.hours, o.hours);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(this.minutes, o.minutes);
        if (cmp != 0) {
            return cmp;
        }
        return Integer.compare(this.seconds, o.seconds);
    }
}

