/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.domain.declarative.impl.spi;

import com.blazebit.domain.Domain;
import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.declarative.DeclarativeDomainConfiguration;
import com.blazebit.domain.declarative.impl.spi.DeclarativeDomainConfigurationImpl;
import com.blazebit.domain.declarative.spi.DeclarativeAttributeMetadataProcessor;
import com.blazebit.domain.declarative.spi.DeclarativeDomainBuilderProvider;
import com.blazebit.domain.declarative.spi.DeclarativeFunctionMetadataProcessor;
import com.blazebit.domain.declarative.spi.DeclarativeFunctionParameterMetadataProcessor;
import com.blazebit.domain.declarative.spi.DeclarativeMetadataProcessor;
import com.blazebit.domain.declarative.spi.TypeResolver;
import com.blazebit.domain.declarative.spi.TypeResolverDecorator;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class DeclarativeDomainBuilderProviderImpl
implements DeclarativeDomainBuilderProvider {
    private static final Logger LOG = Logger.getLogger(DeclarativeDomainBuilderProviderImpl.class.getName());
    private static final ReferenceQueue<ClassLoader> REFERENCE_QUEUE = new ReferenceQueue();
    private static final ConcurrentMap<WeakClassLoaderKey, Providers> PROVIDERS = new ConcurrentHashMap<WeakClassLoaderKey, Providers>();

    public DeclarativeDomainConfiguration createEmptyBuilder() {
        return this.createEmptyBuilder(Domain.getDefaultProvider().createEmptyBuilder());
    }

    public DeclarativeDomainConfiguration createEmptyBuilder(DomainBuilder builder) {
        return new DeclarativeDomainConfigurationImpl(builder);
    }

    public DeclarativeDomainConfiguration createDefaultConfiguration() {
        return this.createDefaultConfiguration(null);
    }

    public DeclarativeDomainConfiguration createDefaultConfiguration(DomainBuilder domainBuilder) {
        DeclarativeDomainConfigurationImpl domainConfiguration = new DeclarativeDomainConfigurationImpl(domainBuilder);
        Providers providers = DeclarativeDomainBuilderProviderImpl.getProviders();
        Iterator typeResolvers = providers.typeResolvers.iterator();
        if (typeResolvers.hasNext()) {
            TypeResolver typeResolver = (TypeResolver)typeResolvers.next();
            if (typeResolvers.hasNext()) {
                LOG.warning("Multiple type resolvers for declarative domain module are available! You will have to set a type resolver explicitly!");
            } else {
                domainConfiguration.setTypeResolver(typeResolver);
            }
        }
        for (DeclarativeMetadataProcessor processor : providers.declarativeMetadataProcessors) {
            domainConfiguration.withMetadataProcessor((DeclarativeMetadataProcessor<? extends Annotation>)processor);
        }
        for (DeclarativeMetadataProcessor processor : providers.declarativeAttributeMetadataProcessors) {
            domainConfiguration.withMetadataProcessor((DeclarativeAttributeMetadataProcessor<? extends Annotation>)processor);
        }
        for (DeclarativeMetadataProcessor processor : providers.declarativeFunctionMetadataProcessors) {
            domainConfiguration.withMetadataProcessor((DeclarativeFunctionMetadataProcessor<? extends Annotation>)processor);
        }
        for (DeclarativeMetadataProcessor processor : providers.declarativeFunctionParameterMetadataProcessors) {
            domainConfiguration.withMetadataProcessor((DeclarativeFunctionParameterMetadataProcessor<? extends Annotation>)processor);
        }
        for (TypeResolverDecorator typeResolverDecorator : providers.typeResolverDecorators) {
            domainConfiguration.withTypeResolverDecorator(typeResolverDecorator);
        }
        return domainConfiguration;
    }

    private static Providers getProviders() {
        Reference<ClassLoader> reference;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = DeclarativeDomainBuilderProviderImpl.class.getClassLoader();
        }
        while ((reference = REFERENCE_QUEUE.poll()) != null) {
            PROVIDERS.remove(reference);
        }
        WeakClassLoaderKey key = new WeakClassLoaderKey(classLoader, REFERENCE_QUEUE);
        Providers providers = (Providers)PROVIDERS.get(key);
        if (providers == null) {
            providers = new Providers();
            PROVIDERS.put(key, providers);
        }
        return providers;
    }

    private static class Providers {
        private final Iterable<TypeResolver> typeResolvers = Providers.load(TypeResolver.class);
        private final Iterable<DeclarativeMetadataProcessor<Annotation>> declarativeMetadataProcessors = Providers.load(DeclarativeMetadataProcessor.class);
        private final Iterable<DeclarativeAttributeMetadataProcessor<Annotation>> declarativeAttributeMetadataProcessors = Providers.load(DeclarativeAttributeMetadataProcessor.class);
        private final Iterable<DeclarativeFunctionMetadataProcessor<Annotation>> declarativeFunctionMetadataProcessors = Providers.load(DeclarativeFunctionMetadataProcessor.class);
        private final Iterable<DeclarativeFunctionParameterMetadataProcessor<Annotation>> declarativeFunctionParameterMetadataProcessors = Providers.load(DeclarativeFunctionParameterMetadataProcessor.class);
        private final Iterable<TypeResolverDecorator> typeResolverDecorators = Providers.load(TypeResolverDecorator.class);

        private static <T> Iterable<T> load(Class<? super T> clazz) {
            return StreamSupport.stream(ServiceLoader.load(clazz).spliterator(), false).collect(Collectors.toList());
        }
    }

    private static class WeakClassLoaderKey
    extends WeakReference<ClassLoader> {
        private final int hash;

        public WeakClassLoaderKey(ClassLoader referent, ReferenceQueue<ClassLoader> referenceQueue) {
            super(referent, referenceQueue);
            this.hash = referent.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof WeakClassLoaderKey && ((WeakClassLoaderKey)obj).get() == this.get();
        }
    }
}

