/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.domain.declarative.impl.spi;

import com.blazebit.annotation.AnnotationUtils;
import com.blazebit.domain.Domain;
import com.blazebit.domain.boot.model.DomainBuilder;
import com.blazebit.domain.boot.model.DomainFunctionBuilder;
import com.blazebit.domain.boot.model.DomainTypeDefinition;
import com.blazebit.domain.boot.model.EntityDomainTypeBuilder;
import com.blazebit.domain.boot.model.EnumDomainTypeBuilder;
import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.boot.model.MetadataDefinitionHolder;
import com.blazebit.domain.declarative.DeclarativeDomainConfiguration;
import com.blazebit.domain.declarative.DiscoverMode;
import com.blazebit.domain.declarative.DomainAttribute;
import com.blazebit.domain.declarative.DomainFunction;
import com.blazebit.domain.declarative.DomainFunctionParam;
import com.blazebit.domain.declarative.DomainFunctions;
import com.blazebit.domain.declarative.DomainType;
import com.blazebit.domain.declarative.Metadata;
import com.blazebit.domain.declarative.MetadataType;
import com.blazebit.domain.declarative.Transient;
import com.blazebit.domain.declarative.impl.spi.DomainAttributeLiteral;
import com.blazebit.domain.declarative.impl.spi.DomainFunctionLiteral;
import com.blazebit.domain.declarative.spi.DeclarativeAttributeMetadataProcessor;
import com.blazebit.domain.declarative.spi.DeclarativeFunctionMetadataProcessor;
import com.blazebit.domain.declarative.spi.DeclarativeFunctionParameterMetadataProcessor;
import com.blazebit.domain.declarative.spi.DeclarativeMetadataProcessor;
import com.blazebit.domain.declarative.spi.TypeResolver;
import com.blazebit.domain.declarative.spi.TypeResolverDecorator;
import com.blazebit.domain.runtime.model.DomainFunctionTypeResolver;
import com.blazebit.domain.runtime.model.DomainModel;
import com.blazebit.domain.runtime.model.DomainPredicate;
import com.blazebit.domain.spi.ServiceProvider;
import com.blazebit.reflection.ReflectionUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeclarativeDomainConfigurationImpl
implements DeclarativeDomainConfiguration {
    private static final MetadataDefinition[] EMPTY = new MetadataDefinition[0];
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<Class<?>, Object> services = new HashMap();
    private final List<ServiceProvider> serviceProviders = new ArrayList<ServiceProvider>();
    private final Map<Class<?>, DomainType> domainTypes = new HashMap();
    private final Map<Class<?>, DomainFunctions> domainFunctions = new HashMap();
    private final DomainBuilder domainBuilder;
    private final Map<Class<? extends Annotation>, List<DeclarativeMetadataProcessor<Annotation>>> entityMetadataProcessors = new HashMap<Class<? extends Annotation>, List<DeclarativeMetadataProcessor<Annotation>>>();
    private final Map<Class<? extends Annotation>, List<DeclarativeAttributeMetadataProcessor<Annotation>>> attributeMetadataProcessors = new HashMap<Class<? extends Annotation>, List<DeclarativeAttributeMetadataProcessor<Annotation>>>();
    private final Map<Class<? extends Annotation>, List<DeclarativeFunctionMetadataProcessor<Annotation>>> functionMetadataProcessors = new HashMap<Class<? extends Annotation>, List<DeclarativeFunctionMetadataProcessor<Annotation>>>();
    private final Map<Class<? extends Annotation>, List<DeclarativeFunctionParameterMetadataProcessor<Annotation>>> functionParameterMetadataProcessors = new HashMap<Class<? extends Annotation>, List<DeclarativeFunctionParameterMetadataProcessor<Annotation>>>();
    private final List<TypeResolverDecorator> typeResolverDecorators = new ArrayList<TypeResolverDecorator>();
    private TypeResolver typeResolver;
    private boolean functionCaseSensitive;
    private transient TypeResolver configuredTypeResolver;
    private transient Map<Class<?>, String> domainTypeNamesByJavaTypes;

    public DeclarativeDomainConfigurationImpl() {
        this.domainBuilder = null;
    }

    public DeclarativeDomainConfigurationImpl(DomainBuilder domainBuilder) {
        this.domainBuilder = domainBuilder;
    }

    public DeclarativeDomainConfiguration withMetadataProcessor(DeclarativeMetadataProcessor<? extends Annotation> metadataProcessor) {
        this.entityMetadataProcessors.computeIfAbsent(metadataProcessor.getProcessingAnnotation(), k -> new ArrayList()).add(metadataProcessor);
        return this;
    }

    public DeclarativeDomainConfiguration withMetadataProcessor(DeclarativeAttributeMetadataProcessor<? extends Annotation> metadataProcessor) {
        this.attributeMetadataProcessors.computeIfAbsent(metadataProcessor.getProcessingAnnotation(), k -> new ArrayList()).add(metadataProcessor);
        return this;
    }

    public DeclarativeDomainConfiguration withMetadataProcessor(DeclarativeFunctionMetadataProcessor<? extends Annotation> metadataProcessor) {
        this.functionMetadataProcessors.computeIfAbsent(metadataProcessor.getProcessingAnnotation(), k -> new ArrayList()).add(metadataProcessor);
        return this;
    }

    public DeclarativeDomainConfiguration withMetadataProcessor(DeclarativeFunctionParameterMetadataProcessor<? extends Annotation> metadataProcessor) {
        this.functionParameterMetadataProcessors.computeIfAbsent(metadataProcessor.getProcessingAnnotation(), k -> new ArrayList()).add(metadataProcessor);
        return this;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public DeclarativeDomainConfiguration setTypeResolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
        return this;
    }

    public List<TypeResolverDecorator> getTypeResolverDecorators() {
        return this.typeResolverDecorators;
    }

    public DeclarativeDomainConfiguration withTypeResolverDecorator(TypeResolverDecorator typeResolverDecorator) {
        this.typeResolverDecorators.add(typeResolverDecorator);
        return this;
    }

    public <T> T getService(Class<T> serviceClass) {
        return (T)this.services.get(serviceClass);
    }

    public Map<Class<?>, Object> getServices() {
        return Collections.unmodifiableMap(this.services);
    }

    public <T> DeclarativeDomainConfiguration withService(Class<T> serviceClass, T service) {
        this.services.put(serviceClass, service);
        return this;
    }

    public DeclarativeDomainConfiguration withServiceProvider(ServiceProvider serviceProvider) {
        this.serviceProviders.add(serviceProvider);
        return this;
    }

    public DeclarativeDomainConfiguration setFunctionCaseSensitive(boolean caseSensitive) {
        this.functionCaseSensitive = caseSensitive;
        return this;
    }

    public DomainModel createDomainModel() {
        DomainBuilder domainBuilder;
        if (this.domainBuilder == null) {
            domainBuilder = Domain.getDefaultProvider().createEmptyBuilder();
            this.registerPropertiesAndServices(domainBuilder);
            domainBuilder.withDefaults();
        } else {
            domainBuilder = this.domainBuilder;
            this.registerPropertiesAndServices(domainBuilder);
        }
        return this.createDomainModelInternal(domainBuilder);
    }

    public DomainModel createDomainModel(DomainBuilder domainBuilder) {
        this.registerPropertiesAndServices(domainBuilder);
        return this.createDomainModelInternal(domainBuilder);
    }

    private void registerPropertiesAndServices(DomainBuilder domainBuilder) {
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            domainBuilder.setProperty(entry.getKey(), entry.getValue());
        }
        for (ServiceProvider serviceProvider : this.serviceProviders) {
            domainBuilder.withServiceProvider(serviceProvider);
        }
        for (Map.Entry<Object, Object> entry : this.services.entrySet()) {
            domainBuilder.withService((Class)entry.getKey(), entry.getValue());
        }
    }

    private DomainModel createDomainModelInternal(final DomainBuilder domainBuilder) {
        domainBuilder.setFunctionCaseSensitive(this.functionCaseSensitive);
        TypeResolver r = this.typeResolver == null ? TypeResolver.NOOP : this.typeResolver;
        for (int i = 0; i < this.typeResolverDecorators.size(); ++i) {
            r = this.typeResolverDecorators.get(i).decorate(r);
        }
        this.configuredTypeResolver = r;
        this.domainTypeNamesByJavaTypes = null;
        ArrayList<String> errors = new ArrayList<String>();
        ServiceProvider serviceProvider = new ServiceProvider(){

            public <T> T getService(Class<T> serviceClass) {
                Object service;
                block2: {
                    ServiceProvider serviceProvider;
                    if (serviceClass == DomainBuilder.class) {
                        return (T)domainBuilder;
                    }
                    service = DeclarativeDomainConfigurationImpl.this.services.get(serviceClass);
                    if (service != null) break block2;
                    Iterator iterator = DeclarativeDomainConfigurationImpl.this.serviceProviders.iterator();
                    while (iterator.hasNext() && (service = (serviceProvider = (ServiceProvider)iterator.next()).getService(serviceClass)) == null) {
                    }
                }
                return (T)service;
            }
        };
        RuntimeException exception = null;
        try {
            this.analyzeDomainTypes(domainBuilder, serviceProvider, errors);
            this.analyzeDomainFunctions(domainBuilder, serviceProvider, errors);
        }
        catch (RuntimeException ex) {
            exception = ex;
        }
        if (!errors.isEmpty() || exception != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("There are error(s) the declarative domain configuration!");
            for (String error : errors) {
                sb.append('\n');
                sb.append(error);
            }
            throw new IllegalArgumentException(sb.toString(), exception);
        }
        return domainBuilder.build();
    }

    public Map<Class<?>, String> getDomainTypeNamesByJavaTypes(DomainBuilder domainBuilder) {
        if (this.domainTypeNamesByJavaTypes != null) {
            return this.domainTypeNamesByJavaTypes;
        }
        Collection typeDefinitions = domainBuilder.getTypes().values();
        this.domainTypeNamesByJavaTypes = new HashMap(typeDefinitions.size());
        for (DomainTypeDefinition domainTypeDefinition : typeDefinitions) {
            if (domainTypeDefinition.getJavaType() == null) continue;
            this.domainTypeNamesByJavaTypes.put(domainTypeDefinition.getJavaType(), domainTypeDefinition.getName());
        }
        for (Map.Entry entry : this.domainTypes.entrySet()) {
            Class domainTypeClass = (Class)entry.getKey();
            DomainType domainType = (DomainType)entry.getValue();
            if (domainType == null) continue;
            String name = domainType.value();
            if (name.isEmpty()) {
                name = domainTypeClass.getSimpleName();
            }
            this.domainTypeNamesByJavaTypes.put((Class)entry.getKey(), name);
        }
        return this.domainTypeNamesByJavaTypes;
    }

    public DeclarativeDomainConfiguration addDomainFunctions(Class<?> domainFunctionsClass) {
        this.domainFunctions.put(domainFunctionsClass, (DomainFunctions)AnnotationUtils.findAnnotation(domainFunctionsClass, DomainFunctions.class));
        return this;
    }

    public DeclarativeDomainConfiguration addDomainFunctions(Class<?> domainFunctionsClass, DomainFunctions domainFunctionsAnnotation) {
        this.domainFunctions.put(domainFunctionsClass, domainFunctionsAnnotation);
        return this;
    }

    public DeclarativeDomainConfiguration removeDomainFunctions(Class<?> domainFunctionsClass) {
        this.domainFunctions.remove(domainFunctionsClass);
        return this;
    }

    public Set<Class<?>> getDomainFunctions() {
        return this.domainFunctions.keySet();
    }

    public DeclarativeDomainConfiguration addDomainType(Class<?> domainTypeClass) {
        this.domainTypes.put(domainTypeClass, (DomainType)AnnotationUtils.findAnnotation(domainTypeClass, DomainType.class));
        return this;
    }

    public DeclarativeDomainConfiguration addDomainType(Class<?> domainTypeClass, DomainType domainTypeAnnotation) {
        this.domainTypes.put(domainTypeClass, domainTypeAnnotation);
        return this;
    }

    public DeclarativeDomainConfiguration removeDomainType(Class<?> domainTypeClass) {
        this.domainTypes.remove(domainTypeClass);
        return this;
    }

    public Set<Class<?>> getDomainTypes() {
        return this.domainTypes.keySet();
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void analyzeDomainFunctions(DomainBuilder domainBuilder, ServiceProvider serviceProvider, List<String> errors) {
        for (Map.Entry<Class<?>, DomainFunctions> entry : this.domainFunctions.entrySet()) {
            Class<?> domainFunctionsClass = entry.getKey();
            DomainFunctions domainFunctions = entry.getValue();
            if (domainFunctions == null) {
                errors.add("No domain functions annotation found on type: " + domainFunctionsClass);
                continue;
            }
            boolean implicitDiscovery = domainFunctions.discoverMode() != DiscoverMode.EXPLICIT;
            Set superTypes = ReflectionUtils.getSuperTypes(domainFunctionsClass);
            HashSet<String> handledMethods = new HashSet<String>();
            superTypes.remove(Object.class);
            for (Class c : superTypes) {
                for (Method method : c.getDeclaredMethods()) {
                    String methodName;
                    if (method.isBridge() || method.getDeclaringClass() == Object.class || !handledMethods.add(methodName = method.getName())) continue;
                    this.handleDomainFunctionMethod(domainFunctionsClass, method, implicitDiscovery, domainBuilder, serviceProvider, errors);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleDomainFunctionMethod(Class<?> domainFunctionsClass, Method method, boolean implicitDiscovery, DomainBuilder domainBuilder, ServiceProvider serviceProvider, List<String> errors) {
        void var18_22;
        Object functionTypeResolver;
        String name;
        DomainFunction domainFunction = (DomainFunction)AnnotationUtils.findAnnotation((Method)method, DomainFunction.class);
        if (domainFunction == null) {
            if (implicitDiscovery && AnnotationUtils.findAnnotation((Method)method, Transient.class) == null) {
                domainFunction = new DomainFunctionLiteral();
            } else {
                return;
            }
        }
        if ((name = domainFunction.value()).isEmpty()) {
            name = method.getName();
        }
        Class type = domainFunction.collection() ? Collection.class : domainFunction.type();
        String typeName = domainFunction.collection() ? "Collection" : domainFunction.typeName();
        Class elementType = domainFunction.collection() ? domainFunction.type() : Void.TYPE;
        String elementTypeName = domainFunction.collection() ? domainFunction.typeName() : "";
        DomainFunctionBuilder function = domainBuilder.createFunction(name);
        ResolvedType resolvedType = this.resolveType(domainBuilder, typeName, elementTypeName, type, elementType, domainFunctionsClass, method, null);
        String resolvedTypeName = null;
        boolean resolvedCollection = false;
        if (resolvedType != null) {
            resolvedTypeName = resolvedType.resolveTypeName(this, domainBuilder);
            if (resolvedType.collection) {
                resolvedCollection = true;
                function.withCollectionResultType(resolvedTypeName);
            } else {
                function.withResultType(resolvedTypeName);
            }
        }
        if (domainFunction.typeResolver() != DomainFunctionTypeResolver.class && (functionTypeResolver = (DomainFunctionTypeResolver)this.createInstance(domainFunction.typeResolver(), "function type resolver", errors)) != null) {
            domainBuilder.withFunctionTypeResolver(name, (DomainFunctionTypeResolver)functionTypeResolver);
        }
        if (domainFunction.minArguments() > 0) {
            function.withMinArgumentCount(domainFunction.minArguments());
        }
        for (MetadataDefinition metadataDefinition : this.getMetadataDefinitions((Metadata)AnnotationUtils.findAnnotation((Method)method, Metadata.class), errors)) {
            function.withMetadata(metadataDefinition);
        }
        for (Map.Entry entry : this.functionMetadataProcessors.entrySet()) {
            if (entry.getKey() == null) {
                for (DeclarativeFunctionMetadataProcessor processor : (List)entry.getValue()) {
                    MetadataDefinition metadataDefinition = processor.process(domainFunctionsClass, method, null, name, resolvedTypeName, resolvedCollection, serviceProvider);
                    if (metadataDefinition == null) continue;
                    function.withMetadata(metadataDefinition);
                }
                continue;
            }
            Annotation annotation = AnnotationUtils.findAnnotation((Method)method, (Class)((Class)entry.getKey()));
            if (annotation == null) continue;
            for (DeclarativeFunctionMetadataProcessor processor : (List)entry.getValue()) {
                MetadataDefinition metadataDefinition = processor.process(domainFunctionsClass, method, annotation, name, resolvedTypeName, resolvedCollection, serviceProvider);
                if (metadataDefinition == null) continue;
                function.withMetadata(metadataDefinition);
            }
        }
        Parameter[] parameters = method.getParameters();
        boolean bl = false;
        while (var18_22 < parameters.length) {
            this.handleDomainFunctionParameter(domainBuilder, function, domainFunctionsClass, method, parameters[var18_22], serviceProvider, errors);
            ++var18_22;
        }
        function.build();
    }

    private String resolveJavaType(Class<?> type, Map<Class<?>, String> domainTypeNamesByJavaTypes) {
        String typeName = domainTypeNamesByJavaTypes.get(type);
        return typeName;
    }

    private void handleDomainFunctionParameter(DomainBuilder domainBuilder, DomainFunctionBuilder function, Class<?> domainFunctionsClass, Method method, Parameter parameter, ServiceProvider serviceProvider, List<String> errors) {
        boolean resolvedCollection;
        String elementTypeName;
        Class<Void> elementType;
        String typeName;
        Class type;
        String parameterName = parameter.getName();
        DomainFunctionParam param = parameter.getAnnotation(DomainFunctionParam.class);
        if (param == null) {
            if (parameter.isVarArgs()) {
                type = Collection.class;
                typeName = "Collection";
                elementType = parameter.getType().getComponentType();
                elementTypeName = "";
            } else {
                type = Void.TYPE;
                typeName = "";
                elementType = null;
                elementTypeName = "";
            }
        } else {
            if (!param.value().isEmpty()) {
                parameterName = param.value();
            }
            if (param.collection() || parameter.isVarArgs()) {
                type = Collection.class;
                typeName = "Collection";
                elementType = param.type();
                elementTypeName = param.typeName();
            } else {
                type = param.type();
                typeName = param.typeName();
                elementType = Void.TYPE;
                elementTypeName = "";
            }
        }
        ResolvedType resolvedType = this.resolveType(domainBuilder, typeName, elementTypeName, type, elementType, domainFunctionsClass, method, parameter);
        String resolvedTypeName = null;
        if (resolvedType == null) {
            resolvedCollection = param != null && param.collection();
        } else {
            resolvedTypeName = resolvedType.resolveTypeName(this, domainBuilder);
            resolvedCollection = resolvedType.collection;
        }
        List<MetadataDefinition<?>> metadataDefinitions = this.getMetadataDefinitions(parameter.getAnnotation(Metadata.class), errors);
        for (Map.Entry<Class<? extends Annotation>, List<DeclarativeFunctionParameterMetadataProcessor<Annotation>>> entry : this.functionParameterMetadataProcessors.entrySet()) {
            if (entry.getKey() == null) {
                for (DeclarativeFunctionParameterMetadataProcessor<Annotation> processor : entry.getValue()) {
                    MetadataDefinition metadataDefinition = processor.process(domainFunctionsClass, method, parameter, null, parameterName, resolvedTypeName, resolvedCollection, serviceProvider);
                    if (metadataDefinition == null) continue;
                    if (metadataDefinition.getJavaType() == Transient.class) {
                        return;
                    }
                    metadataDefinitions.add(metadataDefinition);
                }
                continue;
            }
            Annotation annotation = parameter.getAnnotation(entry.getKey());
            if (annotation == null) continue;
            for (DeclarativeFunctionParameterMetadataProcessor<Annotation> processor : entry.getValue()) {
                MetadataDefinition metadataDefinition = processor.process(domainFunctionsClass, method, parameter, annotation, parameterName, resolvedTypeName, resolvedCollection, serviceProvider);
                if (metadataDefinition == null) continue;
                if (metadataDefinition.getJavaType() == Transient.class) {
                    return;
                }
                metadataDefinitions.add(metadataDefinition);
            }
        }
        MetadataDefinition[] metadataDefinitionArray = metadataDefinitions.isEmpty() ? EMPTY : metadataDefinitions.toArray(new MetadataDefinition[metadataDefinitions.size()]);
        if (resolvedTypeName == null) {
            if (resolvedCollection) {
                function.withCollectionArgument(parameterName, metadataDefinitionArray);
            } else {
                function.withArgument(parameterName, metadataDefinitionArray);
            }
        } else if (resolvedCollection) {
            function.withCollectionArgument(parameterName, resolvedTypeName, metadataDefinitionArray);
        } else {
            function.withArgument(parameterName, resolvedTypeName, metadataDefinitionArray);
        }
        if (parameter.isVarArgs()) {
            function.withMinArgumentCount(function.getArgumentCount() - 1);
        }
    }

    private <X> X createInstance(Class<X> clazz, String kind, List<String> errors) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            sw.write("Could not instantiate ");
            sw.write(kind);
            ex.printStackTrace(new PrintWriter(sw));
            errors.add(sw.toString());
            return null;
        }
    }

    private List<MetadataDefinition<?>> getMetadataDefinitions(Metadata annotation, List<String> errors) {
        ArrayList list = new ArrayList();
        if (annotation != null) {
            for (Class metadataObjectType : annotation.value()) {
                Class type;
                MetadataType metadataType = (MetadataType)AnnotationUtils.findAnnotation((Class)metadataObjectType, MetadataType.class);
                if (metadataType == null) {
                    type = metadataObjectType;
                } else {
                    type = metadataType.value();
                    if (!type.isAssignableFrom(metadataObjectType)) {
                        errors.add("The metadata object type '" + type.getName() + "' defined for '" + metadataObjectType.getName() + "' is not a super type!");
                        continue;
                    }
                }
                Object metadataObject = this.createInstance(metadataObjectType, "metadata object", errors);
                if (metadataObject == null) continue;
                list.add(new SimpleMetadataDefinition(type, metadataObject));
            }
        }
        return list;
    }

    private void analyzeDomainTypes(DomainBuilder domainBuilder, ServiceProvider serviceProvider, List<String> errors) {
        for (Map.Entry<Class<?>, DomainType> entry : this.domainTypes.entrySet()) {
            Class<?> domainTypeClass = entry.getKey();
            DomainType domainType = entry.getValue();
            if (domainType == null) {
                errors.add("No domain type annotation found on type: " + domainTypeClass);
                continue;
            }
            String name = domainType.value();
            if (name.isEmpty()) {
                name = domainTypeClass.getSimpleName();
            }
            boolean implicitDiscovery = domainType.discoverMode() != DiscoverMode.EXPLICIT;
            boolean caseSensitive = domainType.caseSensitive();
            Set superTypes = ReflectionUtils.getSuperTypes(domainTypeClass);
            superTypes.remove(Object.class);
            List<MetadataDefinition<?>> metadataDefinitions = this.getMetadataDefinitions((Metadata)AnnotationUtils.findAnnotation(domainTypeClass, Metadata.class), errors);
            for (Class type : superTypes) {
                for (Map.Entry<Class<? extends Annotation>, List<DeclarativeMetadataProcessor<Annotation>>> metadataEntry : this.entityMetadataProcessors.entrySet()) {
                    if (metadataEntry.getKey() == null) {
                        for (DeclarativeMetadataProcessor<Annotation> processor : metadataEntry.getValue()) {
                            MetadataDefinition metadataDefinition = processor.process(domainTypeClass, null, serviceProvider);
                            if (metadataDefinition == null) continue;
                            metadataDefinitions.add(metadataDefinition);
                        }
                        continue;
                    }
                    Annotation annotation = AnnotationUtils.findAnnotation((Class)type, metadataEntry.getKey());
                    if (annotation == null) continue;
                    for (DeclarativeMetadataProcessor<Annotation> processor : metadataEntry.getValue()) {
                        MetadataDefinition metadataDefinition = processor.process(domainTypeClass, annotation, serviceProvider);
                        if (metadataDefinition == null) continue;
                        metadataDefinitions.add(metadataDefinition);
                    }
                }
            }
            if (domainTypeClass.isEnum()) {
                Class<?> enumDomainTypeClass = domainTypeClass;
                EnumDomainTypeBuilder enumType = domainBuilder.createEnumType(name, enumDomainTypeClass);
                enumType.setCaseSensitive(caseSensitive);
                for (int i = 0; i < metadataDefinitions.size(); ++i) {
                    enumType.withMetadata(metadataDefinitions.get(i));
                }
                Enum[] enumConstants = (Enum[])domainTypeClass.getEnumConstants();
                for (int i = 0; i < enumConstants.length; ++i) {
                    this.handleEnumConstant(enumType, enumDomainTypeClass, enumConstants[i], serviceProvider, errors);
                }
                enumType.build();
            } else {
                EntityDomainTypeBuilder entityType = domainBuilder.createEntityType(name, domainTypeClass);
                entityType.setCaseSensitive(caseSensitive);
                for (int i = 0; i < metadataDefinitions.size(); ++i) {
                    entityType.withMetadata(metadataDefinitions.get(i));
                }
                HashSet<String> handledMethods = new HashSet<String>();
                for (Class c : superTypes) {
                    for (Method method : c.getDeclaredMethods()) {
                        String methodName;
                        if (Modifier.isPrivate(method.getModifiers()) || method.isBridge() || !handledMethods.add(methodName = method.getName())) continue;
                        this.handleDomainAttributeMethod(domainBuilder, entityType, domainTypeClass, method, implicitDiscovery, serviceProvider, errors);
                    }
                }
                entityType.build();
            }
            domainBuilder.withPredicate(name, new DomainPredicate[]{DomainPredicate.NULLNESS, DomainPredicate.EQUALITY});
        }
    }

    private void handleEnumConstant(EnumDomainTypeBuilder enumType, Class<? extends Enum<?>> domainTypeClass, Enum<?> enumConstant, ServiceProvider serviceProvider, List<String> errors) {
        List<MetadataDefinition<?>> metadataDefinitions = this.getMetadataDefinitions(enumConstant.getClass().getAnnotation(Metadata.class), errors);
        Class<?> constantClass = enumConstant.getClass();
        for (Map.Entry<Class<? extends Annotation>, List<DeclarativeMetadataProcessor<Annotation>>> entry : this.entityMetadataProcessors.entrySet()) {
            if (entry.getKey() == null) {
                for (DeclarativeMetadataProcessor<Annotation> processor : entry.getValue()) {
                    MetadataDefinition metadataDefinition = processor.process(constantClass, null, serviceProvider);
                    if (metadataDefinition == null) continue;
                    metadataDefinitions.add(metadataDefinition);
                }
                continue;
            }
            Annotation annotation = AnnotationUtils.findAnnotation(constantClass, entry.getKey());
            if (annotation == null) continue;
            for (DeclarativeMetadataProcessor<Annotation> processor : entry.getValue()) {
                MetadataDefinition metadataDefinition = processor.process(constantClass, annotation, serviceProvider);
                if (metadataDefinition == null) continue;
                metadataDefinitions.add(metadataDefinition);
            }
        }
        MetadataDefinition[] metadataDefinitionArray = metadataDefinitions.isEmpty() ? EMPTY : metadataDefinitions.toArray(new MetadataDefinition[metadataDefinitions.size()]);
        enumType.withValue(enumConstant.name(), metadataDefinitionArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleDomainAttributeMethod(DomainBuilder domainBuilder, EntityDomainTypeBuilder entityType, Class<?> domainTypeClass, Method method, boolean implicitDiscovery, ServiceProvider serviceProvider, List<String> errors) {
        DomainAttribute domainAttribute = (DomainAttribute)AnnotationUtils.findAnnotation((Method)method, DomainAttribute.class);
        if (domainAttribute == null) {
            if (!implicitDiscovery || !ReflectionUtils.isGetter((Method)method) || AnnotationUtils.findAnnotation((Method)method, Transient.class) != null) return;
            domainAttribute = new DomainAttributeLiteral();
        } else if (!ReflectionUtils.isGetter((Method)method)) {
            errors.add("Non-getter can't be a domain type attribute: " + method);
            return;
        }
        String name = DeclarativeDomainConfigurationImpl.getAttributeName(method);
        Class type = domainAttribute.collection() ? Collection.class : domainAttribute.value();
        String typeName = domainAttribute.collection() ? "Collection" : domainAttribute.typeName();
        Class elementType = domainAttribute.collection() ? domainAttribute.value() : Void.TYPE;
        String elementTypeName = domainAttribute.collection() ? domainAttribute.typeName() : "";
        ResolvedType resolvedType = this.resolveType(domainBuilder, typeName, elementTypeName, type, elementType, domainTypeClass, method, null);
        if (resolvedType == null) {
            resolvedType = ResolvedType.basic(Object.class);
        }
        String resolvedTypeName = resolvedType.resolveTypeName(this, domainBuilder);
        List<MetadataDefinition<?>> metadataDefinitions = this.getMetadataDefinitions((Metadata)AnnotationUtils.findAnnotation((Method)method, Metadata.class), errors);
        for (Map.Entry<Class<? extends Annotation>, List<DeclarativeAttributeMetadataProcessor<Annotation>>> entry : this.attributeMetadataProcessors.entrySet()) {
            MetadataDefinition metadataDefinition;
            if (entry.getKey() == DomainAttribute.class) {
                for (DeclarativeAttributeMetadataProcessor<Annotation> processor : entry.getValue()) {
                    metadataDefinition = processor.process(domainTypeClass, method, (Annotation)domainAttribute, name, resolvedTypeName, resolvedType.collection, serviceProvider);
                    if (metadataDefinition == null) continue;
                    metadataDefinitions.add(metadataDefinition);
                }
                continue;
            }
            if (entry.getKey() == null) {
                for (DeclarativeAttributeMetadataProcessor<Annotation> processor : entry.getValue()) {
                    metadataDefinition = processor.process(domainTypeClass, method, null, name, resolvedTypeName, resolvedType.collection, serviceProvider);
                    if (metadataDefinition == null) continue;
                    metadataDefinitions.add(metadataDefinition);
                }
                continue;
            }
            Annotation annotation = AnnotationUtils.findAnnotation((Method)method, entry.getKey());
            if (annotation == null) continue;
            for (DeclarativeAttributeMetadataProcessor<Annotation> processor : entry.getValue()) {
                MetadataDefinition metadataDefinition2 = processor.process(domainTypeClass, method, annotation, name, resolvedTypeName, resolvedType.collection, serviceProvider);
                if (metadataDefinition2 == null) continue;
                metadataDefinitions.add(metadataDefinition2);
            }
        }
        MetadataDefinition[] metadataDefinitionArray = metadataDefinitions.isEmpty() ? EMPTY : metadataDefinitions.toArray(new MetadataDefinition[metadataDefinitions.size()]);
        if (resolvedType.collection) {
            entityType.addCollectionAttribute(name, resolvedTypeName, metadataDefinitionArray);
            return;
        } else {
            entityType.addAttribute(name, resolvedTypeName, metadataDefinitionArray);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ResolvedType resolveType(DomainBuilder domainBuilder, String typeName, String elementTypeName, Class<?> type, Class<?> elementType, Class<?> baseClass, Method method, Parameter parameter) {
        void var9_17;
        Object resolvedType;
        if (!typeName.isEmpty()) {
            if (!"Collection".equals(typeName)) return ResolvedType.basic(typeName);
            if (!elementTypeName.isEmpty()) return ResolvedType.collection(elementTypeName);
            if (elementType != Object.class && elementType != Void.TYPE) {
                return ResolvedType.collection(elementType);
            }
        } else if (this.configuredTypeResolver != null) {
            void var9_12;
            if (type == Void.TYPE) {
                if (parameter == null) {
                    Type type2 = method.getGenericReturnType();
                } else {
                    Type type3 = parameter.getParameterizedType();
                }
            } else {
                Class<Object> clazz = type;
            }
            resolvedType = this.configuredTypeResolver.resolve(baseClass, (Type)var9_12, domainBuilder);
            if (resolvedType == Object.class) {
                return null;
            }
            if (resolvedType == null && !(var9_12 instanceof Class)) {
                if (parameter == null) {
                    resolvedType = this.configuredTypeResolver.resolve(baseClass, (Type)ReflectionUtils.getResolvedMethodReturnType(baseClass, (Method)method), domainBuilder);
                } else {
                    int idx = Arrays.asList(method.getParameters()).indexOf(parameter);
                    resolvedType = this.configuredTypeResolver.resolve(baseClass, (Type)ReflectionUtils.getResolvedMethodParameterTypes(baseClass, (Method)method)[idx], domainBuilder);
                }
            }
            if (resolvedType instanceof String) {
                return ResolvedType.basic((String)resolvedType);
            }
            if (resolvedType instanceof Class) {
                return ResolvedType.basic((Class)resolvedType);
            }
            if (resolvedType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)resolvedType;
                Type rawType = parameterizedType.getRawType();
                if ("Collection".equals(rawType.getTypeName()) || rawType instanceof Class && Collection.class.isAssignableFrom((Class)rawType)) {
                    Type[] typeArguments = parameterizedType.getActualTypeArguments();
                    if (typeArguments.length == 0 || typeArguments[0] instanceof WildcardType || typeArguments[0] == Object.class) return ResolvedType.collection();
                    if (!(typeArguments[0] instanceof Class)) return ResolvedType.collection(typeArguments[0].getTypeName());
                    return ResolvedType.collection((Class)typeArguments[0]);
                }
                if (rawType instanceof Class) {
                    return ResolvedType.basic((Class)rawType);
                }
            }
        }
        if (type == Object.class) {
            return null;
        }
        if (type == Void.TYPE) {
            void var9_15;
            if (parameter == null) {
                Class clazz = ReflectionUtils.getResolvedMethodReturnType(baseClass, (Method)method);
            } else {
                Class<?> clazz = parameter.getType();
            }
            elementType = this.resolveElementType(baseClass, method, parameter, (Class<?>)var9_15);
        } else {
            Class<Object> clazz = type;
            elementType = this.resolveElementType(baseClass, method, parameter, clazz);
        }
        if (Object.class == var9_17) {
            return null;
        }
        if (Collection.class.isAssignableFrom((Class<?>)var9_17)) {
            if (this.configuredTypeResolver == null) return ResolvedType.collection(elementType);
            resolvedType = this.configuredTypeResolver.resolve(baseClass, elementType, domainBuilder);
            if (resolvedType instanceof String) {
                return ResolvedType.collection((String)resolvedType);
            }
            if (!(resolvedType instanceof Class)) return ResolvedType.collection(elementType);
            return ResolvedType.collection((Class)resolvedType);
        }
        if (this.configuredTypeResolver == null) return ResolvedType.basic(var9_17);
        resolvedType = this.configuredTypeResolver.resolve(baseClass, (Type)var9_17, domainBuilder);
        if (resolvedType instanceof String) {
            return ResolvedType.basic((String)resolvedType);
        }
        if (!(resolvedType instanceof Class)) return ResolvedType.basic(var9_17);
        return ResolvedType.basic((Class)resolvedType);
    }

    private Class<?> resolveElementType(Class<?> baseClass, Method method, Parameter parameter, Class<?> returnType) {
        Class elementType;
        if (parameter == null) {
            Class[] typeArguments;
            elementType = Collection.class.isAssignableFrom(returnType) ? ((typeArguments = ReflectionUtils.getResolvedMethodReturnTypeArguments(baseClass, (Method)method)).length == 0 || typeArguments[0] == Object.class ? null : typeArguments[0]) : null;
        } else if (Collection.class.isAssignableFrom(returnType)) {
            Type[] typeArguments;
            Type resolvedType;
            Type parameterType = parameter.getParameterizedType();
            elementType = null;
            if (parameterType instanceof ParameterizedType && (resolvedType = ReflectionUtils.resolve(baseClass, (Type)(typeArguments = ((ParameterizedType)parameterType).getActualTypeArguments())[0])) != Object.class) {
                elementType = (Class)resolvedType;
            }
        } else {
            elementType = null;
        }
        return elementType;
    }

    protected static String getAttributeName(Method getterOrSetter) {
        String name = getterOrSetter.getName();
        StringBuilder sb = new StringBuilder(name.length());
        int index = name.startsWith("is") ? 2 : 3;
        char firstAttributeNameChar = name.charAt(index);
        return sb.append(Character.toLowerCase(firstAttributeNameChar)).append(name, index + 1, name.length()).toString();
    }

    private static class ResolvedType {
        private final String typeName;
        private final Class<?> type;
        private final boolean collection;

        public ResolvedType(String typeName, Class<?> type, boolean collection) {
            this.typeName = typeName;
            this.type = type;
            this.collection = collection;
        }

        public String resolveTypeName(DeclarativeDomainConfigurationImpl configuration, DomainBuilder domainBuilder) {
            if (this.typeName.isEmpty()) {
                return configuration.resolveJavaType(this.type, configuration.getDomainTypeNamesByJavaTypes(domainBuilder));
            }
            return this.typeName;
        }

        public static ResolvedType basic(String typeName) {
            return new ResolvedType(typeName, null, false);
        }

        public static ResolvedType basic(Class<?> type) {
            return new ResolvedType("", type, false);
        }

        public static ResolvedType collection() {
            return new ResolvedType(null, null, true);
        }

        public static ResolvedType collection(String typeName) {
            return new ResolvedType(typeName, null, true);
        }

        public static ResolvedType collection(Class<?> type) {
            return new ResolvedType("", type, true);
        }
    }

    private static class SimpleMetadataDefinition<X>
    implements MetadataDefinition<X>,
    Serializable {
        private static final Field TYPE;
        private final transient Class<X> type;
        private final X object;

        public SimpleMetadataDefinition(Class<X> type, X object) {
            this.type = type;
            this.object = object;
        }

        public Class<X> getJavaType() {
            return this.type;
        }

        public X build(MetadataDefinitionHolder definitionHolder) {
            return this.object;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeUTF(this.type.getName());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            String className = in.readUTF();
            try {
                TYPE.set(this, Class.forName(className));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        static {
            try {
                Field field = SimpleMetadataDefinition.class.getDeclaredField("type");
                field.setAccessible(true);
                TYPE = field;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

