/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.declarative.persistence;

import com.blazebit.domain.runtime.model.DomainModel;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.domain.runtime.model.EntityDomainType;
import com.blazebit.domain.runtime.model.EntityDomainTypeAttribute;
import com.blazebit.expression.ExpressionCompiler;
import com.blazebit.expression.ExpressionService;
import com.blazebit.expression.ExpressionServiceBuilder;
import com.blazebit.expression.Literal;
import com.blazebit.expression.declarative.persistence.EntityLiteralPersistenceRestrictionProvider;
import com.blazebit.expression.declarative.persistence.EntityResolvedLiteral;
import com.blazebit.expression.spi.EntityLiteralResolver;
import com.blazebit.expression.spi.ExpressionServiceContributor;
import com.blazebit.expression.spi.ExpressionServiceSerializer;
import com.blazebit.expression.spi.ResolvedLiteral;
import com.blazebit.expression.spi.TypeAdapter;
import com.blazebit.persistence.CriteriaBuilderFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;

public class EntityExpressionServiceContributor
implements ExpressionServiceContributor {
    public static final String ENTITY_LITERAL_CAPABLE_MODE = "com.blazebit.expression.declarative.persistence.entity_literal_capable_mode";

    public void contribute(ExpressionServiceBuilder expressionServiceBuilder) {
        DomainModel domainModel = expressionServiceBuilder.getDomainModel();
        CriteriaBuilderFactory criteriaBuilderFactory = (CriteriaBuilderFactory)domainModel.getService(CriteriaBuilderFactory.class);
        Mode mode = Mode.of((String)domainModel.getProperty(ENTITY_LITERAL_CAPABLE_MODE));
        if (criteriaBuilderFactory == null || mode == Mode.NONE) {
            return;
        }
        HashMap<String, Resolver> entityResolvers = new HashMap<String, Resolver>();
        Metamodel metamodel = (Metamodel)criteriaBuilderFactory.getService(Metamodel.class);
        for (DomainType domainType : domainModel.getTypes().values()) {
            EntityType entityType;
            EntityLiteralPersistenceRestrictionProvider restrictionProvider;
            if (!(domainType instanceof EntityDomainType) || domainType.getJavaType() == null || (restrictionProvider = (EntityLiteralPersistenceRestrictionProvider)domainType.getMetadata(EntityLiteralPersistenceRestrictionProvider.class)) == null && mode != Mode.ALL) continue;
            try {
                entityType = metamodel.entity(domainType.getJavaType());
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            entityResolvers.put(domainType.getName(), new Resolver((EntityDomainType)domainType, entityType, restrictionProvider));
        }
        if (!entityResolvers.isEmpty()) {
            expressionServiceBuilder.withEntityLiteralResolver((EntityLiteralResolver)new EntityEntityLiteralResolver(expressionServiceBuilder.getEntityLiteralResolver(), entityResolvers));
        }
    }

    public int priority() {
        return 550;
    }

    private static enum Mode {
        NONE,
        ALL,
        ANNOTATED;


        static Mode of(String value) {
            if (value == null || value.isEmpty() || "annotated".equalsIgnoreCase(value)) {
                return ANNOTATED;
            }
            if ("all".equalsIgnoreCase(value)) {
                return ALL;
            }
            return NONE;
        }
    }

    private static class Resolver {
        final EntityDomainTypeAttribute idDomainAttribute;
        final String idAttributeName;
        final boolean isIdString;
        final TypeAdapter typeAdapter;
        final String expressionPrefix;
        final EntityLiteralPersistenceRestrictionProvider restrictionProvider;

        public Resolver(EntityDomainType entityDomainType, EntityType<?> entityType, EntityLiteralPersistenceRestrictionProvider restrictionProvider) {
            SingularAttribute idAttribute = null;
            try {
                for (SingularAttribute singularAttribute : entityType.getSingularAttributes()) {
                    if (!singularAttribute.isId()) continue;
                    if (idAttribute == null) {
                        idAttribute = singularAttribute;
                        continue;
                    }
                    idAttribute = null;
                    break;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (idAttribute == null) {
                throw new IllegalArgumentException("Couldn't determine the id attribute for the entity type: " + entityType.getName());
            }
            this.idAttributeName = idAttribute.getName();
            this.isIdString = idAttribute.getJavaType() == String.class;
            this.idDomainAttribute = entityDomainType.getAttribute(this.idAttributeName);
            this.typeAdapter = (TypeAdapter)this.idDomainAttribute.getMetadata(TypeAdapter.class);
            this.expressionPrefix = entityType.getName() + "[" + this.idAttributeName + " = ";
            this.restrictionProvider = restrictionProvider;
        }

        public Object getEntityId(Map<EntityDomainTypeAttribute, ?> attributeValues) {
            Literal literal = (Literal)attributeValues.get(this.idDomainAttribute);
            if (this.typeAdapter == null) {
                return literal.getValue();
            }
            return this.typeAdapter.toModelType(null, literal.getValue(), this.idDomainAttribute.getType());
        }
    }

    private static class EntityEntityLiteralResolver
    implements ExpressionServiceSerializer<EntityLiteralResolver>,
    EntityLiteralResolver,
    Serializable {
        private final EntityLiteralResolver delegate;
        private final Map<String, Resolver> entityResolvers;

        public EntityEntityLiteralResolver(EntityLiteralResolver delegate, Map<String, Resolver> entityResolvers) {
            this.delegate = delegate;
            this.entityResolvers = entityResolvers;
        }

        public ResolvedLiteral resolveLiteral(ExpressionCompiler.Context context, EntityDomainType entityDomainType, Map<EntityDomainTypeAttribute, ? extends Literal> attributeValues) {
            Resolver resolver = this.entityResolvers.get(entityDomainType.getName());
            if (resolver != null) {
                return new EntityResolvedLiteral(context.getExpressionService().getDomainModel(), entityDomainType, resolver.getEntityId(attributeValues), resolver.isIdString, resolver.expressionPrefix, resolver.restrictionProvider);
            }
            return this.delegate == null ? null : this.delegate.resolveLiteral(context, entityDomainType, attributeValues);
        }

        public <T> T serialize(ExpressionService expressionService, EntityLiteralResolver element, Class<T> targetType, String format, Map<String, Object> properties) {
            StringBuilder sb = new StringBuilder();
            if (this.delegate != null) {
                sb.append("{\"DelegatingEntityLiteralResolver\":[");
            }
            sb.append("{\"FixedEntityLiteralResolver\":[{");
            for (Map.Entry<String, Resolver> entry : this.entityResolvers.entrySet()) {
                sb.append("\"").append(entry.getKey()).append("\":\"").append(entry.getValue().idAttributeName).append("\",");
            }
            sb.setCharAt(sb.length() - 1, '}');
            sb.append("]}");
            if (this.delegate != null) {
                sb.append(",");
                sb.append(((ExpressionServiceSerializer)this.delegate).serialize(expressionService, null, targetType, format, properties));
                sb.append("]}");
            }
            return (T)sb.toString();
        }
    }
}

