/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.declarative.persistence;

import com.blazebit.domain.runtime.model.DomainModel;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.domain.runtime.model.EntityDomainType;
import com.blazebit.expression.declarative.persistence.EntityLiteralPersistenceRestrictionProvider;
import com.blazebit.expression.spi.ResolvedLiteral;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

public class EntityResolvedLiteral
implements ResolvedLiteral,
Serializable {
    private final DomainModel domainModel;
    private final EntityDomainType entityDomainType;
    private final Object idValue;
    private final boolean isIdString;
    private final String expressionPrefix;
    private final EntityLiteralPersistenceRestrictionProvider entityLiteralRestrictionProvider;
    private transient String expression;

    public EntityResolvedLiteral(DomainModel domainModel, EntityDomainType entityDomainType, Object idValue, boolean isIdString, String expressionPrefix, EntityLiteralPersistenceRestrictionProvider restrictionProvider) {
        this.domainModel = domainModel;
        this.entityDomainType = entityDomainType;
        this.idValue = idValue;
        this.isIdString = isIdString;
        this.expressionPrefix = expressionPrefix;
        this.entityLiteralRestrictionProvider = restrictionProvider;
    }

    public DomainType getType() {
        return this.entityDomainType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        EntityManager entityManager = (EntityManager)this.domainModel.getService(EntityManager.class);
        boolean created = false;
        if (entityManager == null) {
            entityManager = ((EntityManagerFactory)this.domainModel.getService(EntityManagerFactory.class)).createEntityManager();
            created = true;
        }
        try {
            Object object = entityManager.getReference(this.entityDomainType.getJavaType(), this.idValue);
            return object;
        }
        finally {
            if (created) {
                entityManager.close();
            }
        }
    }

    public String toString() {
        String expression = this.expression;
        if (expression == null) {
            StringBuilder sb = new StringBuilder(this.expressionPrefix + 20);
            if (this.isIdString) {
                sb.append('\'');
                String value = (String)this.idValue;
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (c == '\'') {
                        sb.append('\'');
                    }
                    sb.append(c);
                }
                sb.append('\'');
            } else {
                sb.append(this.idValue);
            }
            String restriction = this.entityLiteralRestrictionProvider.getRestriction(this.domainModel, this.entityDomainType);
            if (restriction != null && !restriction.isEmpty()) {
                sb.append(" AND ").append(restriction);
            }
            sb.append(']');
            this.expression = expression = sb.toString();
        }
        return expression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityResolvedLiteral)) {
            return false;
        }
        EntityResolvedLiteral that = (EntityResolvedLiteral)o;
        if (!this.entityDomainType.equals(that.entityDomainType)) {
            return false;
        }
        return this.idValue.equals(that.idValue);
    }

    public int hashCode() {
        int result = this.entityDomainType.hashCode();
        result = 31 * result + this.idValue.hashCode();
        return result;
    }
}

