/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.declarative.persistence;

import com.blazebit.domain.boot.model.MetadataDefinition;
import com.blazebit.domain.boot.model.MetadataDefinitionHolder;
import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.persistence.PersistenceDomainFunctionArgumentRenderers;
import com.blazebit.expression.persistence.PersistenceExpressionSerializer;
import com.blazebit.expression.persistence.PersistenceFunctionRenderer;
import java.io.Serializable;
import java.util.ArrayList;

public class ExpressionPersistenceFunctionRenderer
implements MetadataDefinition<PersistenceFunctionRenderer>,
PersistenceFunctionRenderer,
Serializable {
    private final String[] chunks;
    private final int[] parameterIndices;
    private final boolean rendersPredicate;

    public ExpressionPersistenceFunctionRenderer(String template, boolean rendersPredicate) {
        this.rendersPredicate = rendersPredicate;
        ArrayList<String> chunkList = new ArrayList<String>();
        ArrayList<Integer> parameterIndexList = new ArrayList<Integer>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (c == '?') {
                chunkList.add(sb.toString());
                sb.setLength(0);
                while (++i < template.length()) {
                    c = template.charAt(i);
                    if (Character.isDigit(c)) {
                        sb.append(c);
                        continue;
                    }
                    parameterIndexList.add(Integer.parseInt(sb.toString()) - 1);
                    sb.setLength(0);
                    sb.append(c);
                    break;
                }
                if (i != template.length()) continue;
                parameterIndexList.add(Integer.parseInt(sb.toString()) - 1);
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            chunkList.add(sb.toString());
        }
        int[] parameterIndices = new int[parameterIndexList.size()];
        for (int i = 0; i < parameterIndexList.size(); ++i) {
            parameterIndices[i] = (Integer)parameterIndexList.get(i);
        }
        this.chunks = chunkList.toArray(new String[chunkList.size()]);
        this.parameterIndices = parameterIndices;
    }

    public boolean rendersPredicate() {
        return this.rendersPredicate;
    }

    public void render(DomainFunction function, DomainType returnType, PersistenceDomainFunctionArgumentRenderers argumentRenderers, StringBuilder sb, PersistenceExpressionSerializer serializer) {
        for (int i = 0; i < this.chunks.length; ++i) {
            sb.append(this.chunks[i]);
            if (i >= this.parameterIndices.length) continue;
            argumentRenderers.renderArgument(sb, this.parameterIndices[i]);
        }
    }

    public Class<PersistenceFunctionRenderer> getJavaType() {
        return PersistenceFunctionRenderer.class;
    }

    public PersistenceFunctionRenderer build(MetadataDefinitionHolder definitionHolder) {
        return this;
    }
}

