/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.persistence;

import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.persistence.PersistenceExpressionSerializer;
import com.blazebit.expression.persistence.PersistenceLiteralRenderer;
import java.io.Serializable;
import java.time.LocalDate;

public class PersistenceDateLiteralRenderer
implements PersistenceLiteralRenderer,
Serializable {
    public static final PersistenceDateLiteralRenderer INSTANCE = new PersistenceDateLiteralRenderer();

    private PersistenceDateLiteralRenderer() {
    }

    @Override
    public void render(Object value, DomainType domainType, PersistenceExpressionSerializer serializer) {
        LocalDate localDate = (LocalDate)value;
        StringBuilder sb = serializer.getStringBuilder();
        sb.append("{d '");
        sb.append(localDate.getYear());
        sb.append('-');
        if (localDate.getMonthValue() < 10) {
            sb.append('0');
        }
        sb.append(localDate.getMonthValue());
        sb.append('-');
        if (localDate.getDayOfMonth() < 10) {
            sb.append('0');
        }
        sb.append(localDate.getDayOfMonth());
        sb.append("'}");
    }
}

