/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.persistence;

import com.blazebit.domain.runtime.model.DomainOperator;
import com.blazebit.domain.runtime.model.TemporalInterval;
import com.blazebit.expression.ArithmeticExpression;
import com.blazebit.expression.ChainingArithmeticExpression;
import com.blazebit.expression.DomainModelException;
import com.blazebit.expression.Expression;
import com.blazebit.expression.Literal;
import com.blazebit.expression.persistence.PersistenceDomainOperatorRenderer;
import com.blazebit.expression.persistence.PersistenceExpressionSerializer;
import java.io.Serializable;

public class PersistenceDateOperatorRenderer
implements PersistenceDomainOperatorRenderer,
Serializable {
    public static final PersistenceDateOperatorRenderer INSTANCE = new PersistenceDateOperatorRenderer();

    private PersistenceDateOperatorRenderer() {
    }

    @Override
    public boolean render(ChainingArithmeticExpression e, PersistenceExpressionSerializer serializer) {
        DomainOperator domainOperator = e.getOperator().getDomainOperator();
        if (domainOperator == DomainOperator.PLUS || domainOperator == DomainOperator.MINUS) {
            int factor = domainOperator == DomainOperator.PLUS ? 1 : -1;
            ArithmeticExpression expression = null;
            TemporalInterval interval = null;
            StringBuilder sb = serializer.getStringBuilder();
            if (e.getLeft() instanceof Literal) {
                if (domainOperator == DomainOperator.PLUS) {
                    expression = e.getRight();
                    interval = (TemporalInterval)((Literal)e.getLeft()).getValue();
                }
            } else if (e.getRight() instanceof Literal) {
                expression = e.getLeft();
                interval = (TemporalInterval)((Literal)e.getRight()).getValue();
            }
            if (interval != null) {
                if (interval.getYears() != 0) {
                    sb.append("ADD_YEAR(");
                }
                if (interval.getMonths() != 0) {
                    sb.append("ADD_MONTH(");
                }
                if (interval.getDays() != 0) {
                    sb.append("ADD_DAY(");
                }
                boolean isConstant = (Boolean)expression.accept((Expression.ResultVisitor)serializer);
                if (interval.getYears() != 0) {
                    sb.append(", ");
                    sb.append(interval.getYears() * factor).append(')');
                }
                if (interval.getMonths() != 0) {
                    sb.append(", ");
                    sb.append(interval.getMonths() * factor).append(')');
                }
                if (interval.getDays() != 0) {
                    sb.append(", ");
                    sb.append(interval.getDays() * factor).append(')');
                }
                return isConstant;
            }
        }
        throw new DomainModelException("Can't handle the operator " + domainOperator + " for the arguments [" + e.getLeft() + ", " + e.getRight() + "]!");
    }
}

