/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.persistence;

import com.blazebit.domain.runtime.model.DomainFunctionArgument;
import com.blazebit.domain.runtime.model.DomainFunctionVolatility;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.domain.runtime.model.EntityDomainTypeAttribute;
import com.blazebit.expression.ArithmeticExpression;
import com.blazebit.expression.ArithmeticFactor;
import com.blazebit.expression.BetweenPredicate;
import com.blazebit.expression.ChainingArithmeticExpression;
import com.blazebit.expression.CollectionLiteral;
import com.blazebit.expression.ComparisonPredicate;
import com.blazebit.expression.CompoundPredicate;
import com.blazebit.expression.DomainModelException;
import com.blazebit.expression.EntityLiteral;
import com.blazebit.expression.EnumLiteral;
import com.blazebit.expression.Expression;
import com.blazebit.expression.ExpressionInterpreter;
import com.blazebit.expression.ExpressionPredicate;
import com.blazebit.expression.ExpressionSerializer;
import com.blazebit.expression.ExpressionService;
import com.blazebit.expression.FunctionInvocation;
import com.blazebit.expression.InPredicate;
import com.blazebit.expression.IsEmptyPredicate;
import com.blazebit.expression.IsNullPredicate;
import com.blazebit.expression.Literal;
import com.blazebit.expression.Path;
import com.blazebit.expression.Predicate;
import com.blazebit.expression.persistence.PersistenceCorrelationRenderer;
import com.blazebit.expression.persistence.PersistenceDomainFunctionArgumentRenderers;
import com.blazebit.expression.persistence.PersistenceDomainOperatorRenderer;
import com.blazebit.expression.persistence.PersistenceExpressionRenderer;
import com.blazebit.expression.persistence.PersistenceFunctionRenderer;
import com.blazebit.expression.persistence.PersistenceLiteralRenderer;
import com.blazebit.expression.persistence.PersistenceSubqueryProvider;
import com.blazebit.expression.spi.DefaultResolvedLiteral;
import com.blazebit.expression.spi.ResolvedLiteral;
import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.WhereBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PersistenceExpressionSerializer
implements Expression.ResultVisitor<Boolean>,
ExpressionSerializer<WhereBuilder<?>> {
    public static final String CONSTANT_INLINING_INTERPRETER_CONTEXT = "persistence.constant_inlining_interpreter_context";
    public static final String PATHS_TO_INLINE = "persistence.paths_to_inline";
    private static final String SUBQUERY_PREFIX = "_expr_subquery_";
    private static final String CORRELATION_ALIAS_PREFIX = "_expr_correlation_";
    private final ExpressionService expressionService;
    private final StringBuilder tempSb;
    private final Map<String, PersistenceSubqueryProvider> subqueryProviders;
    private final Map<Object, Object> properties;
    private int subqueryCount;
    private int correlationCount;
    private StringBuilder sb;
    private WhereBuilder<?> whereBuilder;
    private ExpressionSerializer.Context context;
    private ExpressionInterpreter interpreterForInlining;
    private ExpressionInterpreter.Context interpreterContextForInlining;
    private Set<String> pathsToInline;

    public PersistenceExpressionSerializer(ExpressionService expressionService) {
        this.expressionService = expressionService;
        this.tempSb = new StringBuilder();
        this.subqueryProviders = new HashMap<String, PersistenceSubqueryProvider>();
        this.properties = new HashMap<Object, Object>();
        this.sb = new StringBuilder();
    }

    public ExpressionService getExpressionService() {
        return this.expressionService;
    }

    public ExpressionSerializer.Context getContext() {
        return this.context;
    }

    public String registerSubqueryProvider(PersistenceSubqueryProvider persistenceSubqueryProvider) {
        String alias = SUBQUERY_PREFIX + this.subqueryCount++;
        this.subqueryProviders.put(alias, persistenceSubqueryProvider);
        return alias;
    }

    public String nextCorrelationAlias() {
        return CORRELATION_ALIAS_PREFIX + this.correlationCount++;
    }

    public Map<Object, Object> getProperties() {
        return this.properties;
    }

    public StringBuilder getStringBuilder() {
        return this.sb;
    }

    public WhereBuilder<?> getWhereBuilder() {
        return this.whereBuilder;
    }

    public void serializeTo(Expression expression, WhereBuilder<?> target) {
        this.serializeTo((ExpressionSerializer.Context)null, expression, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeTo(ExpressionSerializer.Context newContext, Expression expression, WhereBuilder<?> target) {
        Object pathsToInline;
        Object constantInliningInterpreterContext;
        WhereBuilder<?> old = this.whereBuilder;
        ExpressionSerializer.Context oldContext = this.context;
        ExpressionInterpreter.Context oldInterpreterContextForInlining = this.interpreterContextForInlining;
        Set<String> oldPathsToInline = this.pathsToInline;
        this.whereBuilder = target;
        this.context = newContext;
        if (newContext == null) {
            constantInliningInterpreterContext = null;
            pathsToInline = null;
        } else {
            constantInliningInterpreterContext = newContext.getContextParameter(CONSTANT_INLINING_INTERPRETER_CONTEXT);
            pathsToInline = newContext.getContextParameter(PATHS_TO_INLINE);
        }
        if (constantInliningInterpreterContext == null) {
            this.interpreterContextForInlining = null;
        } else if (constantInliningInterpreterContext instanceof ExpressionInterpreter.Context) {
            this.interpreterContextForInlining = (ExpressionInterpreter.Context)constantInliningInterpreterContext;
        } else {
            throw new IllegalArgumentException("Illegal value given for 'persistence.constant_inlining_interpreter_context'. Expected ExpressionInterpreter.Context but got: " + constantInliningInterpreterContext);
        }
        if (pathsToInline == null) {
            this.pathsToInline = null;
        } else if (pathsToInline instanceof Set) {
            this.pathsToInline = (Set)pathsToInline;
        } else {
            throw new IllegalArgumentException("Illegal value given for 'persistence.paths_to_inline'. Expected Set<String> but got: " + pathsToInline);
        }
        try {
            this.sb.setLength(0);
            expression.accept((Expression.ResultVisitor)this);
            MultipleSubqueryInitiator multiSubqueryInitiator = target.whereExpressionSubqueries(this.sb.toString());
            for (Map.Entry<String, PersistenceSubqueryProvider> entry : this.subqueryProviders.entrySet()) {
                entry.getValue().createSubquery(multiSubqueryInitiator.with(entry.getKey()));
            }
            multiSubqueryInitiator.end();
        }
        finally {
            this.whereBuilder = old;
            this.context = oldContext;
            this.interpreterContextForInlining = oldInterpreterContextForInlining;
            this.pathsToInline = oldPathsToInline;
        }
    }

    private Boolean inlineIfConstant(Expression expression, int startIndex, boolean constant) {
        if (!constant || this.interpreterContextForInlining == null) {
            return Boolean.FALSE;
        }
        ExpressionInterpreter interpreter = this.interpreterForInlining;
        if (interpreter == null) {
            interpreter = this.interpreterForInlining = this.expressionService.createInterpreter();
        }
        try {
            Object value = interpreter.evaluateAsModelType(expression, this.interpreterContextForInlining);
            this.sb.setLength(startIndex);
            this.visit(new Literal((ResolvedLiteral)new DefaultResolvedLiteral(expression.getType(), value)));
            return Boolean.TRUE;
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Could not inline expression '" + expression + "'", ex);
        }
    }

    public Boolean visit(FunctionInvocation e) {
        int startIndex = this.sb.length();
        PersistenceFunctionRenderer renderer = (PersistenceFunctionRenderer)e.getFunction().getMetadata(PersistenceFunctionRenderer.class);
        if (renderer == null) {
            if (this.interpreterContextForInlining != null) {
                return this.inlineIfConstant((Expression)e, startIndex, true);
            }
            throw new IllegalStateException("The domain function '" + e.getFunction().getName() + "' has no registered persistence function renderer!");
        }
        Map arguments = e.getArguments();
        if (arguments.isEmpty()) {
            renderer.render(e.getFunction(), e.getType(), PersistenceDomainFunctionArgumentRenderers.EMPTY, this.sb, this);
            return this.inlineIfConstant((Expression)e, startIndex, e.getFunction().getVolatility() != DomainFunctionVolatility.VOLATILE);
        }
        int size = e.getFunction().getArguments().size();
        Expression[] expressions = new Expression[size];
        for (Map.Entry entry : arguments.entrySet()) {
            Expression expression;
            DomainFunctionArgument domainFunctionArgument = (DomainFunctionArgument)entry.getKey();
            expressions[domainFunctionArgument.getPosition()] = expression = (Expression)entry.getValue();
        }
        DefaultPersistenceDomainFunctionArgumentRenderers argumentRenderers = new DefaultPersistenceDomainFunctionArgumentRenderers(expressions, arguments.size());
        renderer.render(e.getFunction(), e.getType(), argumentRenderers, this.sb, this);
        return this.inlineIfConstant((Expression)e, startIndex, argumentRenderers.isAllArgumentsConstant() && e.getFunction().getVolatility() != DomainFunctionVolatility.VOLATILE);
    }

    public Boolean visit(Literal e) {
        if (e.getType().getKind() == DomainType.DomainTypeKind.COLLECTION) {
            Collection expressions = (Collection)e.getValue();
            if (expressions != null && !expressions.isEmpty()) {
                for (Expression expression : expressions) {
                    expression.accept((Expression.ResultVisitor)this);
                    this.sb.append(", ");
                }
                this.sb.setLength(this.sb.length() - 2);
            }
        } else {
            Object value = e.getValue();
            PersistenceLiteralRenderer literalRenderer = (PersistenceLiteralRenderer)e.getType().getMetadata(PersistenceLiteralRenderer.class);
            if (literalRenderer != null) {
                literalRenderer.render(value, e.getType(), this);
            } else {
                this.sb.append(value);
            }
        }
        return Boolean.TRUE;
    }

    public Boolean visit(EnumLiteral e) {
        return this.visit((Literal)e);
    }

    public Boolean visit(EntityLiteral e) {
        return this.visit((Literal)e);
    }

    public Boolean visit(CollectionLiteral e) {
        return this.visit((Literal)e);
    }

    public Boolean visit(Path e) {
        int startIndex = this.sb.length();
        boolean isConstant = true;
        this.tempSb.setLength(0);
        if (e.getBase() == null) {
            String persistenceAlias = this.getPersistenceAlias(e);
            if (persistenceAlias == null) {
                if (this.interpreterContextForInlining != null) {
                    return this.inlineIfConstant((Expression)e, startIndex, true);
                }
                throw new IllegalStateException("The domain root object alias '" + e.getAlias() + "' has no registered persistence alias!");
            }
            this.tempSb.append(persistenceAlias);
        } else {
            StringBuilder old = this.sb;
            this.sb = this.tempSb;
            isConstant = (Boolean)e.getBase().accept((Expression.ResultVisitor)this);
            this.sb = old;
        }
        List attributes = e.getAttributes();
        if (this.pathsToInline == null || e.getAlias() == null) {
            for (int i = 0; i < attributes.size(); ++i) {
                EntityDomainTypeAttribute attribute = (EntityDomainTypeAttribute)attributes.get(i);
                if (!this.appendPersistenceAttribute(this.tempSb, attribute)) continue;
                if (this.interpreterContextForInlining != null) {
                    this.tempSb.setLength(0);
                    if (isConstant) {
                        return this.inlineIfConstant((Expression)e, startIndex, true);
                    }
                }
                throw new IllegalStateException("The domain attribute '" + attribute.getOwner().getName() + "." + attribute.getName() + "' has no registered ExpressionRenderer or CorrelationRenderer metadata!");
            }
        } else {
            StringBuilder pathSb = new StringBuilder();
            pathSb.append(e.getAlias());
            for (int i = 0; i < attributes.size(); ++i) {
                EntityDomainTypeAttribute attribute = (EntityDomainTypeAttribute)attributes.get(i);
                pathSb.append('.').append(attribute.getName());
                if (!this.appendPersistenceAttribute(this.tempSb, attribute)) continue;
                if (this.interpreterContextForInlining != null) {
                    this.tempSb.setLength(0);
                    if (isConstant) {
                        return this.inlineIfConstant((Expression)e, startIndex, true);
                    }
                }
                throw new IllegalStateException("The domain attribute '" + attribute.getOwner().getName() + "." + attribute.getName() + "' has no registered ExpressionRenderer or CorrelationRenderer metadata!");
            }
            if (this.pathsToInline.contains(pathSb.toString())) {
                this.tempSb.setLength(0);
                return this.inlineIfConstant((Expression)e, startIndex, true);
            }
        }
        this.sb.append((CharSequence)this.tempSb);
        this.tempSb.setLength(0);
        return isConstant;
    }

    protected boolean appendPersistenceAttribute(StringBuilder sb, EntityDomainTypeAttribute attribute) {
        PersistenceExpressionRenderer metadata = (PersistenceExpressionRenderer)attribute.getMetadata(PersistenceExpressionRenderer.class);
        if (metadata != null) {
            metadata.render(sb, this);
        } else {
            PersistenceCorrelationRenderer persistenceCorrelationRenderer = (PersistenceCorrelationRenderer)attribute.getMetadata(PersistenceCorrelationRenderer.class);
            if (persistenceCorrelationRenderer != null) {
                String parent = sb.toString();
                sb.setLength(0);
                sb.append(persistenceCorrelationRenderer.correlate((CriteriaBuilder)this.whereBuilder, parent, this));
            } else {
                return true;
            }
        }
        return false;
    }

    protected String getPersistenceAlias(Path p) {
        String alias = p.getAlias();
        Object o = this.context.getContextParameter(alias);
        if (o instanceof String) {
            return (String)o;
        }
        Object type = p.getAttributes().isEmpty() ? p.getType() : ((EntityDomainTypeAttribute)p.getAttributes().get(0)).getOwner();
        PersistenceCorrelationRenderer persistenceCorrelationRenderer = (PersistenceCorrelationRenderer)type.getMetadata(PersistenceCorrelationRenderer.class);
        if (persistenceCorrelationRenderer != null) {
            return persistenceCorrelationRenderer.correlate((CriteriaBuilder)this.whereBuilder, null, this);
        }
        return null;
    }

    public Boolean visit(ArithmeticFactor e) {
        int startIndex = this.sb.length();
        if (e.isInvertSignum()) {
            this.sb.append('-');
        }
        return this.inlineIfConstant((Expression)e, startIndex, (Boolean)e.getExpression().accept((Expression.ResultVisitor)this));
    }

    public Boolean visit(ExpressionPredicate e) {
        PersistenceFunctionRenderer persistenceFunctionRenderer;
        int startIndex = this.sb.length();
        boolean negated = e.isNegated();
        if (negated) {
            this.sb.append("NOT(");
        }
        boolean isConstant = (Boolean)e.getExpression().accept((Expression.ResultVisitor)this);
        if (e.getExpression() instanceof FunctionInvocation && !(persistenceFunctionRenderer = (PersistenceFunctionRenderer)((FunctionInvocation)e.getExpression()).getFunction().getMetadata(PersistenceFunctionRenderer.class)).rendersPredicate()) {
            this.sb.append(" = TRUE");
        }
        if (negated) {
            this.sb.append(')');
        }
        return this.inlineIfConstant((Expression)e, startIndex, isConstant);
    }

    public Boolean visit(ChainingArithmeticExpression e) {
        int startIndex = this.sb.length();
        PersistenceDomainOperatorRenderer operatorRenderer = (PersistenceDomainOperatorRenderer)e.getType().getMetadata(PersistenceDomainOperatorRenderer.class);
        return this.inlineIfConstant((Expression)e, startIndex, operatorRenderer.render(e, this));
    }

    public Boolean visit(BetweenPredicate e) {
        int startIndex = this.sb.length();
        boolean negated = e.isNegated();
        if (negated) {
            this.sb.append("NOT(");
        }
        boolean isConstant = (Boolean)e.getLeft().accept((Expression.ResultVisitor)this);
        this.sb.append(" BETWEEN ");
        isConstant = (Boolean)e.getLower().accept((Expression.ResultVisitor)this) != false && isConstant;
        this.sb.append(" AND ");
        boolean bl = isConstant = (Boolean)e.getUpper().accept((Expression.ResultVisitor)this) != false && isConstant;
        if (negated) {
            this.sb.append(')');
        }
        return this.inlineIfConstant((Expression)e, startIndex, isConstant);
    }

    public Boolean visit(InPredicate e) {
        int startIndex = this.sb.length();
        boolean isConstant = (Boolean)e.getLeft().accept((Expression.ResultVisitor)this);
        if (e.isNegated()) {
            this.sb.append(" NOT");
        }
        this.sb.append(" IN ");
        if (e.getInItems().size() == 1 && e.getInItems().get(0) instanceof Path) {
            isConstant = (Boolean)((ArithmeticExpression)e.getInItems().get(0)).accept((Expression.ResultVisitor)this) != false && isConstant;
        } else {
            this.sb.append('(');
            for (ArithmeticExpression inItem : e.getInItems()) {
                isConstant = (Boolean)inItem.accept((Expression.ResultVisitor)this) != false && isConstant;
                this.sb.append(", ");
            }
            this.sb.setLength(this.sb.length() - 2);
            this.sb.append(')');
        }
        return this.inlineIfConstant((Expression)e, startIndex, isConstant);
    }

    public Boolean visit(CompoundPredicate e) {
        boolean isConstant;
        int startIndex = this.sb.length();
        boolean negated = e.isNegated();
        if (negated) {
            this.sb.append("NOT(");
        }
        List predicates = e.getPredicates();
        int size = predicates.size();
        Predicate predicate = (Predicate)predicates.get(0);
        if (predicate instanceof CompoundPredicate && e.isConjunction() != ((CompoundPredicate)predicate).isConjunction()) {
            this.sb.append('(');
            isConstant = (Boolean)predicate.accept((Expression.ResultVisitor)this);
            this.sb.append(')');
        } else {
            isConstant = (Boolean)predicate.accept((Expression.ResultVisitor)this);
        }
        String connector = e.isConjunction() ? " AND " : " OR ";
        for (int i = 1; i < size; ++i) {
            predicate = (Predicate)predicates.get(i);
            this.sb.append(connector);
            if (predicate instanceof CompoundPredicate && !predicate.isNegated() && e.isConjunction() != ((CompoundPredicate)predicate).isConjunction()) {
                this.sb.append('(');
                isConstant = (Boolean)predicate.accept((Expression.ResultVisitor)this) != false && isConstant;
                this.sb.append(')');
                continue;
            }
            isConstant = (Boolean)predicate.accept((Expression.ResultVisitor)this) != false && isConstant;
        }
        if (negated) {
            this.sb.append(')');
        }
        return this.inlineIfConstant((Expression)e, startIndex, isConstant);
    }

    public Boolean visit(ComparisonPredicate e) {
        int startIndex = this.sb.length();
        boolean negated = e.isNegated();
        if (negated) {
            this.sb.append("NOT(");
        }
        boolean isConstant = (Boolean)e.getLeft().accept((Expression.ResultVisitor)this);
        this.sb.append(' ');
        this.sb.append(e.getOperator().getOperator());
        this.sb.append(' ');
        boolean bl = isConstant = (Boolean)e.getRight().accept((Expression.ResultVisitor)this) != false && isConstant;
        if (negated) {
            this.sb.append(')');
        }
        return this.inlineIfConstant((Expression)e, startIndex, isConstant);
    }

    public Boolean visit(IsNullPredicate e) {
        int startIndex = this.sb.length();
        boolean isConstant = (Boolean)e.getLeft().accept((Expression.ResultVisitor)this);
        this.sb.append(" IS ");
        if (e.isNegated()) {
            this.sb.append("NOT ");
        }
        this.sb.append("NULL");
        return this.inlineIfConstant((Expression)e, startIndex, isConstant);
    }

    public Boolean visit(IsEmptyPredicate e) {
        int startIndex = this.sb.length();
        boolean isConstant = (Boolean)e.getLeft().accept((Expression.ResultVisitor)this);
        this.sb.append(" IS ");
        if (e.isNegated()) {
            this.sb.append("NOT ");
        }
        this.sb.append("EMPTY");
        return this.inlineIfConstant((Expression)e, startIndex, isConstant);
    }

    private final class DefaultPersistenceDomainFunctionArgumentRenderers
    implements PersistenceDomainFunctionArgumentRenderers {
        private final Expression[] expressions;
        private final int assignedArguments;
        private boolean allArgumentsConstant = true;

        public DefaultPersistenceDomainFunctionArgumentRenderers(Expression[] expressions, int assignedArguments) {
            this.expressions = expressions;
            this.assignedArguments = assignedArguments;
        }

        public boolean isAllArgumentsConstant() {
            return this.allArgumentsConstant;
        }

        @Override
        public Expression getExpression(int position) {
            try {
                return this.expressions[position];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new DomainModelException((Throwable)ex);
            }
        }

        @Override
        public DomainType getType(int position) {
            try {
                return this.expressions[position].getType();
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new DomainModelException((Throwable)ex);
            }
            catch (NullPointerException ex) {
                return null;
            }
        }

        @Override
        public int assignedArguments() {
            return this.assignedArguments;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean renderArgument(StringBuilder sb, int position) {
            StringBuilder oldSb = PersistenceExpressionSerializer.this.sb;
            PersistenceExpressionSerializer.this.sb = sb;
            try {
                if (((Boolean)this.expressions[position].accept((Expression.ResultVisitor)PersistenceExpressionSerializer.this)).booleanValue()) {
                    boolean bl = true;
                    return bl;
                }
                this.allArgumentsConstant = false;
                boolean bl = false;
                return bl;
            }
            finally {
                PersistenceExpressionSerializer.this.sb = oldSb;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void renderArguments(StringBuilder sb) {
            if (this.assignedArguments != 0) {
                StringBuilder oldSb = PersistenceExpressionSerializer.this.sb;
                PersistenceExpressionSerializer.this.sb = sb;
                try {
                    for (int i = 0; i < this.assignedArguments; ++i) {
                        if (!((Boolean)this.expressions[i].accept((Expression.ResultVisitor)PersistenceExpressionSerializer.this)).booleanValue()) {
                            this.allArgumentsConstant = false;
                        }
                        sb.append(", ");
                    }
                    sb.setLength(sb.length() - 2);
                }
                finally {
                    PersistenceExpressionSerializer.this.sb = oldSb;
                }
            }
        }
    }
}

