/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.persistence;

import com.blazebit.domain.runtime.model.DomainFunction;
import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.DomainModelException;
import com.blazebit.expression.base.GlobalStringlyTypeDestructorFunctionInvoker;
import com.blazebit.expression.base.StringlyTypeHandler;
import com.blazebit.expression.persistence.PersistenceDomainFunctionArgumentRenderers;
import com.blazebit.expression.persistence.PersistenceExpressionSerializer;
import com.blazebit.expression.persistence.PersistenceFunctionRenderer;
import com.blazebit.expression.persistence.PersistenceStringlyTypeHandler;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class PersistenceGlobalStringlyTypeDestructorFunctionRenderer
implements PersistenceFunctionRenderer,
Serializable {
    final Map<String, PersistenceStringlyTypeHandler> destructors = new ConcurrentHashMap<String, PersistenceStringlyTypeHandler>();
    private final GlobalStringlyTypeDestructorFunctionInvoker functionInvoker;
    private final String name;

    public PersistenceGlobalStringlyTypeDestructorFunctionRenderer(GlobalStringlyTypeDestructorFunctionInvoker functionInvoker, String name) {
        this.functionInvoker = functionInvoker;
        this.name = name;
    }

    public PersistenceStringlyTypeHandler getHandler(String typeName) {
        return this.destructors.get(typeName);
    }

    @Override
    public void render(DomainFunction function, DomainType returnType, PersistenceDomainFunctionArgumentRenderers argumentRenderers, StringBuilder sb, PersistenceExpressionSerializer serializer) {
        String argumentTypeName = argumentRenderers.getType(0).getName();
        PersistenceStringlyTypeHandler persistenceStringlyTypeHandler = this.destructors.get(argumentTypeName);
        if (persistenceStringlyTypeHandler == null) {
            StringlyTypeHandler handler = this.functionInvoker.getHandler(argumentTypeName);
            if (handler == null) {
                throw new DomainModelException("Unsupported type for destructure function " + this.name + " function: " + argumentTypeName);
            }
            persistenceStringlyTypeHandler = PersistenceStringlyTypeHandler.INSTANCE;
        }
        persistenceStringlyTypeHandler.appendPersistenceDestructTo(sb, subBuilder -> argumentRenderers.renderArgument((StringBuilder)subBuilder, 0));
    }
}

