/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.persistence;

import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.persistence.PersistenceExpressionSerializer;
import com.blazebit.expression.persistence.PersistenceLiteralRenderer;
import java.io.Serializable;
import java.time.LocalTime;

public class PersistenceTimeLiteralRenderer
implements PersistenceLiteralRenderer,
Serializable {
    public static final PersistenceTimeLiteralRenderer INSTANCE = new PersistenceTimeLiteralRenderer();

    private PersistenceTimeLiteralRenderer() {
    }

    @Override
    public void render(Object value, DomainType domainType, PersistenceExpressionSerializer serializer) {
        LocalTime localTime = (LocalTime)value;
        StringBuilder sb = serializer.getStringBuilder();
        sb.append("{t '");
        if (localTime.getHour() < 10) {
            sb.append('0');
        }
        sb.append(localTime.getHour());
        sb.append(':');
        if (localTime.getMinute() < 10) {
            sb.append('0');
        }
        sb.append(localTime.getMinute());
        sb.append(':');
        if (localTime.getSecond() < 10) {
            sb.append('0');
        }
        sb.append(localTime.getSecond());
        int nano = localTime.getNano();
        if ((long)nano != 0L) {
            sb.append('.');
            if (nano < 100000000) {
                sb.append('0');
                if (nano < 10000000) {
                    sb.append('0');
                    if (nano < 1000000) {
                        sb.append('0');
                        if (nano < 100000) {
                            sb.append('0');
                            if (nano < 10000) {
                                sb.append('0');
                                if (nano < 1000) {
                                    sb.append('0');
                                    if (nano < 100) {
                                        sb.append('0');
                                        if (nano < 10) {
                                            sb.append('0');
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            sb.append(nano);
        }
        sb.append("'}");
    }
}

