/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.expression.persistence;

import com.blazebit.domain.runtime.model.DomainType;
import com.blazebit.expression.persistence.PersistenceExpressionSerializer;
import com.blazebit.expression.persistence.PersistenceLiteralRenderer;
import java.io.Serializable;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class PersistenceTimestampLiteralRenderer
implements PersistenceLiteralRenderer,
Serializable {
    public static final PersistenceTimestampLiteralRenderer INSTANCE = new PersistenceTimestampLiteralRenderer();

    private PersistenceTimestampLiteralRenderer() {
    }

    @Override
    public void render(Object value, DomainType domainType, PersistenceExpressionSerializer serializer) {
        Instant instant = (Instant)value;
        StringBuilder sb = serializer.getStringBuilder();
        OffsetDateTime offsetDateTime = instant.atOffset(ZoneOffset.UTC);
        sb.append("{ts '");
        sb.append(offsetDateTime.getYear());
        sb.append('-');
        if (offsetDateTime.getMonthValue() < 10) {
            sb.append('0');
        }
        sb.append(offsetDateTime.getMonthValue());
        sb.append('-');
        if (offsetDateTime.getDayOfMonth() < 10) {
            sb.append('0');
        }
        sb.append(offsetDateTime.getDayOfMonth());
        sb.append(' ');
        if (offsetDateTime.getHour() < 10) {
            sb.append('0');
        }
        sb.append(offsetDateTime.getHour());
        sb.append(':');
        if (offsetDateTime.getMinute() < 10) {
            sb.append('0');
        }
        sb.append(offsetDateTime.getMinute());
        sb.append(':');
        if (offsetDateTime.getSecond() < 10) {
            sb.append('0');
        }
        sb.append(offsetDateTime.getSecond());
        int nano = offsetDateTime.getNano();
        if ((long)nano != 0L) {
            sb.append('.');
            if (nano < 100000000) {
                sb.append('0');
                if (nano < 10000000) {
                    sb.append('0');
                    if (nano < 1000000) {
                        sb.append('0');
                        if (nano < 100000) {
                            sb.append('0');
                            if (nano < 10000) {
                                sb.append('0');
                                if (nano < 1000) {
                                    sb.append('0');
                                    if (nano < 100) {
                                        sb.append('0');
                                        if (nano < 10) {
                                            sb.append('0');
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            sb.append(nano);
        }
        sb.append("'}");
    }
}

