/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spi;

import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.JpqlFunctionKind;
import com.blazebit.persistence.spi.JpqlFunctionProcessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class JpqlFunctionGroup {
    private final String name;
    private final JpqlFunctionKind kind;
    private final Map<String, JpqlFunction> rdbmsFunctions;

    public JpqlFunctionGroup(String name) {
        this(name, false);
    }

    public JpqlFunctionGroup(String name, JpqlFunction defaultFunction) {
        this(name, false);
        this.add(null, defaultFunction);
    }

    public JpqlFunctionGroup(String name, boolean aggregate) {
        this(name, aggregate, (Map<String, JpqlFunction>)Collections.EMPTY_MAP);
    }

    public JpqlFunctionGroup(String name, boolean aggregate, Map<String, JpqlFunction> rdbmsFunctions) {
        this(name, aggregate ? JpqlFunctionKind.AGGREGATE : JpqlFunctionKind.DETERMINISTIC, rdbmsFunctions);
    }

    public JpqlFunctionGroup(String name, JpqlFunctionKind kind) {
        this(name, kind, (Map<String, JpqlFunction>)Collections.EMPTY_MAP);
    }

    public JpqlFunctionGroup(String name, JpqlFunctionKind kind, Map<String, JpqlFunction> rdbmsFunctions) {
        this.name = name;
        this.kind = kind;
        this.rdbmsFunctions = new HashMap<String, JpqlFunction>(rdbmsFunctions);
    }

    public String getName() {
        return this.name;
    }

    public boolean isAggregate() {
        return this.kind == JpqlFunctionKind.AGGREGATE;
    }

    public JpqlFunctionKind getKind() {
        return this.kind;
    }

    public JpqlFunction get(String rdbms) {
        return this.rdbmsFunctions.get(rdbms);
    }

    public JpqlFunctionProcessor<?> getProcessor(String rdbms) {
        JpqlFunction jpqlFunction = this.rdbmsFunctions.get(rdbms);
        if (jpqlFunction instanceof JpqlFunctionProcessor) {
            return (JpqlFunctionProcessor)((Object)jpqlFunction);
        }
        return null;
    }

    public boolean contains(String rdbms) {
        return this.rdbmsFunctions.containsKey(rdbms);
    }

    public void add(String rdbms, JpqlFunction function) {
        this.rdbmsFunctions.put(rdbms, function);
    }
}

