/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence;

import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.PagedList;
import java.util.ArrayList;
import java.util.Collection;

public class PagedArrayList<T>
extends ArrayList<T>
implements PagedList<T> {
    private static final long serialVersionUID = 1L;
    private final KeysetPage keyset;
    private final long totalSize;
    private final int page;
    private final int totalPages;
    private final int firstResult;
    private final int maxResults;

    public PagedArrayList(KeysetPage keyset, long totalSize, int firstResult, int maxResults) {
        this.keyset = keyset;
        this.totalSize = totalSize;
        this.page = (int)Math.floor((double)(firstResult == -1 ? 0 : firstResult) * 1.0 / (double)maxResults) + 1;
        this.totalPages = totalSize < 1L ? 0 : (int)Math.ceil((double)totalSize * 1.0 / (double)maxResults);
        this.firstResult = firstResult;
        this.maxResults = maxResults;
    }

    public PagedArrayList(Collection<? extends T> collection, KeysetPage keyset, long totalSize, int firstResult, int maxResults) {
        super(collection);
        this.keyset = keyset;
        this.totalSize = totalSize;
        this.page = (int)Math.floor((double)(firstResult == -1 ? 0 : firstResult) * 1.0 / (double)maxResults) + 1;
        this.totalPages = totalSize < 1L ? 0 : (int)Math.ceil((double)totalSize * 1.0 / (double)maxResults);
        this.firstResult = firstResult;
        this.maxResults = maxResults;
    }

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public int getTotalPages() {
        return this.totalPages;
    }

    @Override
    public int getFirstResult() {
        return this.firstResult;
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public KeysetPage getKeysetPage() {
        return this.keyset;
    }
}

