/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.TreatedJoinAliasInfo;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArithmeticFactor;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.LiteralExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.SimpleCaseExpression;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TrimExpression;
import com.blazebit.persistence.parser.expression.TypeFunctionExpression;
import com.blazebit.persistence.parser.expression.VisitorAdapter;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.predicate.BetweenPredicate;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.GePredicate;
import com.blazebit.persistence.parser.predicate.GtPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.LePredicate;
import com.blazebit.persistence.parser.predicate.LikePredicate;
import com.blazebit.persistence.parser.predicate.LtPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ConstantifiedJoinNodeAttributeCollector
extends VisitorAdapter {
    private static final String KEY_FUNCTION = "key()";
    private final EntityMetamodel metamodel;
    private final AliasManager aliasManager;
    private Map<Object, Map<String, Boolean>> constantifiedJoinNodeAttributes;
    private Set<CompoundPredicate> analyzedPredicates;
    private JoinNode firstRootNode;
    private boolean innerJoin;
    private boolean negated;
    private boolean inKey;

    public ConstantifiedJoinNodeAttributeCollector(EntityMetamodel metamodel, AliasManager aliasManager) {
        this.metamodel = metamodel;
        this.aliasManager = aliasManager;
        this.constantifiedJoinNodeAttributes = new HashMap<Object, Map<String, Boolean>>();
        this.analyzedPredicates = Collections.newSetFromMap(new IdentityHashMap());
    }

    public void reset() {
        this.analyzedPredicates.clear();
        this.firstRootNode = null;
        this.innerJoin = false;
        this.negated = false;
        this.constantifiedJoinNodeAttributes.clear();
    }

    public void collectConstantifiedJoinNodeAttributes(CompoundPredicate rootPredicate, JoinNode firstRootNode, boolean innerJoin) {
        if (!this.analyzedPredicates.add(rootPredicate)) {
            return;
        }
        this.firstRootNode = firstRootNode;
        this.innerJoin = innerJoin;
        rootPredicate.accept((Expression.Visitor)this);
    }

    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    public Map<Object, Map<String, Boolean>> getConstantifiedJoinNodeAttributes() {
        return this.constantifiedJoinNodeAttributes;
    }

    public boolean isConstantified(JoinNode node) {
        if (node.isTreatedJoinNode()) {
            node = ((TreatedJoinAliasInfo)node.getAliasInfo()).getTreatedJoinNode();
        }
        if (node == this.firstRootNode) {
            return true;
        }
        Map<String, Boolean> constantifiedAttributes = this.constantifiedJoinNodeAttributes.get(node);
        if (constantifiedAttributes == null) {
            return false;
        }
        if (constantifiedAttributes.containsKey(KEY_FUNCTION)) {
            return true;
        }
        ExtendedManagedType extendedManagedType = (ExtendedManagedType)this.metamodel.getManagedType(ExtendedManagedType.class, node.getManagedType());
        if (extendedManagedType.getIdAttributes().isEmpty()) {
            for (ExtendedAttribute attribute : extendedManagedType.getAttributes().values()) {
                if (!(attribute.getAttribute() instanceof SingularAttribute) || constantifiedAttributes.containsKey(attribute.getAttributePathString())) continue;
                return false;
            }
        } else {
            for (SingularAttribute idAttribute : extendedManagedType.getIdAttributes()) {
                if (constantifiedAttributes.containsKey(idAttribute.getName())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isConstantifiedNonOptional(JoinNode node, String attributeName) {
        Map<String, Boolean> constantifiedAttributes = this.constantifiedJoinNodeAttributes.get(node);
        if (constantifiedAttributes == null) {
            return false;
        }
        return Boolean.TRUE.equals(constantifiedAttributes.containsKey(attributeName));
    }

    public void visit(PathExpression expr) {
        String prefix;
        Object baseNodeKey;
        PathReference pathReference = expr.getPathReference();
        if (pathReference == null) {
            ((SelectInfo)this.aliasManager.getAliasInfo(expr.toString())).getExpression().accept((Expression.Visitor)this);
            return;
        }
        JoinNode baseNode = (JoinNode)pathReference.getBaseNode();
        if (pathReference.getField() == null) {
            if (this.inKey) {
                HashMap<String, Boolean> attributes = new HashMap<String, Boolean>(1);
                attributes.put(KEY_FUNCTION, this.innerJoin);
                this.constantifiedJoinNodeAttributes.put(baseNode, attributes);
            } else if (baseNode.getType() instanceof ManagedType) {
                Map<String, Boolean> attributes = this.constantifiedJoinNodeAttributes.get(baseNode);
                if (attributes == null) {
                    attributes = new HashMap<String, Boolean>();
                    this.constantifiedJoinNodeAttributes.put(baseNode, attributes);
                }
                ExtendedManagedType managedType = (ExtendedManagedType)this.metamodel.getManagedType(ExtendedManagedType.class, baseNode.getManagedType());
                for (SingularAttribute idAttribute : managedType.getIdAttributes()) {
                    this.addAttribute("", idAttribute, attributes);
                }
            }
            return;
        }
        ExtendedManagedType managedType = (ExtendedManagedType)this.metamodel.getManagedType(ExtendedManagedType.class, baseNode.getManagedType());
        ExtendedAttribute extendedAttribute = managedType.getAttribute(pathReference.getField());
        Attribute attr = extendedAttribute.getAttribute();
        if (attr instanceof PluralAttribute) {
            if (this.inKey) {
                HashMap<String, Boolean> attributes = new HashMap<String, Boolean>(1);
                attributes.put(KEY_FUNCTION, this.innerJoin);
                this.constantifiedJoinNodeAttributes.put(baseNode, attributes);
            }
            return;
        }
        int dotIndex = expr.getField().lastIndexOf(46);
        SingularAttribute singularAttr = (SingularAttribute)attr;
        String associationName = this.getSingleValuedIdAccessAssociationName(pathReference.getField(), extendedAttribute);
        if (associationName == null) {
            baseNodeKey = baseNode;
            prefix = attr.getDeclaringType() instanceof EmbeddableType ? pathReference.getField().substring(0, dotIndex + 1) : "";
        } else {
            baseNodeKey = new AbstractMap.SimpleEntry<JoinNode, String>(baseNode, associationName);
            prefix = attr.getDeclaringType() instanceof EmbeddableType ? pathReference.getField().substring(associationName.length() + 1, dotIndex + 1) : "";
        }
        Map<String, Boolean> attributes = this.constantifiedJoinNodeAttributes.get(baseNodeKey);
        if (attributes == null) {
            attributes = new HashMap<String, Boolean>();
            this.constantifiedJoinNodeAttributes.put(baseNodeKey, attributes);
        }
        this.addAttribute(prefix, singularAttr, attributes);
        StringBuilder attributeNameBuilder = null;
        Map<String, Boolean> baseNodeAttributes = null;
        String associationNamePrefix = associationName == null ? "" : associationName + '.';
        HashMap<String, Boolean> newAttributes = new HashMap<String, Boolean>();
        for (Map.Entry<String, Boolean> entry : attributes.entrySet()) {
            String attribute = entry.getKey();
            if (attribute == KEY_FUNCTION) continue;
            for (ExtendedAttribute columnEquivalentAttribute : managedType.getAttribute(associationNamePrefix + attribute).getColumnEquivalentAttributes()) {
                String attributeName;
                List attributePath = columnEquivalentAttribute.getAttributePath();
                if (attributePath.size() == 1) {
                    attributeName = ((Attribute)attributePath.get(0)).getName();
                } else {
                    if (attributeNameBuilder == null) {
                        attributeNameBuilder = new StringBuilder();
                    } else {
                        attributeNameBuilder.setLength(0);
                    }
                    attributeNameBuilder.append(((Attribute)attributePath.get(0)).getName());
                    for (int i = 1; i < attributePath.size(); ++i) {
                        attributeNameBuilder.append('.');
                        attributeNameBuilder.append(((Attribute)attributePath.get(i)).getName());
                    }
                    attributeName = attributeNameBuilder.toString();
                }
                if (!associationNamePrefix.isEmpty() && !attributeName.startsWith(associationNamePrefix)) {
                    if (baseNodeAttributes == null && (baseNodeAttributes = this.constantifiedJoinNodeAttributes.get(baseNode)) == null) {
                        baseNodeAttributes = new HashMap<String, Boolean>();
                        this.constantifiedJoinNodeAttributes.put(baseNode, baseNodeAttributes);
                    }
                    baseNodeAttributes.put(attributeName, entry.getValue());
                    continue;
                }
                newAttributes.put(attributeName, entry.getValue());
            }
        }
        attributes.putAll(newAttributes);
    }

    private String getSingleValuedIdAccessAssociationName(String field, ExtendedAttribute<?, ?> attr) {
        List attributePath = attr.getAttributePath();
        if (!JpaMetamodelUtils.isAssociation((Attribute)attr.getAttribute()) && attributePath.size() > 1) {
            int endIndex = -1;
            for (Attribute attribute : attributePath) {
                endIndex += attribute.getName().length() + 1;
                if (attribute.isCollection()) {
                    return null;
                }
                if (!JpaMetamodelUtils.isAssociation((Attribute)attribute)) continue;
                return field.substring(0, endIndex);
            }
        }
        return null;
    }

    private void addAttribute(String prefix, SingularAttribute<?, ?> singularAttribute, Map<String, Boolean> orderedAttributes) {
        String attributeName = prefix.isEmpty() ? singularAttribute.getName() : prefix + singularAttribute.getName();
        if (singularAttribute.getType() instanceof EmbeddableType) {
            String newPrefix = attributeName + ".";
            for (SingularAttribute attribute : ((EmbeddableType)singularAttribute.getType()).getSingularAttributes()) {
                this.addAttribute(newPrefix, attribute, orderedAttributes);
            }
        } else {
            orderedAttributes.put(attributeName, this.innerJoin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(CompoundPredicate predicate) {
        block18: {
            boolean originNegated = this.negated;
            try {
                if (predicate.isNegated()) {
                    this.negated = !this.negated;
                }
                List children = predicate.getChildren();
                int size = children.size();
                if (this.negated == (predicate.getOperator() == CompoundPredicate.BooleanOperator.OR)) {
                    for (int i = 0; i < size; ++i) {
                        ((Predicate)children.get(i)).accept((Expression.Visitor)this);
                    }
                    break block18;
                }
                Map<Object, Map<String, Boolean>> oldConstantifiedJoinNodeAttributes = this.constantifiedJoinNodeAttributes;
                try {
                    this.constantifiedJoinNodeAttributes = new HashMap<Object, Map<String, Boolean>>();
                    HashMap<Object, Map<String, Boolean>> initialConstantifiedJoinNodeAttributes = this.constantifiedJoinNodeAttributes;
                    ((Predicate)children.get(0)).accept((Expression.Visitor)this);
                    this.constantifiedJoinNodeAttributes = new HashMap<Object, Map<String, Boolean>>();
                    for (int i = 1; i < size; ++i) {
                        if (initialConstantifiedJoinNodeAttributes.isEmpty()) {
                            return;
                        }
                        ((Predicate)children.get(i)).accept((Expression.Visitor)this);
                        Iterator entryIterator = initialConstantifiedJoinNodeAttributes.entrySet().iterator();
                        while (entryIterator.hasNext()) {
                            Map.Entry<Object, Map<String, Boolean>> entry = entryIterator.next();
                            Map<String, Boolean> nodeAttributes = this.constantifiedJoinNodeAttributes.get(entry.getKey());
                            if (nodeAttributes != null) {
                                Iterator<String> iterator = entry.getValue().keySet().iterator();
                                while (iterator.hasNext()) {
                                    if (nodeAttributes.containsKey(iterator.next())) continue;
                                    iterator.remove();
                                }
                                if (!entry.getValue().isEmpty()) continue;
                            }
                            entryIterator.remove();
                        }
                        this.constantifiedJoinNodeAttributes.clear();
                    }
                    this.constantifiedJoinNodeAttributes = initialConstantifiedJoinNodeAttributes;
                }
                finally {
                    for (Map.Entry<Object, Map<String, Boolean>> entry : this.constantifiedJoinNodeAttributes.entrySet()) {
                        Map<String, Boolean> attributes = oldConstantifiedJoinNodeAttributes.get(entry.getKey());
                        if (attributes == null) {
                            attributes = new HashMap<String, Boolean>();
                            oldConstantifiedJoinNodeAttributes.put(entry.getKey(), attributes);
                        }
                        attributes.putAll(entry.getValue());
                    }
                    this.constantifiedJoinNodeAttributes = oldConstantifiedJoinNodeAttributes;
                }
            }
            finally {
                this.negated = originNegated;
            }
        }
    }

    public void visit(EqPredicate predicate) {
        boolean originNegated = this.negated;
        try {
            if (predicate.isNegated()) {
                boolean bl = this.negated = !this.negated;
            }
            if (this.negated) {
                return;
            }
            if (this.isConstant(predicate.getLeft())) {
                if (ConstantifiedJoinNodeAttributeCollector.isParameterOrLiteral(predicate.getRight())) {
                    predicate.getLeft().accept((Expression.Visitor)this);
                } else {
                    predicate.getRight().accept((Expression.Visitor)this);
                }
            } else if (this.isConstant(predicate.getRight())) {
                if (ConstantifiedJoinNodeAttributeCollector.isParameterOrLiteral(predicate.getLeft())) {
                    predicate.getRight().accept((Expression.Visitor)this);
                } else {
                    predicate.getLeft().accept((Expression.Visitor)this);
                }
            }
        }
        finally {
            this.negated = originNegated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(InPredicate predicate) {
        boolean originNegated = this.negated;
        try {
            if (predicate.isNegated()) {
                boolean bl = this.negated = !this.negated;
            }
            if (this.negated) {
                return;
            }
            if (ConstantifiedJoinNodeAttributeCollector.isParameterOrLiteral(predicate.getLeft())) {
                if (predicate.getRight().size() == 1) {
                    ((Expression)predicate.getRight().get(0)).accept((Expression.Visitor)this);
                }
            } else {
                List right = predicate.getRight();
                int size = right.size();
                for (int i = 0; i < size; ++i) {
                    if (this.isConstant((Expression)right.get(i))) continue;
                    return;
                }
                predicate.getLeft().accept((Expression.Visitor)this);
            }
        }
        finally {
            this.negated = originNegated;
        }
    }

    private static boolean isParameterOrLiteral(Expression expression) {
        return expression instanceof ParameterExpression || expression instanceof LiteralExpression;
    }

    private boolean isConstant(Expression expression) {
        if (ConstantifiedJoinNodeAttributeCollector.isParameterOrLiteral(expression)) {
            return true;
        }
        if (expression instanceof PathExpression) {
            PathReference pathReference = ((PathExpression)expression).getPathReference();
            if (pathReference == null) {
                AliasInfo aliasInfo = this.aliasManager.getAliasInfo(expression.toString());
                return aliasInfo instanceof SelectInfo && this.isConstant(((SelectInfo)aliasInfo).getExpression());
            }
            JoinNode baseNode = (JoinNode)pathReference.getBaseNode();
            do {
                if (baseNode.getParentTreeNode() == null) {
                    return this.isConstantified(baseNode);
                }
                if (!baseNode.getParentTreeNode().getAttribute().isCollection()) continue;
                return false;
            } while ((baseNode = baseNode.getParent()) != null);
        }
        return false;
    }

    public void visit(ListIndexExpression expression) {
        boolean oldInKey = this.inKey;
        this.inKey = true;
        try {
            expression.getPath().accept((Expression.Visitor)this);
        }
        finally {
            this.inKey = oldInKey;
        }
    }

    public void visit(MapKeyExpression expression) {
        boolean oldInKey = this.inKey;
        this.inKey = true;
        try {
            expression.getPath().accept((Expression.Visitor)this);
        }
        finally {
            this.inKey = oldInKey;
        }
    }

    public void visit(IsNullPredicate predicate) {
    }

    public void visit(IsEmptyPredicate predicate) {
    }

    public void visit(MemberOfPredicate predicate) {
    }

    public void visit(LikePredicate predicate) {
    }

    public void visit(BetweenPredicate predicate) {
    }

    public void visit(GtPredicate predicate) {
    }

    public void visit(GePredicate predicate) {
    }

    public void visit(LtPredicate predicate) {
    }

    public void visit(LePredicate predicate) {
    }

    public void visit(ExistsPredicate predicate) {
    }

    public void visit(FunctionExpression expression) {
    }

    public void visit(ArrayExpression expression) {
    }

    public void visit(GeneralCaseExpression expression) {
    }

    public void visit(SimpleCaseExpression expression) {
    }

    public void visit(WhenClauseExpression expression) {
    }

    public void visit(MapEntryExpression expression) {
    }

    public void visit(MapValueExpression expression) {
    }

    public void visit(SubqueryExpression expression) {
    }

    public void visit(TypeFunctionExpression expression) {
    }

    public void visit(TrimExpression expression) {
    }

    public void visit(ArithmeticFactor expression) {
    }

    public void visit(ArithmeticExpression expression) {
    }
}

