/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.expression;

import com.blazebit.persistence.impl.BuilderChainingException;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;

public class ExpressionBuilderEndedListenerImpl
implements ExpressionBuilderEndedListener {
    private ExpressionBuilder currentBuilder;

    public void verifyBuilderEnded() {
        if (this.currentBuilder != null) {
            throw new BuilderChainingException("A builder was not ended properly.");
        }
    }

    public <T extends ExpressionBuilder> T startBuilder(T builder) {
        if (this.currentBuilder != null) {
            throw new BuilderChainingException("There was an attempt to start a builder but a previous builder was not ended.");
        }
        this.currentBuilder = builder;
        return builder;
    }

    @Override
    public void onBuilderEnded(ExpressionBuilder builder) {
        if (this.currentBuilder == null) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        this.currentBuilder = null;
    }
}

