/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.FullSelectCTECriteriaBuilder;
import com.blazebit.persistence.LeafOngoingFinalSetOperationCTECriteriaBuilder;
import com.blazebit.persistence.ReturningModificationCriteriaBuilderFactory;
import com.blazebit.persistence.SelectRecursiveCTECriteriaBuilder;
import com.blazebit.persistence.StartOngoingSetOperationCTECriteriaBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.CTEBuilderListenerImpl;
import com.blazebit.persistence.impl.CTEInfo;
import com.blazebit.persistence.impl.CTEInfoBuilder;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.FinalSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.FullSelectCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.LeafOngoingSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.OngoingFinalSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.QueryContext;
import com.blazebit.persistence.impl.RecursiveCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.ReturningModificationCriteraBuilderFactoryImpl;
import com.blazebit.persistence.impl.StartOngoingSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import jakarta.persistence.metamodel.EntityType;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CTEManager
extends CTEBuilderListenerImpl {
    private final MainQuery mainQuery;
    private final Map<CTEKey, CTEInfo> ctes;
    private QueryContext queryContext;
    private boolean recursive = false;

    CTEManager(MainQuery mainQuery) {
        this.mainQuery = mainQuery;
        this.ctes = new LinkedHashMap<CTEKey, CTEInfo>();
    }

    void init(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (this.queryContext == null) {
            this.queryContext = new QueryContext(queryBuilder, ClauseType.CTE);
        }
    }

    void applyFrom(CTEManager cteManager, Map<JoinManager, JoinManager> joinManagerMapping, ExpressionCopyContext copyContext) {
        if (cteManager.recursive) {
            this.recursive = true;
        }
        for (Map.Entry<CTEKey, CTEInfo> entry : cteManager.ctes.entrySet()) {
            CTEInfo cteInfo = entry.getValue().copy(this, joinManagerMapping, copyContext);
            this.mainQuery.parameterManager.collectParameterRegistrations(cteInfo.nonRecursiveCriteriaBuilder, ClauseType.CTE);
            if (cteInfo.recursive) {
                this.mainQuery.parameterManager.collectParameterRegistrations(cteInfo.recursiveCriteriaBuilder, ClauseType.CTE);
            }
            this.ctes.put(entry.getKey(), cteInfo);
        }
    }

    QueryContext getQueryContext() {
        return this.queryContext;
    }

    Collection<CTEInfo> getCtes() {
        return this.ctes.values();
    }

    public boolean hasCte(EntityType<?> cte) {
        return this.ctes.containsKey(this.getCteKey(cte, null, null));
    }

    public CTEInfo getCte(EntityType<?> cteType) {
        return this.ctes.get(this.getCteKey(cteType, null, null));
    }

    public CTEInfo getCte(EntityType<?> cteType, String name, JoinManager joinManager) {
        return this.ctes.get(this.getCteKey(cteType, name, joinManager));
    }

    private CTEKey getCteKey(EntityType<?> cteClass, String name, JoinManager owner) {
        return new CTEKey(cteClass, name, owner);
    }

    private void assertCteNameAvailable(CTEKey cteKey) {
        if (this.ctes.containsKey(cteKey)) {
            throw new IllegalArgumentException("A CTE with the name " + cteKey.getName() + " already exists! Please choose a different type or name!");
        }
    }

    public boolean hasCtes() {
        if (this.ctes.size() > 0) {
            for (CTEInfo cteInfo : this.ctes.values()) {
                if (cteInfo.inline) continue;
                return true;
            }
        }
        return false;
    }

    boolean isRecursive() {
        return this.recursive;
    }

    void buildClause(StringBuilder sb) {
        if (this.ctes.isEmpty()) {
            return;
        }
        int startLength = sb.length();
        sb.append("WITH ");
        if (this.recursive) {
            sb.append("RECURSIVE ");
        }
        boolean first = true;
        for (CTEInfo cte : this.ctes.values()) {
            if (cte.inline) continue;
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(cte.name);
            sb.append('(');
            List<String> attributes = cte.attributes;
            sb.append(attributes.get(0));
            for (int i = 1; i < attributes.size(); ++i) {
                sb.append(", ");
                sb.append(attributes.get(i));
            }
            sb.append(')');
            sb.append(" AS(\n");
            sb.append(cte.nonRecursiveCriteriaBuilder.getQueryString());
            if (cte.recursive) {
                sb.append(cte.unionAll ? "\nUNION ALL\n" : "\nUNION\n");
                sb.append(cte.recursiveCriteriaBuilder.getQueryString());
            }
            sb.append("\n)");
        }
        if (first) {
            sb.setLength(startLength);
        } else {
            sb.append("\n");
        }
    }

    <Y> StartOngoingSetOperationCTECriteriaBuilder<Y, LeafOngoingFinalSetOperationCTECriteriaBuilder<Y>> withStartSet(EntityType<?> cteEntity, Y result, boolean inline, AliasManager parentAliasManager, JoinManager parentJoinManager) {
        this.mainQuery.assertSupportsAdvancedSql("Illegal use of WITH clause!", inline);
        Class cteClass = cteEntity.getJavaType();
        CTEKey cteKey = this.getCteKey(cteEntity, null, null);
        FinalSetOperationCTECriteriaBuilderImpl<Object> parentFinalSetOperationBuilder = new FinalSetOperationCTECriteriaBuilderImpl<Object>(this.mainQuery, this.queryContext, cteClass, result, null, false, this, null);
        OngoingFinalSetOperationCTECriteriaBuilderImpl<Object> subFinalSetOperationBuilder = new OngoingFinalSetOperationCTECriteriaBuilderImpl<Object>(this.mainQuery, this.queryContext, cteClass, null, null, true, parentFinalSetOperationBuilder.getSubListener(), null);
        this.onBuilderStarted(parentFinalSetOperationBuilder);
        LeafOngoingSetOperationCTECriteriaBuilderImpl<Y> leafCb = new LeafOngoingSetOperationCTECriteriaBuilderImpl<Y>(this.mainQuery, this.queryContext, cteKey, inline, (Class<Object>)cteClass, result, (CTEBuilderListener)parentFinalSetOperationBuilder.getSubListener(), parentFinalSetOperationBuilder, parentAliasManager, parentJoinManager);
        StartOngoingSetOperationCTECriteriaBuilderImpl<Y, LeafOngoingSetOperationCTECriteriaBuilderImpl<Y>> cb = new StartOngoingSetOperationCTECriteriaBuilderImpl<Y, LeafOngoingSetOperationCTECriteriaBuilderImpl<Y>>(this.mainQuery, this.queryContext, cteKey, inline, cteClass, result, subFinalSetOperationBuilder.getSubListener(), subFinalSetOperationBuilder, leafCb, parentAliasManager, parentJoinManager);
        subFinalSetOperationBuilder.setOperationManager.setStartQueryBuilder(cb);
        parentFinalSetOperationBuilder.setOperationManager.setStartQueryBuilder(subFinalSetOperationBuilder);
        subFinalSetOperationBuilder.getSubListener().onBuilderStarted(cb);
        parentFinalSetOperationBuilder.getSubListener().onBuilderStarted(leafCb);
        return cb;
    }

    <Y> FullSelectCTECriteriaBuilder<Y> with(EntityType<?> cteEntity, String name, Y result, boolean inline, JoinManager inlineOwner, AliasManager parentAliasManager, JoinManager parentJoinManager) {
        this.mainQuery.assertSupportsAdvancedSql("Illegal use of WITH clause!", inline);
        Class cteClass = cteEntity.getJavaType();
        CTEKey cteKey = this.getCteKey(cteEntity, name, inlineOwner);
        this.assertCteNameAvailable(cteKey);
        FullSelectCTECriteriaBuilderImpl<Y> cteBuilder = new FullSelectCTECriteriaBuilderImpl<Y>(this.mainQuery, this.queryContext, cteKey, inline, cteClass, result, this, parentAliasManager, parentJoinManager);
        this.onBuilderStarted(cteBuilder);
        return cteBuilder;
    }

    <Y> FullSelectCTECriteriaBuilder<Y> with(EntityType<?> cteEntity, Y result, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder, boolean inline, JoinManager inlineOwner, AliasManager parentAliasManager, JoinManager parentJoinManager) {
        this.mainQuery.assertSupportsAdvancedSql("Illegal use of WITH clause!", inline);
        Class cteClass = cteEntity.getJavaType();
        CTEKey cteKey = this.getCteKey(cteEntity, null, inlineOwner);
        this.assertCteNameAvailable(cteKey);
        FullSelectCTECriteriaBuilderImpl<Y> cteBuilder = new FullSelectCTECriteriaBuilderImpl<Y>(this.mainQuery, this.queryContext, cteKey, inline, cteClass, result, this, parentAliasManager, parentJoinManager);
        cteBuilder.applyFrom(builder, true, false, false, true, Collections.emptySet(), Collections.emptySet(), new IdentityHashMap<JoinManager, JoinManager>(), ExpressionCopyContext.EMPTY);
        this.onBuilderStarted(cteBuilder);
        return cteBuilder;
    }

    <Y> SelectRecursiveCTECriteriaBuilder<Y> withRecursive(EntityType<?> cteEntity, Y result) {
        this.mainQuery.assertSupportsAdvancedSql("Illegal use of WITH clause!");
        Class cteClass = cteEntity.getJavaType();
        CTEKey cteKey = this.getCteKey(cteEntity, null, null);
        this.assertCteNameAvailable(cteKey);
        this.recursive = true;
        RecursiveCTECriteriaBuilderImpl<Y> cteBuilder = new RecursiveCTECriteriaBuilderImpl<Y>(this.mainQuery, this.queryContext, cteKey, cteClass, result, this);
        this.onBuilderStarted(cteBuilder);
        return cteBuilder;
    }

    <Y> ReturningModificationCriteriaBuilderFactory<Y> withReturning(EntityType<?> cteEntity, Y result) {
        this.mainQuery.assertSupportsAdvancedSql("Illegal use of WITH clause!");
        Class cteClass = cteEntity.getJavaType();
        CTEKey cteKey = this.getCteKey(cteEntity, null, null);
        this.assertCteNameAvailable(cteKey);
        ReturningModificationCriteraBuilderFactoryImpl<Y> factory = new ReturningModificationCriteraBuilderFactoryImpl<Y>(this.mainQuery, cteKey, cteClass, result, this);
        return factory;
    }

    @Override
    public void onBuilderEnded(CTEInfoBuilder builder) {
        super.onBuilderEnded(builder);
        CTEInfo cteInfo = builder.createCTEInfo();
        this.mainQuery.parameterManager.collectParameterRegistrations(cteInfo.nonRecursiveCriteriaBuilder, ClauseType.CTE);
        if (cteInfo.recursive) {
            this.mainQuery.parameterManager.collectParameterRegistrations(cteInfo.recursiveCriteriaBuilder, ClauseType.CTE);
        }
        this.ctes.put(new CTEKey(cteInfo.name, cteInfo.owner), cteInfo);
    }

    static final class CTEKey {
        private final String name;
        private final JoinManager owner;

        public CTEKey(EntityType<?> cteType, String name, JoinManager owner) {
            this.name = name == null ? JpaMetamodelUtils.getSimpleTypeName(cteType) : JpaMetamodelUtils.getSimpleTypeName(cteType) + "." + name;
            this.owner = owner;
        }

        public CTEKey(String name, JoinManager owner) {
            this.name = name;
            this.owner = owner;
        }

        public String getName() {
            return this.name;
        }

        public JoinManager getOwner() {
            return this.owner;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CTEKey)) {
                return false;
            }
            CTEKey cteKey = (CTEKey)o;
            if (this.name != null ? !this.name.equals(cteKey.name) : cteKey.name != null) {
                return false;
            }
            return this.owner != null ? this.owner.equals(cteKey.owner) : cteKey.owner == null;
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
            return result;
        }
    }
}

