/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.cast;

import com.blazebit.persistence.impl.util.JpqlFunctionUtil;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;

public class CastFunction
implements JpqlFunction {
    protected final String functionName;
    protected final Class<?> castType;
    protected final String defaultSqlCastType;

    public CastFunction(Class<?> castType, DbmsDialect dbmsDialect) {
        this.functionName = "CAST_" + castType.getSimpleName().toUpperCase();
        this.castType = castType;
        this.defaultSqlCastType = dbmsDialect.getSqlType(castType);
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return this.castType;
    }

    public void render(FunctionRenderContext context) {
        if (context.getArgumentsSize() != 1 && context.getArgumentsSize() != 2) {
            throw new RuntimeException("The " + this.functionName + " function needs one argument <expression> with an optional second argument <sql-type-name>! args=" + context);
        }
        context.addChunk("cast(");
        context.addArgument(0);
        context.addChunk(" as ");
        if (context.getArgumentsSize() == 1) {
            context.addChunk(this.defaultSqlCastType);
        } else {
            context.addChunk(JpqlFunctionUtil.unquoteSingleQuotes(context.getArgument(1)));
        }
        context.addChunk(")");
    }

    public String getCastExpression(String argument) {
        return "cast(" + argument + " as " + this.defaultSqlCastType + ")";
    }

    public String startCastExpression() {
        return "cast(";
    }

    public String endCastExpression(String castType) {
        return " as " + (castType == null ? this.defaultSqlCastType : castType) + ")";
    }
}

