/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.tostringjson;

import com.blazebit.persistence.impl.function.tostringjson.AbstractToStringJsonFunction;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.spi.FunctionRenderContext;

public class PostgreSQLToStringJsonFunction
extends AbstractToStringJsonFunction {
    private static final String START_CHUNK = "(select jsonb_agg(jsonb_build_object('";

    @Override
    public void render(FunctionRenderContext context, String[] fields, String[] selectItemExpressions, String subquery, int fromIndex) {
        context.addChunk(START_CHUNK);
        int orderByIndex = SqlUtils.indexOfOrderBy(subquery, fromIndex);
        if (orderByIndex == -1) {
            this.renderJsonObjectArguments(context, fields, selectItemExpressions);
            context.addChunk("))");
            context.addChunk(subquery.substring(fromIndex));
        } else if (SqlUtils.indexOfLimit(subquery, orderByIndex) == -1 && SqlUtils.indexOfFetchFirst(subquery, orderByIndex) == -1) {
            this.renderJsonObjectArguments(context, fields, selectItemExpressions);
            context.addChunk("))");
            context.addChunk(" OVER (");
            context.addChunk(subquery.substring(orderByIndex));
            context.addChunk(")");
            context.addChunk(subquery.substring(fromIndex, orderByIndex));
        } else {
            this.renderJsonObjectArguments(context, fields, fields);
            context.addChunk("))");
            context.addChunk(" from (select ");
            for (int i = 0; i < fields.length; ++i) {
                if (i != 0) {
                    context.addChunk(",");
                }
                context.addChunk(selectItemExpressions[i]);
                context.addChunk(" ");
                context.addChunk(fields[i]);
            }
            context.addChunk(subquery.substring(fromIndex));
            context.addChunk(" tmp)");
        }
    }

    private void renderJsonObjectArguments(FunctionRenderContext context, String[] fields, String[] selectItemExpressions) {
        for (int j = 0; j < fields.length; j += 50) {
            if (j != 0) {
                context.addChunk(") || jsonb_build_object('");
            }
            int end = Math.min(j + 50, fields.length);
            for (int i = j; i < end; ++i) {
                if (i != j) {
                    context.addChunk(",'");
                }
                context.addChunk(fields[i]);
                context.addChunk("',");
                if (selectItemExpressions[i].startsWith(START_CHUNK)) {
                    context.addChunk(selectItemExpressions[i]);
                    continue;
                }
                context.addChunk("'' || ");
                context.addChunk(selectItemExpressions[i]);
            }
        }
    }
}

