/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.query;

import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import jakarta.persistence.TemporalType;
import jakarta.persistence.criteria.ParameterExpression;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class QueryWrapper
implements Query {
    protected final Query delegate;
    protected final Map<Parameter<?>, String> parameterNameMapping;

    public QueryWrapper(Query delegate, Map<ParameterExpression<?>, String> criteriaNameMapping) {
        this.delegate = delegate;
        if (criteriaNameMapping == null) {
            this.parameterNameMapping = null;
        } else {
            Set parameters = delegate.getParameters();
            HashMap parameterNameMapping = new HashMap(parameters.size());
            HashMap<String, Parameter> parameterMapping = new HashMap<String, Parameter>(parameters.size());
            for (Parameter parameter : parameters) {
                parameterNameMapping.put(parameter, parameter.getName());
                parameterMapping.put(parameter.getName(), parameter);
            }
            for (Map.Entry entry : criteriaNameMapping.entrySet()) {
                Parameter parameter = (Parameter)parameterMapping.get(entry.getValue());
                if (parameter == null) continue;
                parameterNameMapping.remove(parameter);
                parameterNameMapping.put((Parameter<?>)entry.getKey(), (String)entry.getValue());
            }
            this.parameterNameMapping = parameterNameMapping;
        }
    }

    public Query getDelegate() {
        return this.delegate;
    }

    public List getResultList() {
        return this.delegate.getResultList();
    }

    public Object getSingleResult() {
        return this.delegate.getSingleResult();
    }

    public Query setMaxResults(int i) {
        this.delegate.setMaxResults(i);
        return this;
    }

    public Query setFirstResult(int i) {
        this.delegate.setFirstResult(i);
        return this;
    }

    public Query setHint(String string, Object o) {
        this.delegate.setHint(string, o);
        return this;
    }

    public <T> Query setParameter(Parameter<T> prmtr, T t) {
        String name;
        String string = name = this.parameterNameMapping == null ? prmtr.getName() : this.parameterNameMapping.get(prmtr);
        if (name == null) {
            this.delegate.setParameter(prmtr, t);
        } else {
            this.delegate.setParameter(name, t);
        }
        return this;
    }

    public Query setParameter(Parameter<Calendar> prmtr, Calendar clndr, TemporalType tt) {
        String name;
        String string = name = this.parameterNameMapping == null ? prmtr.getName() : this.parameterNameMapping.get(prmtr);
        if (name == null) {
            this.delegate.setParameter(prmtr, clndr, tt);
        } else {
            this.delegate.setParameter(name, clndr, tt);
        }
        return this;
    }

    public Query setParameter(Parameter<Date> prmtr, Date date, TemporalType tt) {
        String name;
        String string = name = this.parameterNameMapping == null ? prmtr.getName() : this.parameterNameMapping.get(prmtr);
        if (name == null) {
            this.delegate.setParameter(prmtr, date, tt);
        } else {
            this.delegate.setParameter(name, date, tt);
        }
        return this;
    }

    public Query setParameter(String string, Object o) {
        this.delegate.setParameter(string, o);
        return this;
    }

    public Query setParameter(String string, Calendar clndr, TemporalType tt) {
        this.delegate.setParameter(string, clndr, tt);
        return this;
    }

    public Query setParameter(String string, Date date, TemporalType tt) {
        this.delegate.setParameter(string, date, tt);
        return this;
    }

    public Query setParameter(int i, Object o) {
        this.delegate.setParameter(i, o);
        return this;
    }

    public Query setParameter(int i, Calendar clndr, TemporalType tt) {
        this.delegate.setParameter(i, clndr, tt);
        return this;
    }

    public Query setParameter(int i, Date date, TemporalType tt) {
        this.delegate.setParameter(i, date, tt);
        return this;
    }

    public Query setFlushMode(FlushModeType fmt) {
        this.delegate.setFlushMode(fmt);
        return this;
    }

    public Query setLockMode(LockModeType lmt) {
        this.delegate.setLockMode(lmt);
        return this;
    }

    public int executeUpdate() {
        return this.delegate.executeUpdate();
    }

    public int getMaxResults() {
        return this.delegate.getMaxResults();
    }

    public int getFirstResult() {
        return this.delegate.getFirstResult();
    }

    public Map<String, Object> getHints() {
        return this.delegate.getHints();
    }

    public Set<Parameter<?>> getParameters() {
        if (this.parameterNameMapping == null) {
            return this.delegate.getParameters();
        }
        return this.parameterNameMapping.keySet();
    }

    public Parameter<?> getParameter(String string) {
        if (this.parameterNameMapping != null) {
            for (Map.Entry<Parameter<?>, String> entry : this.parameterNameMapping.entrySet()) {
                if (!string.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return this.delegate.getParameter(string);
    }

    public <T> Parameter<T> getParameter(String string, Class<T> type) {
        if (this.parameterNameMapping != null) {
            for (Map.Entry<Parameter<?>, String> entry : this.parameterNameMapping.entrySet()) {
                if (!string.equals(entry.getValue())) continue;
                if (!entry.getKey().getParameterType().isAssignableFrom(type)) {
                    throw new IllegalArgumentException("Parameter '" + string + "' is not assignable to '" + type.getName() + "'!");
                }
                return entry.getKey();
            }
        }
        return this.delegate.getParameter(string, type);
    }

    public Parameter<?> getParameter(int i) {
        if (this.parameterNameMapping != null) {
            String string = Integer.toString(i);
            for (Map.Entry<Parameter<?>, String> entry : this.parameterNameMapping.entrySet()) {
                if (!string.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return this.delegate.getParameter(i);
    }

    public <T> Parameter<T> getParameter(int i, Class<T> type) {
        if (this.parameterNameMapping != null) {
            String string = Integer.toString(i);
            for (Map.Entry<Parameter<?>, String> entry : this.parameterNameMapping.entrySet()) {
                if (!string.equals(entry.getValue())) continue;
                if (!entry.getKey().getParameterType().isAssignableFrom(type)) {
                    throw new IllegalArgumentException("Parameter at position " + i + " is not assignable to '" + type.getName() + "'!");
                }
                return entry.getKey();
            }
        }
        return this.delegate.getParameter(i, type);
    }

    public boolean isBound(Parameter<?> prmtr) {
        if (this.parameterNameMapping != null) {
            String name = this.parameterNameMapping.get(prmtr);
            return this.delegate.isBound(this.delegate.getParameter(name));
        }
        return this.delegate.isBound(prmtr);
    }

    public <T> T getParameterValue(Parameter<T> prmtr) {
        if (this.parameterNameMapping != null) {
            String name = this.parameterNameMapping.get(prmtr);
            return (T)this.delegate.getParameterValue(name);
        }
        return (T)this.delegate.getParameterValue(prmtr);
    }

    public Object getParameterValue(String string) {
        return this.delegate.getParameterValue(string);
    }

    public Object getParameterValue(int i) {
        return this.delegate.getParameterValue(i);
    }

    public FlushModeType getFlushMode() {
        return this.delegate.getFlushMode();
    }

    public LockModeType getLockMode() {
        return this.delegate.getLockMode();
    }

    public <T> T unwrap(Class<T> type) {
        return (T)this.delegate.unwrap(type);
    }

    public Stream getResultStream() {
        return this.delegate.getResultStream();
    }
}

