/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.query;

import com.blazebit.persistence.ReturningObjectBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.impl.query.ModificationQuerySpecification;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.UpdateJoinStyle;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpdateModificationQuerySpecification<T>
extends ModificationQuerySpecification<T> {
    private final String tableToUpdate;
    private final String tableAlias;
    private final String[] idColumns;
    private final List<String> setColumns;
    private final Collection<Query> foreignKeyParticipatingQueries;
    private final Map<String, String> aliasMapping;
    private final Query updateExampleQuery;

    public UpdateModificationQuerySpecification(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> commonQueryBuilder, Query baseQuery, Query exampleQuery, Collection<? extends Parameter<?>> parameters, Set<String> parameterListNames, List<String> keyRestrictedLeftJoinAliases, List<EntityFunctionNode> entityFunctionNodes, boolean recursive, List<CTENode> ctes, boolean shouldRenderCteNodes, boolean isEmbedded, String[] returningColumns, ReturningObjectBuilder<T> objectBuilder, Map<DbmsModificationState, String> includedModificationStates, Map<String, String> returningAttributeBindingMap, boolean queryPlanCacheEnabled, String tableToUpdate, String tableAlias, String[] idColumns, List<String> setColumns, Collection<Query> foreignKeyParticipatingQueries, Map<String, String> aliasMapping, Query updateExampleQuery) {
        super(commonQueryBuilder, baseQuery, exampleQuery, parameters, parameterListNames, keyRestrictedLeftJoinAliases, entityFunctionNodes, recursive, ctes, shouldRenderCteNodes, isEmbedded, returningColumns, objectBuilder, includedModificationStates, returningAttributeBindingMap, queryPlanCacheEnabled);
        this.tableToUpdate = tableToUpdate;
        this.tableAlias = tableAlias;
        this.idColumns = idColumns;
        this.setColumns = setColumns;
        this.foreignKeyParticipatingQueries = foreignKeyParticipatingQueries;
        this.aliasMapping = aliasMapping;
        this.updateExampleQuery = updateExampleQuery;
    }

    @Override
    protected void initialize() {
        ArrayList<Query> participatingQueries = new ArrayList<Query>();
        for (Map.Entry entry : this.listParameters.entrySet()) {
            this.baseQuery.setParameter((String)entry.getKey(), entry.getValue());
        }
        String sql = this.applySqlTransformations(this.extendedQuerySupport.getSql(this.em, this.baseQuery)).toString();
        StringBuilder sb = new StringBuilder(sql.length());
        String tableToUpdate = this.tableToUpdate;
        if (SqlUtils.indexOfSelect(sql) == -1) {
            sb.append(sql);
            tableToUpdate = sql.substring(sql.indexOf(32) + 1, sql.indexOf(32, sql.indexOf(32) + 1));
        } else {
            int fromIndex = SqlUtils.indexOfFrom(sql);
            switch (this.dbmsDialect.getUpdateJoinStyle()) {
                case FROM: 
                case FROM_ALIAS: {
                    int i;
                    sb.append("update ");
                    if (this.dbmsDialect.getUpdateJoinStyle() == UpdateJoinStyle.FROM_ALIAS) {
                        sb.append(this.tableAlias);
                    } else {
                        sb.append(tableToUpdate);
                    }
                    sb.append(" set ");
                    this.applySetClause(sb, Arrays.asList(SqlUtils.getSelectItemExpressions(sql, 0)));
                    sb.append(sql, fromIndex, sql.length());
                    if (this.dbmsDialect.getUpdateJoinStyle() != UpdateJoinStyle.FROM) break;
                    sb.append(" and ").append(tableToUpdate).append('.').append(this.idColumns[0]).append(" = ").append(this.tableAlias).append(".").append(this.idColumns[0]);
                    for (i = 1; i < this.idColumns.length; ++i) {
                        String idColumn = this.idColumns[i];
                        sb.append(" and ").append(tableToUpdate).append('.').append(idColumn).append(" = ").append(this.tableAlias).append(".").append(this.idColumns[i]);
                    }
                    break;
                }
                case REFERENCE: {
                    int i;
                    int groupByIndex = SqlUtils.indexOfGroupBy(sql, fromIndex);
                    sb.append("update ");
                    sb.append(tableToUpdate);
                    sb.append(", (select ");
                    for (Map.Entry<String, String> entry : this.aliasMapping.entrySet()) {
                        sb.append(entry.getKey()).append(" as ").append(entry.getValue(), entry.getValue().indexOf(46) + 1, entry.getValue().length()).append(", ");
                    }
                    sb.setLength(sb.length() - 2);
                    sb.append(sql, fromIndex, groupByIndex);
                    sb.append(") tmp ");
                    sb.append("set ");
                    this.applySetClause(sb, SqlUtils.getExpressionItems(sql, groupByIndex + " group by ".length(), sql.length()));
                    sb.append(" where ");
                    sb.append(tableToUpdate).append('.').append(this.idColumns[0]).append(" = tmp.c0");
                    for (i = 1; i < this.idColumns.length; ++i) {
                        String idColumn = this.idColumns[i];
                        sb.append(" and ").append(tableToUpdate).append('.').append(idColumn).append(" = tmp.c").append(i);
                    }
                    break;
                }
                case MERGE: {
                    int i;
                    int groupByIndex = SqlUtils.indexOfGroupBy(sql, fromIndex);
                    sb.append("merge into ");
                    sb.append(tableToUpdate);
                    sb.append(" using (select ");
                    for (Map.Entry<String, String> entry : this.aliasMapping.entrySet()) {
                        sb.append(entry.getKey()).append(" as ").append(entry.getValue(), entry.getValue().indexOf(46) + 1, entry.getValue().length()).append(", ");
                    }
                    sb.setLength(sb.length() - 2);
                    sb.append(sql, fromIndex, groupByIndex);
                    sb.append(") tmp on (");
                    sb.append(tableToUpdate).append('.').append(this.idColumns[0]).append(" = tmp.c0");
                    for (i = 1; i < this.idColumns.length; ++i) {
                        String idColumn = this.idColumns[i];
                        sb.append(" and ").append(tableToUpdate).append('.').append(idColumn).append(" = tmp.c").append(i);
                    }
                    sb.append(") when matched then update set ");
                    this.applySetClause(sb, SqlUtils.getExpressionItems(sql, groupByIndex + " group by ".length(), sql.length()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported update join style: " + this.dbmsDialect.getUpdateJoinStyle());
                }
            }
        }
        StringBuilder withClause = this.applyCtes(sb, this.baseQuery, participatingQueries);
        Map<String, String> addedCtes = this.applyExtendedSql(sb, false, this.isEmbedded, withClause, tableToUpdate, this.returningColumns, this.includedModificationStates);
        participatingQueries.add(this.baseQuery);
        participatingQueries.add(this.exampleQuery);
        participatingQueries.add(this.updateExampleQuery);
        participatingQueries.addAll(this.foreignKeyParticipatingQueries);
        boolean hasCtes = withClause != null && withClause.length() != 0 || addedCtes != null && !addedCtes.isEmpty();
        this.query = hasCtes && this.returningAttributeBindingMap.isEmpty() && !this.dbmsDialect.usesExecuteUpdateWhenWithClauseInModificationQuery() ? this.exampleQuery : this.updateExampleQuery;
        this.sql = sb.toString();
        this.participatingQueries = participatingQueries;
        this.addedCtes = addedCtes;
        this.dirty = false;
    }

    private void applySetClause(StringBuilder sb, List<String> selectItemExpressions) {
        for (int i = 0; i < selectItemExpressions.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            String item = selectItemExpressions.get(i);
            sb.append(this.setColumns.get(i)).append(" = ");
            sb.append(item, item.indexOf(61) + 1, item.lastIndexOf(" then "));
        }
    }
}

