/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseFinalSetOperationBuilder;
import com.blazebit.persistence.BaseOngoingFinalSetOperationBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.DefaultOrderByElement;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JoinVisitor;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.QueryContext;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SetOperationManager;
import com.blazebit.persistence.impl.SimplePathReference;
import com.blazebit.persistence.impl.query.AbstractCustomQuery;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CustomSQLTypedQuery;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.impl.query.SetOperationQuerySpecification;
import com.blazebit.persistence.impl.query.SetTypedQuery;
import com.blazebit.persistence.impl.query.TypedQueryWrapper;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.NumericType;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.OrderByElement;
import com.blazebit.persistence.spi.SetOperationType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public abstract class BaseFinalSetOperationBuilderImpl<T, X extends BaseFinalSetOperationBuilder<T, X>, Y extends BaseFinalSetOperationBuilderImpl<T, X, Y>>
extends AbstractCommonQueryBuilder<T, X, AbstractCommonQueryBuilder<?, ?, ?, ?, ?>, AbstractCommonQueryBuilder<?, ?, ?, ?, ?>, Y>
implements BaseFinalSetOperationBuilder<T, X>,
BaseOngoingFinalSetOperationBuilder<T, X> {
    protected T endSetResult;
    protected final SetOperationManager setOperationManager;
    protected final List<DefaultOrderByElement> orderByElements;

    public BaseFinalSetOperationBuilderImpl(MainQuery mainQuery, QueryContext queryContext, boolean isMainQuery, Class<T> clazz, SetOperationType operator, boolean nested, T endSetResult) {
        super(mainQuery, queryContext, isMainQuery, DbmsStatementType.SELECT, clazz, null, null, false, null, null);
        this.endSetResult = endSetResult;
        this.setOperationManager = new SetOperationManager(operator, nested);
        this.orderByElements = new ArrayList<DefaultOrderByElement>(0);
        this.nodesToFetch = Collections.emptySet();
        this.needsCheck = false;
    }

    public BaseFinalSetOperationBuilderImpl(BaseFinalSetOperationBuilderImpl<T, X, Y> builder, MainQuery mainQuery, QueryContext queryContext, Map<JoinManager, JoinManager> joinManagerMapping, ExpressionCopyContext copyContext) {
        super(builder, mainQuery, queryContext, joinManagerMapping, copyContext);
        this.setOperationManager = new SetOperationManager(builder.setOperationManager, queryContext, joinManagerMapping, copyContext);
        this.orderByElements = new ArrayList<DefaultOrderByElement>(builder.orderByElements);
        this.nodesToFetch = Collections.emptySet();
        this.needsCheck = false;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.setOperationManager.isEmpty();
    }

    private static boolean isNestedAndComplex(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (queryBuilder instanceof BaseFinalSetOperationBuilderImpl) {
            BaseFinalSetOperationBuilderImpl builder = (BaseFinalSetOperationBuilderImpl)queryBuilder;
            return builder.setOperationManager.isNested() && (builder.setOperationManager.hasSetOperations() || BaseFinalSetOperationBuilderImpl.isNestedAndComplex(builder.setOperationManager.getStartQueryBuilder()));
        }
        return false;
    }

    @Override
    public X orderBy(String expression, boolean ascending, boolean nullFirst) {
        this.prepareAndCheck(null);
        AbstractCommonQueryBuilder<?, ?, ?, ?, ?> leftMostQuery = this.getLeftMost(this.setOperationManager.getStartQueryBuilder());
        AliasInfo aliasInfo = leftMostQuery.aliasManager.getAliasInfo(expression);
        int position = aliasInfo == null ? this.cbf.getExtendedQuerySupport().getSqlSelectAttributePosition(this.em, leftMostQuery.getTypedQueryForFinalOperationBuilder(), expression) : this.cbf.getExtendedQuerySupport().getSqlSelectAliasPosition(this.em, leftMostQuery.getTypedQueryForFinalOperationBuilder(), expression);
        this.orderByElements.add(new DefaultOrderByElement(expression, position, ascending, this.isNullable(this, expression), nullFirst));
        return (X)this;
    }

    private boolean isNullable(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder, String expression) {
        if (queryBuilder instanceof BaseFinalSetOperationBuilderImpl) {
            SetOperationManager setOpManager = ((BaseFinalSetOperationBuilderImpl)queryBuilder).setOperationManager;
            if (this.isNullable(setOpManager.getStartQueryBuilder(), expression)) {
                return true;
            }
            for (AbstractCommonQueryBuilder<?, ?, ?, ?, ?> setOp : setOpManager.getSetOperations()) {
                if (!this.isNullable(setOp, expression)) continue;
                return true;
            }
            return false;
        }
        AliasInfo aliasInfo = queryBuilder.aliasManager.getAliasInfo(expression);
        if (aliasInfo == null) {
            JoinNode rootNode;
            List<SelectInfo> selectInfos = queryBuilder.selectManager.getSelectInfos();
            if (selectInfos.size() > 1) {
                throw new IllegalArgumentException("Can't order by an attribute when having multiple select items! Use a select alias!");
            }
            if (selectInfos.isEmpty()) {
                rootNode = queryBuilder.joinManager.getRootNodeOrFail("Can't order by an attribute when having multiple query roots! Use a select alias!");
            } else {
                if (!(selectInfos.get(0).get() instanceof PathExpression)) {
                    throw new IllegalArgumentException("Can't order by an attribute when the select item is a complex expression! Use a select alias!");
                }
                rootNode = (JoinNode)((PathExpression)selectInfos.get(0).get()).getBaseNode();
            }
            if (JpaMetamodelUtils.getAttribute(rootNode.getManagedType(), (String)expression) == null) {
                throw new IllegalArgumentException("The attribute '" + expression + "' does not exist on the type '" + rootNode.getJavaType().getName() + "'! Did you maybe forget to use a select alias?");
            }
            ArrayList<PropertyExpression> path = new ArrayList<PropertyExpression>(2);
            path.add(new PropertyExpression(rootNode.getAlias()));
            path.add(new PropertyExpression(expression));
            return this.joinManager.hasFullJoin() || ExpressionUtils.isNullable(this.getMetamodel(), queryBuilder.functionalDependencyAnalyzerVisitor.getConstantifiedJoinNodeAttributeCollector(), (Expression)new PathExpression(path, (PathReference)new SimplePathReference(rootNode, expression, null), false, false));
        }
        return this.joinManager.hasFullJoin() || ExpressionUtils.isNullable(this.getMetamodel(), queryBuilder.functionalDependencyAnalyzerVisitor.getConstantifiedJoinNodeAttributeCollector(), ((SelectInfo)aliasInfo).getExpression());
    }

    private AbstractCommonQueryBuilder<?, ?, ?, ?, ?> getLeftMost(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (queryBuilder instanceof BaseFinalSetOperationBuilderImpl) {
            return this.getLeftMost(((BaseFinalSetOperationBuilderImpl)queryBuilder).setOperationManager.getStartQueryBuilder());
        }
        return queryBuilder;
    }

    protected List<? extends OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public T getEndSetResult() {
        return this.endSetResult;
    }

    public void setEndSetResult(T endSetResult) {
        this.endSetResult = endSetResult;
    }

    public T endSet() {
        this.setOperationEnded = true;
        this.prepareAndCheck(null);
        return this.endSetResult;
    }

    @Override
    protected void prepareAndCheck(JoinVisitor parentVisitor) {
    }

    public void verifyBuilderEnded(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> currentBuilder) {
        if (!this.setOperationEnded) {
            throw new IllegalStateException("Set operation builder not properly ended!");
        }
        super.verifyBuilderEnded();
        if (currentBuilder == this.setOperationManager.getStartQueryBuilder()) {
            return;
        }
        this.verifySetOperationEnded(this.setOperationManager.getStartQueryBuilder());
        for (AbstractCommonQueryBuilder<?, ?, ?, ?, ?> setOperand : this.setOperationManager.getSetOperations()) {
            if (currentBuilder == setOperand) {
                return;
            }
            this.verifySetOperationEnded(setOperand);
        }
    }

    private void verifySetOperationEnded(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder) {
        if (builder instanceof BaseFinalSetOperationBuilderImpl) {
            builder.verifyBuilderEnded();
        } else if (!builder.setOperationEnded) {
            throw new IllegalStateException("Set operation builder not properly ended!");
        }
    }

    @Override
    public Expression asExpression(boolean externalRepresentation, boolean quantifiedPredicate) {
        SetOperationManager operationManager = this.setOperationManager;
        if (operationManager.getOperator() == null || !operationManager.hasSetOperations()) {
            return this.asExpression(operationManager.getStartQueryBuilder(), externalRepresentation, quantifiedPredicate);
        }
        ArrayList<Object> setOperationArgs = new ArrayList<Object>(operationManager.getSetOperations().size() + 2);
        setOperationArgs.add(new StringLiteral("SET_" + operationManager.getOperator().name()));
        setOperationArgs.add(this.asExpression(operationManager.getStartQueryBuilder(), externalRepresentation, quantifiedPredicate));
        List<AbstractCommonQueryBuilder<?, ?, ?, ?, ?>> setOperands = operationManager.getSetOperations();
        int operandsSize = setOperands.size();
        for (int i = 0; i < operandsSize; ++i) {
            setOperationArgs.add(this.asExpression(setOperands.get(i), externalRepresentation, quantifiedPredicate));
        }
        List<OrderByElement> orderByElements = this.getOrderByElements();
        if (orderByElements.size() > 0) {
            setOperationArgs.add(new StringLiteral("ORDER_BY"));
            int orderByElementsSize = orderByElements.size();
            for (int i = 0; i < orderByElementsSize; ++i) {
                setOperationArgs.add(new StringLiteral(orderByElements.get(i).toString()));
            }
        }
        if (this.hasLimit()) {
            if (this.maxResults != Integer.MAX_VALUE) {
                setOperationArgs.add(new StringLiteral("LIMIT"));
                setOperationArgs.add(new NumericLiteral(Integer.toString(this.maxResults), NumericType.INTEGER));
            }
            if (this.firstResult != 0) {
                setOperationArgs.add(new StringLiteral("OFFSET"));
                setOperationArgs.add(new NumericLiteral(Integer.toString(this.firstResult), NumericType.INTEGER));
            }
        }
        FunctionExpression expression = new FunctionExpression("FUNCTION", setOperationArgs);
        if (quantifiedPredicate && this.hasLimit() && !this.mainQuery.dbmsDialect.supportsLimitInQuantifiedPredicateSubquery()) {
            ArrayList<Object> arguments = new ArrayList<Object>(2);
            arguments.add(new StringLiteral("query_wrapper"));
            arguments.add(expression);
            expression = new FunctionExpression("FUNCTION", arguments);
        }
        return expression;
    }

    @Override
    protected void buildBaseQueryString(StringBuilder sbSelectFrom, boolean externalRepresentation, JoinNode lateralJoinNode, boolean countWrapped) {
        boolean hasOrderByOrLimit = !this.orderByElements.isEmpty() || this.hasLimit();
        boolean nested = BaseFinalSetOperationBuilderImpl.isNestedAndComplex(this.setOperationManager.getStartQueryBuilder());
        if (hasOrderByOrLimit) {
            sbSelectFrom.append('(');
        }
        if (nested) {
            sbSelectFrom.append('(');
        }
        this.setOperationManager.getStartQueryBuilder().buildBaseQueryString(sbSelectFrom, externalRepresentation, lateralJoinNode, false);
        if (nested) {
            sbSelectFrom.append(')');
        }
        if (this.setOperationManager.hasSetOperations()) {
            String operator = this.getOperator(this.setOperationManager.getOperator());
            for (AbstractCommonQueryBuilder<?, ?, ?, ?, ?> setOperand : this.setOperationManager.getSetOperations()) {
                sbSelectFrom.append("\n");
                sbSelectFrom.append(operator);
                sbSelectFrom.append("\n");
                nested = BaseFinalSetOperationBuilderImpl.isNestedAndComplex(setOperand);
                if (nested) {
                    sbSelectFrom.append('(');
                }
                setOperand.buildBaseQueryString(sbSelectFrom, externalRepresentation, lateralJoinNode, false);
                if (!nested) continue;
                sbSelectFrom.append(')');
            }
            if (hasOrderByOrLimit) {
                sbSelectFrom.append(')');
                this.applySetOrderBy(sbSelectFrom);
                if (!this.isMainQuery) {
                    this.applyJpaLimit(sbSelectFrom);
                }
            }
        }
    }

    protected void applySetOrderBy(StringBuilder sbSelectFrom) {
        if (this.orderByElements.isEmpty()) {
            return;
        }
        sbSelectFrom.append("\nORDER BY ");
        for (int i = 0; i < this.orderByElements.size(); ++i) {
            if (i != 0) {
                sbSelectFrom.append(", ");
            }
            DefaultOrderByElement elem = this.orderByElements.get(i);
            sbSelectFrom.append(elem.getName());
            if (elem.isAscending()) {
                sbSelectFrom.append(" ASC");
            } else {
                sbSelectFrom.append(" DESC");
            }
            if (!elem.isNullable()) continue;
            if (elem.isNullsFirst()) {
                sbSelectFrom.append(" NULLS FIRST");
                continue;
            }
            sbSelectFrom.append(" NULLS LAST");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected TypedQuery<T> getTypedQuery(StringBuilder lateralSb, JoinNode lateralJoinNode) {
        void var9_12;
        SetTypedQuery baseQuery;
        if (lateralSb != null) {
            throw new IllegalStateException("Lateral join with set operations is not yet supported!");
        }
        if (this.mainQuery.jpaProvider.supportsSetOperations()) {
            return super.getTypedQuery(lateralSb, lateralJoinNode);
        }
        HashSet<String> parameterListNames = new HashSet<String>();
        TypedQuery<?> leftMostQuery = this.setOperationManager.getStartQueryBuilder().getTypedQueryForFinalOperationBuilder();
        this.parameterManager.collectParameterListNames((Query)leftMostQuery, (Set<String>)parameterListNames);
        Query q = leftMostQuery;
        if (leftMostQuery instanceof TypedQueryWrapper) {
            q = ((TypedQueryWrapper)leftMostQuery).getDelegate();
        }
        if (q instanceof AbstractCustomQuery) {
            AbstractCustomQuery customQuery = (AbstractCustomQuery)q;
            List<Query> customQueryParticipants = customQuery.getParticipatingQueries();
            baseQuery = customQueryParticipants.get(0);
        } else {
            baseQuery = q;
        }
        ArrayList<Query> setOperands = new ArrayList<Query>();
        for (AbstractCommonQueryBuilder abstractCommonQueryBuilder : this.setOperationManager.getSetOperations()) {
            q = abstractCommonQueryBuilder.getQuery();
            setOperands.add(q);
            this.parameterManager.collectParameterListNames(q, parameterListNames);
        }
        SetTypedQuery setQuery = this.mainQuery.jpaProvider.supportsSetOperations() ? baseQuery : new SetTypedQuery((Query)baseQuery, setOperands);
        Object var9_10 = null;
        String offset = null;
        if (!this.isMainQuery) {
            if (this.firstResult != 0) {
                offset = Integer.toString(this.firstResult);
            }
            if (this.maxResults != Integer.MAX_VALUE) {
                String string = Integer.toString(this.maxResults);
            }
        }
        List<String> keyRestrictedLeftJoinAliases = Collections.emptyList();
        List<EntityFunctionNode> entityFunctionNodes = this.getEntityFunctionNodes(setQuery, 0);
        boolean shouldRenderCteNodes = this.renderCteNodes(false);
        List<CTENode> ctes = shouldRenderCteNodes ? this.getCteNodes(false) : Collections.EMPTY_LIST;
        SetOperationQuerySpecification querySpecification = new SetOperationQuerySpecification(this, (Query)leftMostQuery, baseQuery, (List<Query>)setOperands, this.setOperationManager.getOperator(), this.getOrderByElements(), this.setOperationManager.isNested(), (Collection<Parameter<?>>)this.parameterManager.getParameterImpls(), (Set<String>)parameterListNames, (String)var9_12, offset, keyRestrictedLeftJoinAliases, entityFunctionNodes, this.mainQuery.cteManager.isRecursive(), ctes, shouldRenderCteNodes, this.mainQuery.getQueryConfiguration().isQueryPlanCacheEnabled());
        CustomSQLTypedQuery query = new CustomSQLTypedQuery(querySpecification, baseQuery, this.parameterManager.getCriteriaNameMapping(), this.parameterManager.getTransformers(), this.parameterManager.getValuesParameters(), this.parameterManager.getValuesBinders());
        if (this.isMainQuery) {
            if (this.firstResult != 0) {
                query.setFirstResult(this.firstResult);
            }
            if (this.maxResults != Integer.MAX_VALUE) {
                query.setMaxResults(this.maxResults);
            }
        }
        this.parameterManager.parameterizeQuery(query);
        return this.applyObjectBuilder(query);
    }

    @Override
    protected boolean needsSqlReplacement(Set<JoinNode> keyRestrictedLeftJoins) {
        if (this.mainQuery.jpaProvider.supportsSetOperations() && this.isMainQuery && this.mainQuery.cteManager.hasCtes()) {
            return true;
        }
        if (this.setOperationManager.getStartQueryBuilder().needsSqlReplacement(this.setOperationManager.getStartQueryBuilder().getKeyRestrictedLeftJoins())) {
            return true;
        }
        for (AbstractCommonQueryBuilder<?, ?, ?, ?, ?> setOperation : this.setOperationManager.getSetOperations()) {
            if (!setOperation.needsSqlReplacement(setOperation.getKeyRestrictedLeftJoins())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int collectEntityFunctionNodes(List<EntityFunctionNode> entityFunctionNodes, Query baseQuery, int queryPartNumber) {
        int offset;
        if (!this.mainQuery.jpaProvider.supportsSetOperations()) {
            return -1;
        }
        List<AbstractCommonQueryBuilder<?, ?, ?, ?, ?>> setOperations = this.setOperationManager.getSetOperations();
        if (baseQuery instanceof SetTypedQuery) {
            SetTypedQuery setTypedQuery = (SetTypedQuery)baseQuery;
            offset = this.setOperationManager.getStartQueryBuilder().collectEntityFunctionNodes(entityFunctionNodes, setTypedQuery.getQueryPart(0), queryPartNumber);
            for (int i = 0; i < setOperations.size(); ++i) {
                offset += setOperations.get(i).collectEntityFunctionNodes(entityFunctionNodes, setTypedQuery.getQueryPart(i + 1), queryPartNumber + offset + i);
            }
        } else {
            offset = this.setOperationManager.getStartQueryBuilder().collectEntityFunctionNodes(entityFunctionNodes, baseQuery, queryPartNumber);
            for (int i = 0; i < setOperations.size(); ++i) {
                offset += setOperations.get(i).collectEntityFunctionNodes(entityFunctionNodes, baseQuery, queryPartNumber + offset + i);
            }
        }
        return offset;
    }

    protected String getOperator(SetOperationType type) {
        switch (type) {
            case UNION: {
                return "UNION";
            }
            case UNION_ALL: {
                return "UNION ALL";
            }
            case INTERSECT: {
                return "INTERSECT";
            }
            case INTERSECT_ALL: {
                return "INTERSECT ALL";
            }
            case EXCEPT: {
                return "EXCEPT";
            }
            case EXCEPT_ALL: {
                return "EXCEPT ALL";
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public TypedQuery<T> getQuery() {
        return this.getTypedQuery(null, null);
    }

    public List<T> getResultList() {
        return this.getTypedQuery(null, null).getResultList();
    }

    public T getSingleResult() {
        return (T)this.getTypedQuery(null, null).getSingleResult();
    }

    public T getSingleResultOrNull() {
        try {
            return (T)this.getTypedQuery(null, null).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Stream<T> getResultStream() {
        return this.getTypedQuery(null, null).getResultStream();
    }
}

