/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.plan;

import com.blazebit.persistence.impl.plan.SelectQueryPlan;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.ServiceProvider;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import java.util.List;
import java.util.stream.Stream;

public class CustomSelectQueryPlan<T>
implements SelectQueryPlan<T> {
    private final ExtendedQuerySupport extendedQuerySupport;
    private final ServiceProvider serviceProvider;
    private final Query baseQuery;
    private final Query delegate;
    private final List<Query> participatingQueries;
    private final String sql;
    private final int firstResult;
    private final int maxResults;
    private final boolean queryPlanCacheEnabled;

    public CustomSelectQueryPlan(ExtendedQuerySupport extendedQuerySupport, ServiceProvider serviceProvider, Query baseQuery, Query delegate, List<Query> participatingQueries, String sql, int firstResult, int maxResults, boolean queryPlanCacheEnabled) {
        this.extendedQuerySupport = extendedQuerySupport;
        this.serviceProvider = serviceProvider;
        this.baseQuery = baseQuery;
        this.delegate = delegate;
        this.participatingQueries = participatingQueries;
        this.sql = sql;
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.queryPlanCacheEnabled = queryPlanCacheEnabled;
    }

    @Override
    public List<T> getResultList() {
        this.extendedQuerySupport.applyFirstResultMaxResults(this.baseQuery, this.firstResult, this.maxResults);
        return this.extendedQuerySupport.getResultList(this.serviceProvider, this.participatingQueries, this.delegate, this.sql, this.queryPlanCacheEnabled);
    }

    @Override
    public T getSingleResult() {
        this.extendedQuerySupport.applyFirstResultMaxResults(this.baseQuery, this.firstResult, this.maxResults);
        return (T)this.extendedQuerySupport.getSingleResult(this.serviceProvider, this.participatingQueries, this.delegate, this.sql, this.queryPlanCacheEnabled);
    }

    @Override
    public T getSingleResultOrNull() {
        try {
            return this.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public Stream<T> getResultStream() {
        this.extendedQuerySupport.applyFirstResultMaxResults(this.baseQuery, this.firstResult, this.maxResults);
        return (Stream)this.extendedQuerySupport.getResultStream(this.serviceProvider, this.participatingQueries, this.delegate, this.sql, this.queryPlanCacheEnabled);
    }
}

