/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.query;

import com.blazebit.persistence.impl.ParameterValueTransformer;
import com.blazebit.persistence.impl.ValuesParameterBinder;
import com.blazebit.persistence.impl.query.AbstractCustomQuery;
import com.blazebit.persistence.impl.query.QuerySpecification;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.ParameterExpression;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class CustomSQLTypedQuery<X>
extends AbstractCustomQuery<X>
implements TypedQuery<X> {
    private final Query delegate;

    public CustomSQLTypedQuery(QuerySpecification querySpecification, Query delegate, Map<ParameterExpression<?>, String> criteriaNameMapping, Map<String, ParameterValueTransformer> transformers, Map<String, String> valuesParameters, Map<String, ValuesParameterBinder> valuesBinders) {
        super(querySpecification, criteriaNameMapping, transformers, valuesParameters, valuesBinders);
        this.delegate = delegate;
    }

    @Override
    public Query getDelegate() {
        return this.delegate;
    }

    public List<X> getResultList() {
        this.bindParameters();
        return this.querySpecification.createSelectPlan(this.firstResult, this.maxResults).getResultList();
    }

    public X getSingleResult() {
        this.bindParameters();
        return (X)this.querySpecification.createSelectPlan(this.firstResult, this.maxResults).getSingleResult();
    }

    @Override
    public X getSingleResultOrNull() {
        this.bindParameters();
        return (X)this.querySpecification.createSelectPlan(this.firstResult, this.maxResults).getSingleResultOrNull();
    }

    public TypedQuery<X> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        this.getDelegate().setCacheRetrieveMode(cacheRetrieveMode);
        return this;
    }

    public TypedQuery<X> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        this.getDelegate().setCacheStoreMode(cacheStoreMode);
        return this;
    }

    public TypedQuery<X> setTimeout(Integer timeout) {
        this.getDelegate().setTimeout(timeout);
        return this;
    }

    public int executeUpdate() {
        throw new IllegalArgumentException("Can not call executeUpdate on a select query!");
    }

    public TypedQuery<X> setHint(String hintName, Object value) {
        this.delegate.setHint(hintName, value);
        return this;
    }

    public Map<String, Object> getHints() {
        return this.delegate.getHints();
    }

    public TypedQuery<X> setFlushMode(FlushModeType flushMode) {
        this.delegate.setFlushMode(flushMode);
        return this;
    }

    public FlushModeType getFlushMode() {
        return this.delegate.getFlushMode();
    }

    public TypedQuery<X> setLockMode(LockModeType lockMode) {
        this.delegate.setLockMode(lockMode);
        return this;
    }

    public LockModeType getLockMode() {
        return this.delegate.getLockMode();
    }

    public <T> T unwrap(Class<T> cls) {
        if (this.querySpecification.getParticipatingQueries().size() > 1) {
            throw new PersistenceException("Unsupported unwrap: " + cls.getName());
        }
        return (T)this.delegate.unwrap(cls);
    }

    public TypedQuery<X> setMaxResults(int maxResults) {
        super.setMaxResults(maxResults);
        return this;
    }

    public TypedQuery<X> setFirstResult(int startPosition) {
        super.setFirstResult(startPosition);
        return this;
    }

    public <T> TypedQuery<X> setParameter(Parameter<T> param, T value) {
        super.setParameter(param, value);
        return this;
    }

    public TypedQuery<X> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    public TypedQuery<X> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    public TypedQuery<X> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    public TypedQuery<X> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    public TypedQuery<X> setParameter(String name, Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    public TypedQuery<X> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    public TypedQuery<X> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    public TypedQuery<X> setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    public Stream<X> getResultStream() {
        this.bindParameters();
        return this.querySpecification.createSelectPlan(this.firstResult, this.maxResults).getResultStream();
    }
}

