/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.query;

import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.impl.query.TypedQueryWrapper;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.ParameterExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class ObjectBuilderTypedQuery<X>
extends TypedQueryWrapper<X> {
    private final ObjectBuilder<X> builder;

    public ObjectBuilderTypedQuery(TypedQuery<?> delegate, Map<ParameterExpression<?>, String> criteriaNameMapping, ObjectBuilder<X> builder) {
        super(delegate, criteriaNameMapping);
        this.builder = builder;
    }

    @Override
    public X getSingleResult() {
        List<X> list = this.getResultList();
        switch (list.size()) {
            case 0: {
                throw new NoResultException("No results for query: " + this.delegate);
            }
            case 1: {
                return list.get(0);
            }
        }
        throw new NonUniqueResultException("Expected a single result for query: " + this.delegate);
    }

    @Override
    public X getSingleResultOrNull() {
        List<X> list = this.getResultList();
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        throw new NonUniqueResultException("Expected a single result for query: " + this.delegate);
    }

    @Override
    public List<X> getResultList() {
        List list = super.getResultList();
        int size = list.size();
        ArrayList<Object> newList = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object tuple = list.get(i);
            if (tuple instanceof Object[]) {
                newList.add(this.builder.build((Object[])tuple));
                continue;
            }
            newList.add(this.builder.build(new Object[]{tuple}));
        }
        return this.builder.buildList(newList);
    }

    @Override
    public Stream<X> getResultStream() {
        final Stream resultStream = super.getResultStream();
        return (Stream)resultStream.map(new Function<X, X>(){

            @Override
            public X apply(X tuple) {
                Object[] array = tuple instanceof Object[] ? (Object[])tuple : new Object[]{tuple};
                Object result = ObjectBuilderTypedQuery.this.builder.build(array);
                if (result == array) {
                    throw new UnsupportedOperationException("Object builder is not streaming capable: " + ObjectBuilderTypedQuery.this.builder);
                }
                return result;
            }
        }).onClose(new Runnable(){

            @Override
            public void run() {
                resultStream.close();
            }
        });
    }
}

